/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market;

import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.currency.CurrencyPair;
import com.opengamma.strata.basics.currency.FxRate;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.data.scenario.MarketDataBox;
import com.opengamma.strata.data.scenario.ScenarioPerturbation;
import com.opengamma.strata.market.ShiftType;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BeanDefinition(builderScope="private", constructorScope="package")
public final class FxRateShifts
implements ScenarioPerturbation<FxRate>,
ImmutableBean,
Serializable {
    private static final Logger log = LoggerFactory.getLogger(FxRateShifts.class);
    @PropertyDefinition(validate="notNull")
    private final ShiftType shiftType;
    @PropertyDefinition(validate="notNull")
    private final DoubleArray shiftAmount;
    @PropertyDefinition(validate="notNull")
    private final CurrencyPair currencyPair;
    private static final long serialVersionUID = 1L;

    public static FxRateShifts of(ShiftType shiftType, DoubleArray shiftAmount, CurrencyPair currencyPair) {
        return new FxRateShifts(shiftType, shiftAmount, currencyPair);
    }

    public MarketDataBox<FxRate> applyTo(MarketDataBox<FxRate> marketData, ReferenceData refData) {
        log.debug("Applying {} shift to FX rate '{}'", (Object)this.shiftType, (Object)((FxRate)marketData.getValue(0)).getPair().toString());
        return marketData.mapWithIndex(this.getScenarioCount(), (fxRate, scenarioIndex) -> FxRate.of((CurrencyPair)this.currencyPair, (double)this.shiftType.applyShift(fxRate.fxRate(this.currencyPair), this.shiftAmount.get(scenarioIndex))));
    }

    public int getScenarioCount() {
        return this.shiftAmount.size();
    }

    public Class<FxRate> getMarketDataType() {
        return FxRate.class;
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    FxRateShifts(ShiftType shiftType, DoubleArray shiftAmount, CurrencyPair currencyPair) {
        JodaBeanUtils.notNull((Object)((Object)shiftType), (String)"shiftType");
        JodaBeanUtils.notNull((Object)shiftAmount, (String)"shiftAmount");
        JodaBeanUtils.notNull((Object)currencyPair, (String)"currencyPair");
        this.shiftType = shiftType;
        this.shiftAmount = shiftAmount;
        this.currencyPair = currencyPair;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public ShiftType getShiftType() {
        return this.shiftType;
    }

    public DoubleArray getShiftAmount() {
        return this.shiftAmount;
    }

    public CurrencyPair getCurrencyPair() {
        return this.currencyPair;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            FxRateShifts other = (FxRateShifts)obj;
            return JodaBeanUtils.equal((Object)((Object)this.shiftType), (Object)((Object)other.shiftType)) && JodaBeanUtils.equal((Object)this.shiftAmount, (Object)other.shiftAmount) && JodaBeanUtils.equal((Object)this.currencyPair, (Object)other.currencyPair);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.shiftType));
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.shiftAmount);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.currencyPair);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("FxRateShifts{");
        buf.append("shiftType").append('=').append(JodaBeanUtils.toString((Object)((Object)this.shiftType))).append(',').append(' ');
        buf.append("shiftAmount").append('=').append(JodaBeanUtils.toString((Object)this.shiftAmount)).append(',').append(' ');
        buf.append("currencyPair").append('=').append(JodaBeanUtils.toString((Object)this.currencyPair));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<FxRateShifts> {
        private ShiftType shiftType;
        private DoubleArray shiftAmount;
        private CurrencyPair currencyPair;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 893345500: {
                    return this.shiftType;
                }
                case -1043480710: {
                    return this.shiftAmount;
                }
                case 1005147787: {
                    return this.currencyPair;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 893345500: {
                    this.shiftType = (ShiftType)((Object)newValue);
                    break;
                }
                case -1043480710: {
                    this.shiftAmount = (DoubleArray)newValue;
                    break;
                }
                case 1005147787: {
                    this.currencyPair = (CurrencyPair)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public FxRateShifts build() {
            return new FxRateShifts(this.shiftType, this.shiftAmount, this.currencyPair);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(128);
            buf.append("FxRateShifts.Builder{");
            buf.append("shiftType").append('=').append(JodaBeanUtils.toString((Object)((Object)this.shiftType))).append(',').append(' ');
            buf.append("shiftAmount").append('=').append(JodaBeanUtils.toString((Object)this.shiftAmount)).append(',').append(' ');
            buf.append("currencyPair").append('=').append(JodaBeanUtils.toString((Object)this.currencyPair));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<ShiftType> shiftType = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"shiftType", FxRateShifts.class, ShiftType.class);
        private final MetaProperty<DoubleArray> shiftAmount = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"shiftAmount", FxRateShifts.class, DoubleArray.class);
        private final MetaProperty<CurrencyPair> currencyPair = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"currencyPair", FxRateShifts.class, CurrencyPair.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"shiftType", "shiftAmount", "currencyPair"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 893345500: {
                    return this.shiftType;
                }
                case -1043480710: {
                    return this.shiftAmount;
                }
                case 1005147787: {
                    return this.currencyPair;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends FxRateShifts> builder() {
            return new Builder();
        }

        public Class<? extends FxRateShifts> beanType() {
            return FxRateShifts.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<ShiftType> shiftType() {
            return this.shiftType;
        }

        public MetaProperty<DoubleArray> shiftAmount() {
            return this.shiftAmount;
        }

        public MetaProperty<CurrencyPair> currencyPair() {
            return this.currencyPair;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 893345500: {
                    return ((FxRateShifts)bean).getShiftType();
                }
                case -1043480710: {
                    return ((FxRateShifts)bean).getShiftAmount();
                }
                case 1005147787: {
                    return ((FxRateShifts)bean).getCurrencyPair();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

