/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market;

import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.data.scenario.MarketDataBox;
import com.opengamma.strata.data.scenario.ScenarioPerturbation;
import com.opengamma.strata.market.ShiftType;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private", constructorScope="package")
public final class GenericDoubleShifts
implements ScenarioPerturbation<Double>,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final ShiftType shiftType;
    @PropertyDefinition(validate="notNull")
    private final DoubleArray shiftAmount;
    @PropertyDefinition(validate="notNull")
    private final double spread;
    private static final long serialVersionUID = 1L;

    public static GenericDoubleShifts of(ShiftType shiftType, DoubleArray shiftAmount) {
        return new GenericDoubleShifts(shiftType, shiftAmount, 0.0);
    }

    public static GenericDoubleShifts of(ShiftType shiftType, DoubleArray shiftAmount, double spread) {
        return new GenericDoubleShifts(shiftType, shiftAmount, spread);
    }

    public MarketDataBox<Double> applyTo(MarketDataBox<Double> marketData, ReferenceData refData) {
        return marketData.mapWithIndex(this.getScenarioCount(), (value, scenarioIndex) -> this.shiftType.applyShift(value + this.spread, this.shiftAmount.get(scenarioIndex)) - this.spread);
    }

    public int getScenarioCount() {
        return this.shiftAmount.size();
    }

    public Class<Double> getMarketDataType() {
        return Double.class;
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    GenericDoubleShifts(ShiftType shiftType, DoubleArray shiftAmount, double spread) {
        JodaBeanUtils.notNull((Object)((Object)shiftType), (String)"shiftType");
        JodaBeanUtils.notNull((Object)shiftAmount, (String)"shiftAmount");
        JodaBeanUtils.notNull((Object)spread, (String)"spread");
        this.shiftType = shiftType;
        this.shiftAmount = shiftAmount;
        this.spread = spread;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public ShiftType getShiftType() {
        return this.shiftType;
    }

    public DoubleArray getShiftAmount() {
        return this.shiftAmount;
    }

    public double getSpread() {
        return this.spread;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            GenericDoubleShifts other = (GenericDoubleShifts)obj;
            return JodaBeanUtils.equal((Object)((Object)this.shiftType), (Object)((Object)other.shiftType)) && JodaBeanUtils.equal((Object)this.shiftAmount, (Object)other.shiftAmount) && JodaBeanUtils.equal((double)this.spread, (double)other.spread);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.shiftType));
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.shiftAmount);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.spread);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("GenericDoubleShifts{");
        buf.append("shiftType").append('=').append(JodaBeanUtils.toString((Object)((Object)this.shiftType))).append(',').append(' ');
        buf.append("shiftAmount").append('=').append(JodaBeanUtils.toString((Object)this.shiftAmount)).append(',').append(' ');
        buf.append("spread").append('=').append(JodaBeanUtils.toString((Object)this.spread));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<GenericDoubleShifts> {
        private ShiftType shiftType;
        private DoubleArray shiftAmount;
        private double spread;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 893345500: {
                    return this.shiftType;
                }
                case -1043480710: {
                    return this.shiftAmount;
                }
                case -895684237: {
                    return this.spread;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 893345500: {
                    this.shiftType = (ShiftType)((Object)newValue);
                    break;
                }
                case -1043480710: {
                    this.shiftAmount = (DoubleArray)newValue;
                    break;
                }
                case -895684237: {
                    this.spread = (Double)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public GenericDoubleShifts build() {
            return new GenericDoubleShifts(this.shiftType, this.shiftAmount, this.spread);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(128);
            buf.append("GenericDoubleShifts.Builder{");
            buf.append("shiftType").append('=').append(JodaBeanUtils.toString((Object)((Object)this.shiftType))).append(',').append(' ');
            buf.append("shiftAmount").append('=').append(JodaBeanUtils.toString((Object)this.shiftAmount)).append(',').append(' ');
            buf.append("spread").append('=').append(JodaBeanUtils.toString((Object)this.spread));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<ShiftType> shiftType = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"shiftType", GenericDoubleShifts.class, ShiftType.class);
        private final MetaProperty<DoubleArray> shiftAmount = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"shiftAmount", GenericDoubleShifts.class, DoubleArray.class);
        private final MetaProperty<Double> spread = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"spread", GenericDoubleShifts.class, Double.TYPE);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"shiftType", "shiftAmount", "spread"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 893345500: {
                    return this.shiftType;
                }
                case -1043480710: {
                    return this.shiftAmount;
                }
                case -895684237: {
                    return this.spread;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends GenericDoubleShifts> builder() {
            return new Builder();
        }

        public Class<? extends GenericDoubleShifts> beanType() {
            return GenericDoubleShifts.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<ShiftType> shiftType() {
            return this.shiftType;
        }

        public MetaProperty<DoubleArray> shiftAmount() {
            return this.shiftAmount;
        }

        public MetaProperty<Double> spread() {
            return this.spread;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 893345500: {
                    return ((GenericDoubleShifts)bean).getShiftType();
                }
                case -1043480710: {
                    return ((GenericDoubleShifts)bean).getShiftAmount();
                }
                case -895684237: {
                    return ((GenericDoubleShifts)bean).getSpread();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

