/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market;

import com.opengamma.strata.basics.value.ValueAdjustment;
import com.opengamma.strata.collect.named.EnumNames;
import com.opengamma.strata.collect.named.NamedEnum;
import org.joda.convert.FromString;
import org.joda.convert.ToString;

public enum ShiftType implements NamedEnum
{
    RELATIVE{

        @Override
        public double applyShift(double value, double shiftAmount) {
            return value + value * shiftAmount;
        }

        @Override
        public ValueAdjustment toValueAdjustment(double shiftAmount) {
            return ValueAdjustment.ofDeltaMultiplier((double)shiftAmount);
        }

        @Override
        public double computeShift(double baseValue, double shiftedValue) {
            return shiftedValue / baseValue - 1.0;
        }
    }
    ,
    ABSOLUTE{

        @Override
        public double applyShift(double value, double shiftAmount) {
            return value + shiftAmount;
        }

        @Override
        public ValueAdjustment toValueAdjustment(double shiftAmount) {
            return ValueAdjustment.ofDeltaAmount((double)shiftAmount);
        }

        @Override
        public double computeShift(double baseValue, double shiftedValue) {
            return shiftedValue - baseValue;
        }
    }
    ,
    SCALED{

        @Override
        public double applyShift(double value, double shiftAmount) {
            return value * shiftAmount;
        }

        @Override
        public ValueAdjustment toValueAdjustment(double shiftAmount) {
            return ValueAdjustment.ofMultiplier((double)shiftAmount);
        }

        @Override
        public double computeShift(double baseValue, double shiftedValue) {
            return shiftedValue / baseValue;
        }
    };

    private static final EnumNames<ShiftType> NAMES;

    @FromString
    public static ShiftType of(String name) {
        return (ShiftType)NAMES.parse(name);
    }

    public abstract double applyShift(double var1, double var3);

    public abstract ValueAdjustment toValueAdjustment(double var1);

    public abstract double computeShift(double var1, double var3);

    @ToString
    public String toString() {
        return NAMES.format((Enum)this);
    }

    static {
        NAMES = EnumNames.of(ShiftType.class);
    }
}

