/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.amount;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.currency.FxRateProvider;
import com.opengamma.strata.market.amount.LegAmount;
import com.opengamma.strata.product.common.PayReceive;
import com.opengamma.strata.product.swap.ResolvedSwapLeg;
import com.opengamma.strata.product.swap.SwapLegType;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class SwapLegAmount
implements LegAmount,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final CurrencyAmount amount;
    @PropertyDefinition(validate="notNull")
    private final PayReceive payReceive;
    @PropertyDefinition(validate="notNull")
    private final SwapLegType type;
    @PropertyDefinition(validate="notNull")
    private final Currency currency;
    private static final long serialVersionUID = 1L;

    public static SwapLegAmount of(ResolvedSwapLeg leg, CurrencyAmount amount) {
        return SwapLegAmount.builder().amount(amount).payReceive(leg.getPayReceive()).type(leg.getType()).currency(leg.getCurrency()).build();
    }

    public SwapLegAmount convertedTo(Currency resultCurrency, FxRateProvider rateProvider) {
        CurrencyAmount convertedAmount = this.amount.convertedTo(resultCurrency, rateProvider);
        return this.toBuilder().amount(convertedAmount).build();
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private SwapLegAmount(CurrencyAmount amount, PayReceive payReceive, SwapLegType type, Currency currency) {
        JodaBeanUtils.notNull((Object)amount, (String)"amount");
        JodaBeanUtils.notNull((Object)payReceive, (String)"payReceive");
        JodaBeanUtils.notNull((Object)type, (String)"type");
        JodaBeanUtils.notNull((Object)currency, (String)"currency");
        this.amount = amount;
        this.payReceive = payReceive;
        this.type = type;
        this.currency = currency;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public CurrencyAmount getAmount() {
        return this.amount;
    }

    public PayReceive getPayReceive() {
        return this.payReceive;
    }

    public SwapLegType getType() {
        return this.type;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            SwapLegAmount other = (SwapLegAmount)obj;
            return JodaBeanUtils.equal((Object)this.amount, (Object)other.amount) && JodaBeanUtils.equal((Object)this.payReceive, (Object)other.payReceive) && JodaBeanUtils.equal((Object)this.type, (Object)other.type) && JodaBeanUtils.equal((Object)this.currency, (Object)other.currency);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.amount);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.payReceive);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.type);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.currency);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(160);
        buf.append("SwapLegAmount{");
        buf.append("amount").append('=').append(JodaBeanUtils.toString((Object)this.amount)).append(',').append(' ');
        buf.append("payReceive").append('=').append(JodaBeanUtils.toString((Object)this.payReceive)).append(',').append(' ');
        buf.append("type").append('=').append(JodaBeanUtils.toString((Object)this.type)).append(',').append(' ');
        buf.append("currency").append('=').append(JodaBeanUtils.toString((Object)this.currency));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<SwapLegAmount> {
        private CurrencyAmount amount;
        private PayReceive payReceive;
        private SwapLegType type;
        private Currency currency;

        private Builder() {
        }

        private Builder(SwapLegAmount beanToCopy) {
            this.amount = beanToCopy.getAmount();
            this.payReceive = beanToCopy.getPayReceive();
            this.type = beanToCopy.getType();
            this.currency = beanToCopy.getCurrency();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case -1413853096: {
                    return this.amount;
                }
                case -885469925: {
                    return this.payReceive;
                }
                case 3575610: {
                    return this.type;
                }
                case 575402001: {
                    return this.currency;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case -1413853096: {
                    this.amount = (CurrencyAmount)newValue;
                    break;
                }
                case -885469925: {
                    this.payReceive = (PayReceive)newValue;
                    break;
                }
                case 3575610: {
                    this.type = (SwapLegType)newValue;
                    break;
                }
                case 575402001: {
                    this.currency = (Currency)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public SwapLegAmount build() {
            return new SwapLegAmount(this.amount, this.payReceive, this.type, this.currency);
        }

        public Builder amount(CurrencyAmount amount) {
            JodaBeanUtils.notNull((Object)amount, (String)"amount");
            this.amount = amount;
            return this;
        }

        public Builder payReceive(PayReceive payReceive) {
            JodaBeanUtils.notNull((Object)payReceive, (String)"payReceive");
            this.payReceive = payReceive;
            return this;
        }

        public Builder type(SwapLegType type) {
            JodaBeanUtils.notNull((Object)type, (String)"type");
            this.type = type;
            return this;
        }

        public Builder currency(Currency currency) {
            JodaBeanUtils.notNull((Object)currency, (String)"currency");
            this.currency = currency;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(160);
            buf.append("SwapLegAmount.Builder{");
            buf.append("amount").append('=').append(JodaBeanUtils.toString((Object)this.amount)).append(',').append(' ');
            buf.append("payReceive").append('=').append(JodaBeanUtils.toString((Object)this.payReceive)).append(',').append(' ');
            buf.append("type").append('=').append(JodaBeanUtils.toString((Object)this.type)).append(',').append(' ');
            buf.append("currency").append('=').append(JodaBeanUtils.toString((Object)this.currency));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<CurrencyAmount> amount = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"amount", SwapLegAmount.class, CurrencyAmount.class);
        private final MetaProperty<PayReceive> payReceive = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"payReceive", SwapLegAmount.class, PayReceive.class);
        private final MetaProperty<SwapLegType> type = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"type", SwapLegAmount.class, SwapLegType.class);
        private final MetaProperty<Currency> currency = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"currency", SwapLegAmount.class, Currency.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"amount", "payReceive", "type", "currency"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case -1413853096: {
                    return this.amount;
                }
                case -885469925: {
                    return this.payReceive;
                }
                case 3575610: {
                    return this.type;
                }
                case 575402001: {
                    return this.currency;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends SwapLegAmount> beanType() {
            return SwapLegAmount.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<CurrencyAmount> amount() {
            return this.amount;
        }

        public MetaProperty<PayReceive> payReceive() {
            return this.payReceive;
        }

        public MetaProperty<SwapLegType> type() {
            return this.type;
        }

        public MetaProperty<Currency> currency() {
            return this.currency;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case -1413853096: {
                    return ((SwapLegAmount)bean).getAmount();
                }
                case -885469925: {
                    return ((SwapLegAmount)bean).getPayReceive();
                }
                case 3575610: {
                    return ((SwapLegAmount)bean).getType();
                }
                case 575402001: {
                    return ((SwapLegAmount)bean).getCurrency();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

