/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.curve;

import com.google.common.collect.ImmutableList;
import com.opengamma.strata.market.curve.Curve;
import com.opengamma.strata.market.curve.CurveMetadata;
import com.opengamma.strata.market.param.ParameterMetadata;
import com.opengamma.strata.market.param.ParameterPerturbation;
import com.opengamma.strata.market.param.UnitParameterSensitivity;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class AddFixedCurve
implements Curve,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final Curve fixedCurve;
    @PropertyDefinition(validate="notNull")
    private final Curve spreadCurve;
    private static final long serialVersionUID = 1L;

    public static AddFixedCurve of(Curve fixedCurve, Curve spreadCurve) {
        return new AddFixedCurve(fixedCurve, spreadCurve);
    }

    @Override
    public CurveMetadata getMetadata() {
        return this.spreadCurve.getMetadata();
    }

    @Override
    public AddFixedCurve withMetadata(CurveMetadata metadata) {
        return new AddFixedCurve(this.fixedCurve, this.spreadCurve.withMetadata(metadata));
    }

    @Override
    public int getParameterCount() {
        return this.spreadCurve.getParameterCount();
    }

    @Override
    public double getParameter(int parameterIndex) {
        return this.spreadCurve.getParameter(parameterIndex);
    }

    @Override
    public ParameterMetadata getParameterMetadata(int parameterIndex) {
        return this.spreadCurve.getParameterMetadata(parameterIndex);
    }

    @Override
    public AddFixedCurve withParameter(int parameterIndex, double newValue) {
        return new AddFixedCurve(this.fixedCurve, this.spreadCurve.withParameter(parameterIndex, newValue));
    }

    @Override
    public AddFixedCurve withPerturbation(ParameterPerturbation perturbation) {
        return new AddFixedCurve(this.fixedCurve, this.spreadCurve.withPerturbation(perturbation));
    }

    @Override
    public double yValue(double x) {
        return this.fixedCurve.yValue(x) + this.spreadCurve.yValue(x);
    }

    @Override
    public UnitParameterSensitivity yValueParameterSensitivity(double x) {
        return this.spreadCurve.yValueParameterSensitivity(x);
    }

    @Override
    public double firstDerivative(double x) {
        return this.fixedCurve.firstDerivative(x) + this.spreadCurve.firstDerivative(x);
    }

    @Override
    public ImmutableList<Curve> split() {
        return ImmutableList.of((Object)this.fixedCurve, (Object)this.spreadCurve);
    }

    @Override
    public AddFixedCurve withUnderlyingCurve(int curveIndex, Curve curve) {
        if (curveIndex == 0) {
            return new AddFixedCurve(curve, this.spreadCurve);
        }
        if (curveIndex == 1) {
            return new AddFixedCurve(this.fixedCurve, curve);
        }
        throw new IllegalArgumentException("curveIndex is outside the range");
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private AddFixedCurve(Curve fixedCurve, Curve spreadCurve) {
        JodaBeanUtils.notNull((Object)fixedCurve, (String)"fixedCurve");
        JodaBeanUtils.notNull((Object)spreadCurve, (String)"spreadCurve");
        this.fixedCurve = fixedCurve;
        this.spreadCurve = spreadCurve;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public Curve getFixedCurve() {
        return this.fixedCurve;
    }

    public Curve getSpreadCurve() {
        return this.spreadCurve;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            AddFixedCurve other = (AddFixedCurve)obj;
            return JodaBeanUtils.equal((Object)this.fixedCurve, (Object)other.fixedCurve) && JodaBeanUtils.equal((Object)this.spreadCurve, (Object)other.spreadCurve);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.fixedCurve);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.spreadCurve);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(96);
        buf.append("AddFixedCurve{");
        buf.append("fixedCurve").append('=').append(JodaBeanUtils.toString((Object)this.fixedCurve)).append(',').append(' ');
        buf.append("spreadCurve").append('=').append(JodaBeanUtils.toString((Object)this.spreadCurve));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<AddFixedCurve> {
        private Curve fixedCurve;
        private Curve spreadCurve;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 1682092507: {
                    return this.fixedCurve;
                }
                case 2130054972: {
                    return this.spreadCurve;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 1682092507: {
                    this.fixedCurve = (Curve)newValue;
                    break;
                }
                case 2130054972: {
                    this.spreadCurve = (Curve)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public AddFixedCurve build() {
            return new AddFixedCurve(this.fixedCurve, this.spreadCurve);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(96);
            buf.append("AddFixedCurve.Builder{");
            buf.append("fixedCurve").append('=').append(JodaBeanUtils.toString((Object)this.fixedCurve)).append(',').append(' ');
            buf.append("spreadCurve").append('=').append(JodaBeanUtils.toString((Object)this.spreadCurve));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<Curve> fixedCurve = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"fixedCurve", AddFixedCurve.class, Curve.class);
        private final MetaProperty<Curve> spreadCurve = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"spreadCurve", AddFixedCurve.class, Curve.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"fixedCurve", "spreadCurve"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 1682092507: {
                    return this.fixedCurve;
                }
                case 2130054972: {
                    return this.spreadCurve;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends AddFixedCurve> builder() {
            return new Builder();
        }

        public Class<? extends AddFixedCurve> beanType() {
            return AddFixedCurve.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<Curve> fixedCurve() {
            return this.fixedCurve;
        }

        public MetaProperty<Curve> spreadCurve() {
            return this.spreadCurve;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 1682092507: {
                    return ((AddFixedCurve)bean).getFixedCurve();
                }
                case 2130054972: {
                    return ((AddFixedCurve)bean).getSpreadCurve();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

