/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.curve;

import com.google.common.collect.ImmutableList;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.market.curve.CurveMetadata;
import com.opengamma.strata.market.curve.NodalCurve;
import com.opengamma.strata.market.param.CurrencyParameterSensitivity;
import com.opengamma.strata.market.param.ParameterMetadata;
import com.opengamma.strata.market.param.ParameterPerturbation;
import com.opengamma.strata.market.param.UnitParameterSensitivity;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableConstructor;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class ConstantNodalCurve
implements NodalCurve,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final CurveMetadata metadata;
    @PropertyDefinition(validate="notNull")
    private final double xValue;
    @PropertyDefinition(validate="notNull")
    private final double yValue;
    private final transient List<ParameterMetadata> parameterMetadata;
    private static final long serialVersionUID = 1L;

    public static ConstantNodalCurve of(CurveMetadata metadata, double xValue, double yValue) {
        return new ConstantNodalCurve(metadata, xValue, yValue);
    }

    @ImmutableConstructor
    private ConstantNodalCurve(CurveMetadata metadata, double xValue, double yValue) {
        JodaBeanUtils.notNull((Object)metadata, (String)"metadata");
        metadata.getParameterMetadata().ifPresent(params -> {
            if (params.size() != 1) {
                throw new IllegalArgumentException("Length of parameter metadata must be 1");
            }
        });
        this.metadata = metadata;
        this.xValue = xValue;
        this.yValue = yValue;
        this.parameterMetadata = ImmutableList.of((Object)this.getParameterMetadata(0));
    }

    private Object readResolve() {
        return new ConstantNodalCurve(this.metadata, this.xValue, this.yValue);
    }

    @Override
    public int getParameterCount() {
        return 1;
    }

    @Override
    public double getParameter(int parameterIndex) {
        ArgChecker.isTrue((parameterIndex == 0 ? 1 : 0) != 0, (String)"single parameter");
        return this.yValue;
    }

    @Override
    public ConstantNodalCurve withParameter(int parameterIndex, double newValue) {
        ArgChecker.isTrue((parameterIndex == 0 ? 1 : 0) != 0, (String)"single parameter");
        return new ConstantNodalCurve(this.metadata, this.xValue, newValue);
    }

    @Override
    public ConstantNodalCurve withPerturbation(ParameterPerturbation perturbation) {
        double perturbedValue = perturbation.perturbParameter(0, this.yValue, this.getParameterMetadata(0));
        return new ConstantNodalCurve(this.metadata, this.xValue, perturbedValue);
    }

    @Override
    public DoubleArray getXValues() {
        return DoubleArray.of((double)this.xValue);
    }

    @Override
    public DoubleArray getYValues() {
        return DoubleArray.of((double)this.yValue);
    }

    @Override
    public double yValue(double x) {
        return this.yValue;
    }

    @Override
    public UnitParameterSensitivity yValueParameterSensitivity(double x) {
        return this.createParameterSensitivity(DoubleArray.of((double)1.0));
    }

    @Override
    public double firstDerivative(double x) {
        return 0.0;
    }

    @Override
    public ConstantNodalCurve withMetadata(CurveMetadata metadata) {
        return new ConstantNodalCurve(metadata, this.xValue, this.yValue);
    }

    @Override
    public ConstantNodalCurve withYValues(DoubleArray yValues) {
        ArgChecker.isTrue((yValues.size() == 1 ? 1 : 0) != 0, (String)"Invalid number of parameters, only one allowed");
        return new ConstantNodalCurve(this.metadata, this.xValue, yValues.get(0));
    }

    @Override
    public ConstantNodalCurve withValues(DoubleArray xValues, DoubleArray yValues) {
        ArgChecker.isTrue((xValues.size() == 1 && yValues.size() == 1 ? 1 : 0) != 0, (String)"Invalid number of parameters, only one allowed");
        return new ConstantNodalCurve(this.metadata, xValues.get(0), yValues.get(0));
    }

    @Override
    public ConstantNodalCurve withNode(double x, double y, ParameterMetadata paramMetadata) {
        ArgChecker.isTrue((x == this.xValue ? 1 : 0) != 0, (String)"x should be equal to the existing x-value");
        CurveMetadata md = this.metadata.withParameterMetadata((List<? extends ParameterMetadata>)ImmutableList.of((Object)paramMetadata));
        return new ConstantNodalCurve(md, x, y);
    }

    @Override
    public UnitParameterSensitivity createParameterSensitivity(DoubleArray sensitivities) {
        return UnitParameterSensitivity.of(this.getName(), this.parameterMetadata, sensitivities);
    }

    @Override
    public CurrencyParameterSensitivity createParameterSensitivity(Currency currency, DoubleArray sensitivities) {
        return CurrencyParameterSensitivity.of(this.getName(), this.parameterMetadata, currency, sensitivities);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public CurveMetadata getMetadata() {
        return this.metadata;
    }

    public double getXValue() {
        return this.xValue;
    }

    public double getYValue() {
        return this.yValue;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            ConstantNodalCurve other = (ConstantNodalCurve)obj;
            return JodaBeanUtils.equal((Object)this.metadata, (Object)other.metadata) && JodaBeanUtils.equal((double)this.xValue, (double)other.xValue) && JodaBeanUtils.equal((double)this.yValue, (double)other.yValue);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.metadata);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.xValue);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.yValue);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("ConstantNodalCurve{");
        buf.append("metadata").append('=').append(JodaBeanUtils.toString((Object)this.metadata)).append(',').append(' ');
        buf.append("xValue").append('=').append(JodaBeanUtils.toString((Object)this.xValue)).append(',').append(' ');
        buf.append("yValue").append('=').append(JodaBeanUtils.toString((Object)this.yValue));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<ConstantNodalCurve> {
        private CurveMetadata metadata;
        private double xValue;
        private double yValue;

        private Builder() {
        }

        private Builder(ConstantNodalCurve beanToCopy) {
            this.metadata = beanToCopy.getMetadata();
            this.xValue = beanToCopy.getXValue();
            this.yValue = beanToCopy.getYValue();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case -450004177: {
                    return this.metadata;
                }
                case -777049127: {
                    return this.xValue;
                }
                case -748419976: {
                    return this.yValue;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case -450004177: {
                    this.metadata = (CurveMetadata)newValue;
                    break;
                }
                case -777049127: {
                    this.xValue = (Double)newValue;
                    break;
                }
                case -748419976: {
                    this.yValue = (Double)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public ConstantNodalCurve build() {
            return new ConstantNodalCurve(this.metadata, this.xValue, this.yValue);
        }

        public Builder metadata(CurveMetadata metadata) {
            JodaBeanUtils.notNull((Object)metadata, (String)"metadata");
            this.metadata = metadata;
            return this;
        }

        public Builder xValue(double xValue) {
            JodaBeanUtils.notNull((Object)xValue, (String)"xValue");
            this.xValue = xValue;
            return this;
        }

        public Builder yValue(double yValue) {
            JodaBeanUtils.notNull((Object)yValue, (String)"yValue");
            this.yValue = yValue;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(128);
            buf.append("ConstantNodalCurve.Builder{");
            buf.append("metadata").append('=').append(JodaBeanUtils.toString((Object)this.metadata)).append(',').append(' ');
            buf.append("xValue").append('=').append(JodaBeanUtils.toString((Object)this.xValue)).append(',').append(' ');
            buf.append("yValue").append('=').append(JodaBeanUtils.toString((Object)this.yValue));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<CurveMetadata> metadata = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"metadata", ConstantNodalCurve.class, CurveMetadata.class);
        private final MetaProperty<Double> xValue = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"xValue", ConstantNodalCurve.class, Double.TYPE);
        private final MetaProperty<Double> yValue = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"yValue", ConstantNodalCurve.class, Double.TYPE);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"metadata", "xValue", "yValue"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case -450004177: {
                    return this.metadata;
                }
                case -777049127: {
                    return this.xValue;
                }
                case -748419976: {
                    return this.yValue;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends ConstantNodalCurve> beanType() {
            return ConstantNodalCurve.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<CurveMetadata> metadata() {
            return this.metadata;
        }

        public MetaProperty<Double> xValue() {
            return this.xValue;
        }

        public MetaProperty<Double> yValue() {
            return this.yValue;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case -450004177: {
                    return ((ConstantNodalCurve)bean).getMetadata();
                }
                case -777049127: {
                    return ((ConstantNodalCurve)bean).getXValue();
                }
                case -748419976: {
                    return ((ConstantNodalCurve)bean).getYValue();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

