/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.curve;

import com.google.common.collect.ImmutableList;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.collect.Guavate;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.market.curve.CurveMetadata;
import com.opengamma.strata.market.curve.CurveName;
import com.opengamma.strata.market.param.CurrencyParameterSensitivity;
import com.opengamma.strata.market.param.ParameterMetadata;
import com.opengamma.strata.market.param.ParameterPerturbation;
import com.opengamma.strata.market.param.ParameterizedData;
import com.opengamma.strata.market.param.UnitParameterSensitivity;
import java.util.List;
import java.util.OptionalInt;
import java.util.stream.IntStream;

public interface Curve
extends ParameterizedData {
    public CurveMetadata getMetadata();

    public Curve withMetadata(CurveMetadata var1);

    default public CurveName getName() {
        return this.getMetadata().getCurveName();
    }

    @Override
    default public ParameterMetadata getParameterMetadata(int parameterIndex) {
        return this.getMetadata().getParameterMetadata(parameterIndex);
    }

    @Override
    default public OptionalInt findParameterIndex(ParameterMetadata metadata) {
        return this.getMetadata().findParameterIndex(metadata);
    }

    @Override
    public Curve withParameter(int var1, double var2);

    @Override
    default public Curve withPerturbation(ParameterPerturbation perturbation) {
        return (Curve)ParameterizedData.super.withPerturbation(perturbation);
    }

    public double yValue(double var1);

    public UnitParameterSensitivity yValueParameterSensitivity(double var1);

    public double firstDerivative(double var1);

    default public UnitParameterSensitivity createParameterSensitivity(DoubleArray sensitivities) {
        List paramMeta = (List)IntStream.range(0, this.getParameterCount()).mapToObj(i -> this.getParameterMetadata(i)).collect(Guavate.toImmutableList());
        return UnitParameterSensitivity.of(this.getName(), paramMeta, sensitivities);
    }

    default public CurrencyParameterSensitivity createParameterSensitivity(Currency currency, DoubleArray sensitivities) {
        List paramMeta = (List)IntStream.range(0, this.getParameterCount()).mapToObj(i -> this.getParameterMetadata(i)).collect(Guavate.toImmutableList());
        return CurrencyParameterSensitivity.of(this.getName(), paramMeta, currency, sensitivities);
    }

    default public ImmutableList<Curve> split() {
        return ImmutableList.of((Object)this);
    }

    default public Curve withUnderlyingCurve(int curveIndex, Curve curve) {
        if (curveIndex == 0) {
            return curve;
        }
        throw new IllegalArgumentException("curveIndex is outside the range");
    }
}

