/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.curve;

import com.google.common.collect.ImmutableList;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.data.MarketData;
import com.opengamma.strata.market.ValueType;
import com.opengamma.strata.market.curve.Curve;
import com.opengamma.strata.market.curve.CurveMetadata;
import com.opengamma.strata.market.curve.CurveName;
import com.opengamma.strata.market.curve.CurveNode;
import com.opengamma.strata.market.curve.CurveParameterSize;
import java.time.LocalDate;

public interface CurveDefinition {
    public CurveName getName();

    public int getParameterCount();

    public ValueType getYValueType();

    public ImmutableList<CurveNode> getNodes();

    public CurveDefinition filtered(LocalDate var1, ReferenceData var2);

    public CurveMetadata metadata(LocalDate var1, ReferenceData var2);

    public Curve curve(LocalDate var1, CurveMetadata var2, DoubleArray var3);

    default public CurveParameterSize toCurveParameterSize() {
        return CurveParameterSize.of(this.getName(), this.getParameterCount());
    }

    public ImmutableList<Double> initialGuess(MarketData var1);
}

