/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.curve;

import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.currency.FxRateProvider;
import com.opengamma.strata.data.MarketData;
import com.opengamma.strata.data.MarketDataId;
import com.opengamma.strata.market.ValueType;
import com.opengamma.strata.market.curve.CurveNodeDateOrder;
import com.opengamma.strata.market.param.DatedParameterMetadata;
import com.opengamma.strata.product.ResolvedTrade;
import com.opengamma.strata.product.Trade;
import java.time.LocalDate;
import java.util.Set;

public interface CurveNode {
    public String getLabel();

    public CurveNodeDateOrder getDateOrder();

    public Set<? extends MarketDataId<?>> requirements();

    public LocalDate date(LocalDate var1, ReferenceData var2);

    public DatedParameterMetadata metadata(LocalDate var1, ReferenceData var2);

    public Trade trade(double var1, MarketData var3, ReferenceData var4);

    public ResolvedTrade resolvedTrade(double var1, MarketData var3, ReferenceData var4);

    default public ResolvedTrade sampleResolvedTrade(LocalDate valuationDate, FxRateProvider fxProvider, ReferenceData refData) {
        throw new UnsupportedOperationException("CurveNode.sampleResolvedTrade() is not supported");
    }

    public double initialGuess(MarketData var1, ValueType var2);
}

