/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.curve;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.market.curve.CurveNodeDateType;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Supplier;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableDefaults;
import org.joda.beans.gen.ImmutableValidator;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class CurveNodeDate
implements ImmutableBean,
Serializable {
    public static final CurveNodeDate END = new CurveNodeDate(CurveNodeDateType.END, null);
    public static final CurveNodeDate LAST_FIXING = new CurveNodeDate(CurveNodeDateType.LAST_FIXING, null);
    @PropertyDefinition
    private final CurveNodeDateType type;
    @PropertyDefinition(get="field")
    private final LocalDate date;
    private static final long serialVersionUID = 1L;

    public static CurveNodeDate of(LocalDate date) {
        return new CurveNodeDate(CurveNodeDateType.FIXED, date);
    }

    @ImmutableDefaults
    private static void applyDefaults(Builder builder) {
        builder.type = CurveNodeDateType.END;
    }

    @ImmutableValidator
    private void validate() {
        if (this.type.equals((Object)CurveNodeDateType.FIXED)) {
            ArgChecker.isTrue((this.date != null ? 1 : 0) != 0, (String)"Date must be present when type is 'Fixed'");
        } else {
            ArgChecker.isTrue((this.date == null ? 1 : 0) != 0, (String)"Date must not be present unless type is 'Fixed'");
        }
    }

    public boolean isEnd() {
        return this.type == CurveNodeDateType.END;
    }

    public boolean isLastFixing() {
        return this.type == CurveNodeDateType.LAST_FIXING;
    }

    public boolean isFixed() {
        return this.type == CurveNodeDateType.FIXED;
    }

    public LocalDate getDate() {
        if (!this.isFixed()) {
            throw new IllegalStateException(Messages.format((String)"No date available for type '{}'", (Object)((Object)this.type)));
        }
        return this.date;
    }

    public LocalDate calculate(Supplier<LocalDate> endDateSupplier, Supplier<LocalDate> lastFixingDateSupplier) {
        switch (this.type) {
            case FIXED: {
                return this.date;
            }
            case END: {
                return endDateSupplier.get();
            }
            case LAST_FIXING: {
                return lastFixingDateSupplier.get();
            }
        }
        throw new IllegalStateException("Unknown curve node type");
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private CurveNodeDate(CurveNodeDateType type, LocalDate date) {
        this.type = type;
        this.date = date;
        this.validate();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public CurveNodeDateType getType() {
        return this.type;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            CurveNodeDate other = (CurveNodeDate)obj;
            return JodaBeanUtils.equal((Object)((Object)this.type), (Object)((Object)other.type)) && JodaBeanUtils.equal((Object)this.date, (Object)other.date);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.type));
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.date);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(96);
        buf.append("CurveNodeDate{");
        buf.append("type").append('=').append(JodaBeanUtils.toString((Object)((Object)this.type))).append(',').append(' ');
        buf.append("date").append('=').append(JodaBeanUtils.toString((Object)this.date));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<CurveNodeDate> {
        private CurveNodeDateType type;
        private LocalDate date;

        private Builder() {
            CurveNodeDate.applyDefaults(this);
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3575610: {
                    return this.type;
                }
                case 3076014: {
                    return this.date;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 3575610: {
                    this.type = (CurveNodeDateType)((Object)newValue);
                    break;
                }
                case 3076014: {
                    this.date = (LocalDate)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public CurveNodeDate build() {
            return new CurveNodeDate(this.type, this.date);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(96);
            buf.append("CurveNodeDate.Builder{");
            buf.append("type").append('=').append(JodaBeanUtils.toString((Object)((Object)this.type))).append(',').append(' ');
            buf.append("date").append('=').append(JodaBeanUtils.toString((Object)this.date));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<CurveNodeDateType> type = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"type", CurveNodeDate.class, CurveNodeDateType.class);
        private final MetaProperty<LocalDate> date = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"date", CurveNodeDate.class, LocalDate.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"type", "date"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3575610: {
                    return this.type;
                }
                case 3076014: {
                    return this.date;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends CurveNodeDate> builder() {
            return new Builder();
        }

        public Class<? extends CurveNodeDate> beanType() {
            return CurveNodeDate.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<CurveNodeDateType> type() {
            return this.type;
        }

        public MetaProperty<LocalDate> date() {
            return this.date;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 3575610: {
                    return ((CurveNodeDate)bean).getType();
                }
                case 3076014: {
                    return ((CurveNodeDate)bean).date;
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

