/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.curve;

import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.market.curve.CurveNodeClashAction;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableValidator;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class CurveNodeDateOrder
implements ImmutableBean,
Serializable {
    public static final CurveNodeDateOrder DEFAULT = new CurveNodeDateOrder(1, CurveNodeClashAction.EXCEPTION);
    @PropertyDefinition
    private final int minGapInDays;
    @PropertyDefinition(validate="notNull")
    private final CurveNodeClashAction action;
    private static final long serialVersionUID = 1L;

    public static CurveNodeDateOrder of(int minGapInDays, CurveNodeClashAction action) {
        return new CurveNodeDateOrder(minGapInDays, action);
    }

    @ImmutableValidator
    private void validate() {
        if (this.minGapInDays < 1) {
            throw new IllegalArgumentException(Messages.format((String)"Minimum gap must be at least one day, but was {}", (Object)this.minGapInDays));
        }
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private CurveNodeDateOrder(int minGapInDays, CurveNodeClashAction action) {
        JodaBeanUtils.notNull((Object)((Object)action), (String)"action");
        this.minGapInDays = minGapInDays;
        this.action = action;
        this.validate();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public int getMinGapInDays() {
        return this.minGapInDays;
    }

    public CurveNodeClashAction getAction() {
        return this.action;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            CurveNodeDateOrder other = (CurveNodeDateOrder)obj;
            return this.minGapInDays == other.minGapInDays && JodaBeanUtils.equal((Object)((Object)this.action), (Object)((Object)other.action));
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((int)this.minGapInDays);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.action));
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(96);
        buf.append("CurveNodeDateOrder{");
        buf.append("minGapInDays").append('=').append(JodaBeanUtils.toString((Object)this.minGapInDays)).append(',').append(' ');
        buf.append("action").append('=').append(JodaBeanUtils.toString((Object)((Object)this.action)));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<CurveNodeDateOrder> {
        private int minGapInDays;
        private CurveNodeClashAction action;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 1925599072: {
                    return this.minGapInDays;
                }
                case -1422950858: {
                    return this.action;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 1925599072: {
                    this.minGapInDays = (Integer)newValue;
                    break;
                }
                case -1422950858: {
                    this.action = (CurveNodeClashAction)((Object)newValue);
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public CurveNodeDateOrder build() {
            return new CurveNodeDateOrder(this.minGapInDays, this.action);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(96);
            buf.append("CurveNodeDateOrder.Builder{");
            buf.append("minGapInDays").append('=').append(JodaBeanUtils.toString((Object)this.minGapInDays)).append(',').append(' ');
            buf.append("action").append('=').append(JodaBeanUtils.toString((Object)((Object)this.action)));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<Integer> minGapInDays = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"minGapInDays", CurveNodeDateOrder.class, Integer.TYPE);
        private final MetaProperty<CurveNodeClashAction> action = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"action", CurveNodeDateOrder.class, CurveNodeClashAction.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"minGapInDays", "action"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 1925599072: {
                    return this.minGapInDays;
                }
                case -1422950858: {
                    return this.action;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends CurveNodeDateOrder> builder() {
            return new Builder();
        }

        public Class<? extends CurveNodeDateOrder> beanType() {
            return CurveNodeDateOrder.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<Integer> minGapInDays() {
            return this.minGapInDays;
        }

        public MetaProperty<CurveNodeClashAction> action() {
            return this.action;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 1925599072: {
                    return ((CurveNodeDateOrder)bean).getMinGapInDays();
                }
                case -1422950858: {
                    return ((CurveNodeDateOrder)bean).getAction();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

