/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.curve;

import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.data.scenario.MarketDataBox;
import com.opengamma.strata.data.scenario.ScenarioPerturbation;
import com.opengamma.strata.market.ShiftType;
import com.opengamma.strata.market.curve.Curve;
import com.opengamma.strata.market.curve.ParallelShiftedCurve;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BeanDefinition(builderScope="private")
public final class CurveParallelShifts
implements ScenarioPerturbation<Curve>,
ImmutableBean,
Serializable {
    private static final Logger log = LoggerFactory.getLogger(CurveParallelShifts.class);
    @PropertyDefinition(validate="notNull")
    private final ShiftType shiftType;
    @PropertyDefinition(validate="notNull")
    private final DoubleArray shiftAmounts;
    private static final long serialVersionUID = 1L;

    public static CurveParallelShifts absolute(double ... shiftAmounts) {
        return new CurveParallelShifts(ShiftType.ABSOLUTE, DoubleArray.copyOf((double[])shiftAmounts));
    }

    public static CurveParallelShifts relative(double ... shiftAmounts) {
        return new CurveParallelShifts(ShiftType.RELATIVE, DoubleArray.copyOf((double[])shiftAmounts));
    }

    public MarketDataBox<Curve> applyTo(MarketDataBox<Curve> curve, ReferenceData refData) {
        return curve.mapWithIndex(this.getScenarioCount(), this::applyShift);
    }

    private Curve applyShift(Curve curve, int scenarioIndex) {
        double shiftAmount = this.shiftAmounts.get(scenarioIndex);
        log.debug("Applying {} parallel shift of {} to curve '{}'", new Object[]{this.shiftType, shiftAmount, curve.getName()});
        return ParallelShiftedCurve.of(curve, this.shiftType, shiftAmount);
    }

    public int getScenarioCount() {
        return this.shiftAmounts.size();
    }

    public Class<Curve> getMarketDataType() {
        return Curve.class;
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private CurveParallelShifts(ShiftType shiftType, DoubleArray shiftAmounts) {
        JodaBeanUtils.notNull((Object)((Object)shiftType), (String)"shiftType");
        JodaBeanUtils.notNull((Object)shiftAmounts, (String)"shiftAmounts");
        this.shiftType = shiftType;
        this.shiftAmounts = shiftAmounts;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public ShiftType getShiftType() {
        return this.shiftType;
    }

    public DoubleArray getShiftAmounts() {
        return this.shiftAmounts;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            CurveParallelShifts other = (CurveParallelShifts)obj;
            return JodaBeanUtils.equal((Object)((Object)this.shiftType), (Object)((Object)other.shiftType)) && JodaBeanUtils.equal((Object)this.shiftAmounts, (Object)other.shiftAmounts);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.shiftType));
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.shiftAmounts);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(96);
        buf.append("CurveParallelShifts{");
        buf.append("shiftType").append('=').append(JodaBeanUtils.toString((Object)((Object)this.shiftType))).append(',').append(' ');
        buf.append("shiftAmounts").append('=').append(JodaBeanUtils.toString((Object)this.shiftAmounts));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<CurveParallelShifts> {
        private ShiftType shiftType;
        private DoubleArray shiftAmounts;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 893345500: {
                    return this.shiftType;
                }
                case 2011836473: {
                    return this.shiftAmounts;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 893345500: {
                    this.shiftType = (ShiftType)((Object)newValue);
                    break;
                }
                case 2011836473: {
                    this.shiftAmounts = (DoubleArray)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public CurveParallelShifts build() {
            return new CurveParallelShifts(this.shiftType, this.shiftAmounts);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(96);
            buf.append("CurveParallelShifts.Builder{");
            buf.append("shiftType").append('=').append(JodaBeanUtils.toString((Object)((Object)this.shiftType))).append(',').append(' ');
            buf.append("shiftAmounts").append('=').append(JodaBeanUtils.toString((Object)this.shiftAmounts));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<ShiftType> shiftType = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"shiftType", CurveParallelShifts.class, ShiftType.class);
        private final MetaProperty<DoubleArray> shiftAmounts = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"shiftAmounts", CurveParallelShifts.class, DoubleArray.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"shiftType", "shiftAmounts"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 893345500: {
                    return this.shiftType;
                }
                case 2011836473: {
                    return this.shiftAmounts;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends CurveParallelShifts> builder() {
            return new Builder();
        }

        public Class<? extends CurveParallelShifts> beanType() {
            return CurveParallelShifts.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<ShiftType> shiftType() {
            return this.shiftType;
        }

        public MetaProperty<DoubleArray> shiftAmounts() {
            return this.shiftAmounts;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 893345500: {
                    return ((CurveParallelShifts)bean).getShiftType();
                }
                case 2011836473: {
                    return ((CurveParallelShifts)bean).getShiftAmounts();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

