/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.curve;

import com.opengamma.strata.basics.date.DayCount;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.market.ValueType;
import com.opengamma.strata.market.curve.CurveMetadata;
import com.opengamma.strata.market.curve.CurveName;
import com.opengamma.strata.market.curve.DefaultCurveMetadata;
import com.opengamma.strata.market.param.ParameterMetadata;
import java.util.List;

public final class Curves {
    private Curves() {
    }

    public static CurveMetadata zeroRates(String name, DayCount dayCount) {
        return Curves.zeroRates(CurveName.of(name), dayCount);
    }

    public static CurveMetadata zeroRates(CurveName name, DayCount dayCount) {
        ArgChecker.notNull((Object)name, (String)"name");
        ArgChecker.notNull((Object)dayCount, (String)"dayCount");
        return DefaultCurveMetadata.builder().curveName(name).xValueType(ValueType.YEAR_FRACTION).yValueType(ValueType.ZERO_RATE).dayCount(dayCount).build();
    }

    public static CurveMetadata zeroRates(CurveName name, DayCount dayCount, List<? extends ParameterMetadata> parameterMetadata) {
        ArgChecker.notNull((Object)name, (String)"name");
        ArgChecker.notNull((Object)dayCount, (String)"dayCount");
        return DefaultCurveMetadata.builder().curveName(name).xValueType(ValueType.YEAR_FRACTION).yValueType(ValueType.ZERO_RATE).dayCount(dayCount).parameterMetadata(parameterMetadata).build();
    }

    public static CurveMetadata forwardRates(String name, DayCount dayCount) {
        return Curves.forwardRates(CurveName.of(name), dayCount);
    }

    public static CurveMetadata forwardRates(CurveName name, DayCount dayCount) {
        ArgChecker.notNull((Object)name, (String)"name");
        ArgChecker.notNull((Object)dayCount, (String)"dayCount");
        return DefaultCurveMetadata.builder().curveName(name).xValueType(ValueType.YEAR_FRACTION).yValueType(ValueType.FORWARD_RATE).dayCount(dayCount).build();
    }

    public static CurveMetadata forwardRates(CurveName name, DayCount dayCount, List<? extends ParameterMetadata> parameterMetadata) {
        ArgChecker.notNull((Object)name, (String)"name");
        ArgChecker.notNull((Object)dayCount, (String)"dayCount");
        return DefaultCurveMetadata.builder().curveName(name).xValueType(ValueType.YEAR_FRACTION).yValueType(ValueType.FORWARD_RATE).dayCount(dayCount).parameterMetadata(parameterMetadata).build();
    }

    public static CurveMetadata discountFactors(String name, DayCount dayCount) {
        return Curves.discountFactors(CurveName.of(name), dayCount);
    }

    public static CurveMetadata discountFactors(CurveName name, DayCount dayCount) {
        ArgChecker.notNull((Object)name, (String)"name");
        ArgChecker.notNull((Object)dayCount, (String)"dayCount");
        return DefaultCurveMetadata.builder().curveName(name).xValueType(ValueType.YEAR_FRACTION).yValueType(ValueType.DISCOUNT_FACTOR).dayCount(dayCount).build();
    }

    public static CurveMetadata discountFactors(CurveName name, DayCount dayCount, List<? extends ParameterMetadata> parameterMetadata) {
        ArgChecker.notNull((Object)name, (String)"name");
        ArgChecker.notNull((Object)dayCount, (String)"dayCount");
        return DefaultCurveMetadata.builder().curveName(name).xValueType(ValueType.YEAR_FRACTION).yValueType(ValueType.DISCOUNT_FACTOR).dayCount(dayCount).parameterMetadata(parameterMetadata).build();
    }

    public static CurveMetadata prices(String name) {
        return Curves.prices(CurveName.of(name));
    }

    public static CurveMetadata prices(CurveName name) {
        ArgChecker.notNull((Object)name, (String)"name");
        return DefaultCurveMetadata.builder().curveName(name).xValueType(ValueType.MONTHS).yValueType(ValueType.PRICE_INDEX).build();
    }

    public static CurveMetadata prices(CurveName name, List<? extends ParameterMetadata> parameterMetadata) {
        ArgChecker.notNull((Object)name, (String)"name");
        return DefaultCurveMetadata.builder().curveName(name).xValueType(ValueType.MONTHS).yValueType(ValueType.PRICE_INDEX).parameterMetadata(parameterMetadata).build();
    }

    public static CurveMetadata blackVolatilityByExpiry(String name, DayCount dayCount) {
        return Curves.blackVolatilityByExpiry(CurveName.of(name), dayCount);
    }

    public static CurveMetadata blackVolatilityByExpiry(CurveName name, DayCount dayCount) {
        ArgChecker.notNull((Object)name, (String)"name");
        ArgChecker.notNull((Object)dayCount, (String)"dayCount");
        return DefaultCurveMetadata.builder().curveName(name).xValueType(ValueType.YEAR_FRACTION).yValueType(ValueType.BLACK_VOLATILITY).dayCount(dayCount).build();
    }

    public static CurveMetadata blackVolatilityByExpiry(CurveName name, DayCount dayCount, List<? extends ParameterMetadata> parameterMetadata) {
        ArgChecker.notNull((Object)name, (String)"name");
        ArgChecker.notNull((Object)dayCount, (String)"dayCount");
        return DefaultCurveMetadata.builder().curveName(name).xValueType(ValueType.YEAR_FRACTION).yValueType(ValueType.BLACK_VOLATILITY).dayCount(dayCount).parameterMetadata(parameterMetadata).build();
    }

    public static CurveMetadata normalVolatilityByExpiry(String name, DayCount dayCount) {
        return Curves.normalVolatilityByExpiry(CurveName.of(name), dayCount);
    }

    public static CurveMetadata normalVolatilityByExpiry(CurveName name, DayCount dayCount) {
        ArgChecker.notNull((Object)name, (String)"name");
        ArgChecker.notNull((Object)dayCount, (String)"dayCount");
        return DefaultCurveMetadata.builder().curveName(name).xValueType(ValueType.YEAR_FRACTION).yValueType(ValueType.NORMAL_VOLATILITY).dayCount(dayCount).build();
    }

    public static CurveMetadata normalVolatilityByExpiry(CurveName name, DayCount dayCount, List<? extends ParameterMetadata> parameterMetadata) {
        ArgChecker.notNull((Object)name, (String)"name");
        ArgChecker.notNull((Object)dayCount, (String)"dayCount");
        return DefaultCurveMetadata.builder().curveName(name).xValueType(ValueType.YEAR_FRACTION).yValueType(ValueType.NORMAL_VOLATILITY).dayCount(dayCount).parameterMetadata(parameterMetadata).build();
    }

    public static CurveMetadata recoveryRates(String name, DayCount dayCount) {
        return Curves.recoveryRates(CurveName.of(name), dayCount);
    }

    public static CurveMetadata recoveryRates(CurveName name, DayCount dayCount) {
        ArgChecker.notNull((Object)name, (String)"name");
        ArgChecker.notNull((Object)dayCount, (String)"dayCount");
        return DefaultCurveMetadata.builder().curveName(name).xValueType(ValueType.YEAR_FRACTION).yValueType(ValueType.RECOVERY_RATE).dayCount(dayCount).build();
    }

    public static CurveMetadata recoveryRates(CurveName name, DayCount dayCount, List<? extends ParameterMetadata> parameterMetadata) {
        ArgChecker.notNull((Object)name, (String)"name");
        ArgChecker.notNull((Object)dayCount, (String)"dayCount");
        return DefaultCurveMetadata.builder().curveName(name).xValueType(ValueType.YEAR_FRACTION).yValueType(ValueType.RECOVERY_RATE).dayCount(dayCount).parameterMetadata(parameterMetadata).build();
    }

    public static CurveMetadata sabrParameterByExpiry(String name, DayCount dayCount, ValueType yType) {
        return Curves.sabrParameterByExpiry(CurveName.of(name), dayCount, yType);
    }

    public static CurveMetadata sabrParameterByExpiry(CurveName name, DayCount dayCount, ValueType yType) {
        if (!(yType.equals((Object)ValueType.SABR_ALPHA) || yType.equals((Object)ValueType.SABR_BETA) || yType.equals((Object)ValueType.SABR_RHO) || yType.equals((Object)ValueType.SABR_NU))) {
            throw new IllegalArgumentException("SABR y-value type must be SabrAlpha, SabrBeta, SabrRho or SabrNu");
        }
        return DefaultCurveMetadata.builder().curveName(name).xValueType(ValueType.YEAR_FRACTION).yValueType(yType).dayCount(dayCount).build();
    }

    public static CurveMetadata sabrParameterByExpiry(CurveName name, DayCount dayCount, ValueType yType, List<? extends ParameterMetadata> parameterMetadata) {
        if (!(yType.equals((Object)ValueType.SABR_ALPHA) || yType.equals((Object)ValueType.SABR_BETA) || yType.equals((Object)ValueType.SABR_RHO) || yType.equals((Object)ValueType.SABR_NU))) {
            throw new IllegalArgumentException("SABR y-value type must be SabrAlpha, SabrBeta, SabrRho or SabrNu");
        }
        return DefaultCurveMetadata.builder().curveName(name).xValueType(ValueType.YEAR_FRACTION).yValueType(yType).dayCount(dayCount).parameterMetadata(parameterMetadata).build();
    }

    public static CurveMetadata correlationByExpiry(String name, DayCount dayCount) {
        return Curves.correlationByExpiry(CurveName.of(name), dayCount);
    }

    public static CurveMetadata correlationByExpiry(CurveName name, DayCount dayCount) {
        ArgChecker.notNull((Object)name, (String)"name");
        ArgChecker.notNull((Object)dayCount, (String)"dayCount");
        return DefaultCurveMetadata.builder().curveName(name).xValueType(ValueType.YEAR_FRACTION).yValueType(ValueType.CORRELATION).dayCount(dayCount).build();
    }

    public static CurveMetadata correlationByExpiry(CurveName name, DayCount dayCount, List<? extends ParameterMetadata> parameterMetadata) {
        ArgChecker.notNull((Object)name, (String)"name");
        ArgChecker.notNull((Object)dayCount, (String)"dayCount");
        return DefaultCurveMetadata.builder().curveName(name).xValueType(ValueType.YEAR_FRACTION).yValueType(ValueType.CORRELATION).dayCount(dayCount).parameterMetadata(parameterMetadata).build();
    }
}

