/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.curve;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.market.ValueType;
import com.opengamma.strata.market.curve.CurveInfoType;
import com.opengamma.strata.market.curve.CurveMetadata;
import com.opengamma.strata.market.curve.CurveName;
import com.opengamma.strata.market.curve.DefaultCurveMetadataBuilder;
import com.opengamma.strata.market.param.ParameterMetadata;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableDefaults;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private", constructorScope="package")
public final class DefaultCurveMetadata
implements CurveMetadata,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final CurveName curveName;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final ValueType xValueType;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final ValueType yValueType;
    @PropertyDefinition(validate="notNull")
    private final ImmutableMap<CurveInfoType<?>, Object> info;
    @PropertyDefinition(get="optional", overrideGet=true, type="List<>", builderType="List<? extends ParameterMetadata>")
    private final ImmutableList<ParameterMetadata> parameterMetadata;
    private static final long serialVersionUID = 1L;

    public static DefaultCurveMetadata of(String name) {
        return DefaultCurveMetadata.of(CurveName.of(name));
    }

    public static DefaultCurveMetadata of(CurveName name) {
        return new DefaultCurveMetadata(name, ValueType.UNKNOWN, ValueType.UNKNOWN, (Map<CurveInfoType<?>, Object>)ImmutableMap.of(), null);
    }

    public static DefaultCurveMetadataBuilder builder() {
        return new DefaultCurveMetadataBuilder();
    }

    @ImmutableDefaults
    private static void applyDefaults(Builder builder) {
        builder.xValueType = ValueType.UNKNOWN;
        builder.yValueType = ValueType.UNKNOWN;
    }

    @Override
    public <T> T getInfo(CurveInfoType<T> type) {
        Object value = this.info.get(type);
        if (value == null) {
            throw new IllegalArgumentException(Messages.format((String)"Curve info not found for type '{}'", type));
        }
        return (T)value;
    }

    @Override
    public <T> Optional<T> findInfo(CurveInfoType<T> type) {
        return Optional.ofNullable(this.info.get(type));
    }

    @Override
    public <T> DefaultCurveMetadata withInfo(CurveInfoType<T> type, T value) {
        return this.toBuilder().addInfo(type, value).build();
    }

    @Override
    public DefaultCurveMetadata withParameterMetadata(List<? extends ParameterMetadata> parameterMetadata) {
        if (parameterMetadata == null) {
            return this.parameterMetadata != null ? this.toBuilder().clearParameterMetadata().build() : this;
        }
        return this.toBuilder().parameterMetadata(parameterMetadata).build();
    }

    public DefaultCurveMetadataBuilder toBuilder() {
        return new DefaultCurveMetadataBuilder(this);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    DefaultCurveMetadata(CurveName curveName, ValueType xValueType, ValueType yValueType, Map<CurveInfoType<?>, Object> info, List<? extends ParameterMetadata> parameterMetadata) {
        JodaBeanUtils.notNull((Object)curveName, (String)"curveName");
        JodaBeanUtils.notNull((Object)((Object)xValueType), (String)"xValueType");
        JodaBeanUtils.notNull((Object)((Object)yValueType), (String)"yValueType");
        JodaBeanUtils.notNull(info, (String)"info");
        this.curveName = curveName;
        this.xValueType = xValueType;
        this.yValueType = yValueType;
        this.info = ImmutableMap.copyOf(info);
        this.parameterMetadata = parameterMetadata != null ? ImmutableList.copyOf(parameterMetadata) : null;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public CurveName getCurveName() {
        return this.curveName;
    }

    @Override
    public ValueType getXValueType() {
        return this.xValueType;
    }

    @Override
    public ValueType getYValueType() {
        return this.yValueType;
    }

    public ImmutableMap<CurveInfoType<?>, Object> getInfo() {
        return this.info;
    }

    @Override
    public Optional<List<ParameterMetadata>> getParameterMetadata() {
        return Optional.ofNullable(this.parameterMetadata);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            DefaultCurveMetadata other = (DefaultCurveMetadata)obj;
            return JodaBeanUtils.equal((Object)this.curveName, (Object)other.curveName) && JodaBeanUtils.equal((Object)((Object)this.xValueType), (Object)((Object)other.xValueType)) && JodaBeanUtils.equal((Object)((Object)this.yValueType), (Object)((Object)other.yValueType)) && JodaBeanUtils.equal(this.info, other.info) && JodaBeanUtils.equal(this.parameterMetadata, other.parameterMetadata);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.curveName);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.xValueType));
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.yValueType));
        hash = hash * 31 + JodaBeanUtils.hashCode(this.info);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.parameterMetadata);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(192);
        buf.append("DefaultCurveMetadata{");
        buf.append("curveName").append('=').append(JodaBeanUtils.toString((Object)this.curveName)).append(',').append(' ');
        buf.append("xValueType").append('=').append(JodaBeanUtils.toString((Object)((Object)this.xValueType))).append(',').append(' ');
        buf.append("yValueType").append('=').append(JodaBeanUtils.toString((Object)((Object)this.yValueType))).append(',').append(' ');
        buf.append("info").append('=').append(JodaBeanUtils.toString(this.info)).append(',').append(' ');
        buf.append("parameterMetadata").append('=').append(JodaBeanUtils.toString(this.parameterMetadata));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<DefaultCurveMetadata> {
        private CurveName curveName;
        private ValueType xValueType;
        private ValueType yValueType;
        private Map<CurveInfoType<?>, Object> info = ImmutableMap.of();
        private List<? extends ParameterMetadata> parameterMetadata;

        private Builder() {
            DefaultCurveMetadata.applyDefaults(this);
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 771153946: {
                    return this.curveName;
                }
                case -868509005: {
                    return this.xValueType;
                }
                case -1065022510: {
                    return this.yValueType;
                }
                case 3237038: {
                    return this.info;
                }
                case -1169106440: {
                    return this.parameterMetadata;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 771153946: {
                    this.curveName = (CurveName)newValue;
                    break;
                }
                case -868509005: {
                    this.xValueType = (ValueType)((Object)newValue);
                    break;
                }
                case -1065022510: {
                    this.yValueType = (ValueType)((Object)newValue);
                    break;
                }
                case 3237038: {
                    this.info = (Map)newValue;
                    break;
                }
                case -1169106440: {
                    this.parameterMetadata = (List)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public DefaultCurveMetadata build() {
            return new DefaultCurveMetadata(this.curveName, this.xValueType, this.yValueType, this.info, this.parameterMetadata);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(192);
            buf.append("DefaultCurveMetadata.Builder{");
            buf.append("curveName").append('=').append(JodaBeanUtils.toString((Object)this.curveName)).append(',').append(' ');
            buf.append("xValueType").append('=').append(JodaBeanUtils.toString((Object)((Object)this.xValueType))).append(',').append(' ');
            buf.append("yValueType").append('=').append(JodaBeanUtils.toString((Object)((Object)this.yValueType))).append(',').append(' ');
            buf.append("info").append('=').append(JodaBeanUtils.toString(this.info)).append(',').append(' ');
            buf.append("parameterMetadata").append('=').append(JodaBeanUtils.toString(this.parameterMetadata));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<CurveName> curveName = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"curveName", DefaultCurveMetadata.class, CurveName.class);
        private final MetaProperty<ValueType> xValueType = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"xValueType", DefaultCurveMetadata.class, ValueType.class);
        private final MetaProperty<ValueType> yValueType = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"yValueType", DefaultCurveMetadata.class, ValueType.class);
        private final MetaProperty<ImmutableMap<CurveInfoType<?>, Object>> info = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"info", DefaultCurveMetadata.class, ImmutableMap.class);
        private final MetaProperty<List<ParameterMetadata>> parameterMetadata = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"parameterMetadata", DefaultCurveMetadata.class, List.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"curveName", "xValueType", "yValueType", "info", "parameterMetadata"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 771153946: {
                    return this.curveName;
                }
                case -868509005: {
                    return this.xValueType;
                }
                case -1065022510: {
                    return this.yValueType;
                }
                case 3237038: {
                    return this.info;
                }
                case -1169106440: {
                    return this.parameterMetadata;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends DefaultCurveMetadata> builder() {
            return new Builder();
        }

        public Class<? extends DefaultCurveMetadata> beanType() {
            return DefaultCurveMetadata.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<CurveName> curveName() {
            return this.curveName;
        }

        public MetaProperty<ValueType> xValueType() {
            return this.xValueType;
        }

        public MetaProperty<ValueType> yValueType() {
            return this.yValueType;
        }

        public MetaProperty<ImmutableMap<CurveInfoType<?>, Object>> info() {
            return this.info;
        }

        public MetaProperty<List<ParameterMetadata>> parameterMetadata() {
            return this.parameterMetadata;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 771153946: {
                    return ((DefaultCurveMetadata)bean).getCurveName();
                }
                case -868509005: {
                    return ((DefaultCurveMetadata)bean).getXValueType();
                }
                case -1065022510: {
                    return ((DefaultCurveMetadata)bean).getYValueType();
                }
                case 3237038: {
                    return ((DefaultCurveMetadata)bean).getInfo();
                }
                case -1169106440: {
                    return ((DefaultCurveMetadata)bean).parameterMetadata;
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

