/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.curve;

import com.google.common.collect.ImmutableList;
import com.opengamma.strata.basics.date.DayCount;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.market.ValueType;
import com.opengamma.strata.market.curve.CurveInfoType;
import com.opengamma.strata.market.curve.CurveName;
import com.opengamma.strata.market.curve.DefaultCurveMetadata;
import com.opengamma.strata.market.curve.JacobianCalibrationMatrix;
import com.opengamma.strata.market.param.ParameterMetadata;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class DefaultCurveMetadataBuilder {
    private CurveName curveName;
    private ValueType xValueType = ValueType.UNKNOWN;
    private ValueType yValueType = ValueType.UNKNOWN;
    private final Map<CurveInfoType<?>, Object> info = new HashMap();
    private List<ParameterMetadata> parameterMetadata;

    DefaultCurveMetadataBuilder() {
    }

    DefaultCurveMetadataBuilder(DefaultCurveMetadata beanToCopy) {
        this.curveName = beanToCopy.getCurveName();
        this.xValueType = beanToCopy.getXValueType();
        this.yValueType = beanToCopy.getYValueType();
        this.info.putAll((Map<CurveInfoType<?>, Object>)beanToCopy.getInfo());
        this.parameterMetadata = beanToCopy.getParameterMetadata().orElse(null);
    }

    public DefaultCurveMetadataBuilder curveName(String curveName) {
        this.curveName = CurveName.of(curveName);
        return this;
    }

    public DefaultCurveMetadataBuilder curveName(CurveName curveName) {
        this.curveName = (CurveName)ArgChecker.notNull((Object)curveName, (String)"curveName");
        return this;
    }

    public DefaultCurveMetadataBuilder xValueType(ValueType xValueType) {
        this.xValueType = (ValueType)((Object)ArgChecker.notNull((Object)((Object)xValueType), (String)"xValueType"));
        return this;
    }

    public DefaultCurveMetadataBuilder yValueType(ValueType yValueType) {
        this.yValueType = (ValueType)((Object)ArgChecker.notNull((Object)((Object)yValueType), (String)"yValueType"));
        return this;
    }

    public DefaultCurveMetadataBuilder dayCount(DayCount dayCount) {
        return this.addInfo(CurveInfoType.DAY_COUNT, dayCount);
    }

    public DefaultCurveMetadataBuilder jacobian(JacobianCalibrationMatrix jacobian) {
        return this.addInfo(CurveInfoType.JACOBIAN, jacobian);
    }

    public <T> DefaultCurveMetadataBuilder addInfo(CurveInfoType<T> type, T value) {
        ArgChecker.notNull(type, (String)"type");
        if (value != null) {
            this.info.put(type, value);
        } else {
            this.info.remove(type);
        }
        return this;
    }

    public DefaultCurveMetadataBuilder parameterMetadata(List<? extends ParameterMetadata> parameterMetadata) {
        this.parameterMetadata = ImmutableList.copyOf(parameterMetadata);
        return this;
    }

    public DefaultCurveMetadataBuilder parameterMetadata(ParameterMetadata ... parameterMetadata) {
        this.parameterMetadata = ImmutableList.copyOf((Object[])parameterMetadata);
        return this;
    }

    public DefaultCurveMetadataBuilder clearParameterMetadata() {
        this.parameterMetadata = null;
        return this;
    }

    public DefaultCurveMetadata build() {
        return new DefaultCurveMetadata(this.curveName, this.xValueType, this.yValueType, this.info, this.parameterMetadata);
    }
}

