/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.curve;

import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.date.BusinessDayAdjustment;
import com.opengamma.strata.basics.date.DayCount;
import com.opengamma.strata.basics.date.DaysAdjustment;
import com.opengamma.strata.basics.date.Tenor;
import com.opengamma.strata.data.ObservableId;
import com.opengamma.strata.market.curve.IsdaCreditCurveNode;
import com.opengamma.strata.market.param.TenorDateParameterMetadata;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.temporal.TemporalAmount;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutablePreBuild;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class DepositIsdaCreditCurveNode
implements IsdaCreditCurveNode,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notEmpty", overrideGet=true)
    private final String label;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final ObservableId observableId;
    @PropertyDefinition(validate="notNull")
    private final Tenor tenor;
    @PropertyDefinition(validate="notNull")
    private final DaysAdjustment spotDateOffset;
    @PropertyDefinition(validate="notNull")
    private final BusinessDayAdjustment businessDayAdjustment;
    @PropertyDefinition(validate="notNull")
    private final DayCount dayCount;
    private static final long serialVersionUID = 1L;

    public static DepositIsdaCreditCurveNode of(ObservableId observableId, DaysAdjustment spotDateOffset, BusinessDayAdjustment businessDayAdjustment, Tenor tenor, DayCount dayCount) {
        return DepositIsdaCreditCurveNode.builder().observableId(observableId).tenor(tenor).businessDayAdjustment(businessDayAdjustment).dayCount(dayCount).spotDateOffset(spotDateOffset).build();
    }

    @ImmutablePreBuild
    private static void preBuild(Builder builder) {
        if (builder.label == null && builder.tenor != null) {
            builder.label = builder.tenor.toString();
        }
    }

    @Override
    public LocalDate date(LocalDate tradeDate, ReferenceData refData) {
        LocalDate startDate = this.spotDateOffset.adjust(tradeDate, refData);
        LocalDate endDate = startDate.plus((TemporalAmount)this.tenor);
        return this.businessDayAdjustment.adjust(endDate, refData);
    }

    @Override
    public TenorDateParameterMetadata metadata(LocalDate nodeDate) {
        return TenorDateParameterMetadata.of(nodeDate, this.tenor);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private DepositIsdaCreditCurveNode(String label, ObservableId observableId, Tenor tenor, DaysAdjustment spotDateOffset, BusinessDayAdjustment businessDayAdjustment, DayCount dayCount) {
        JodaBeanUtils.notEmpty((String)label, (String)"label");
        JodaBeanUtils.notNull((Object)observableId, (String)"observableId");
        JodaBeanUtils.notNull((Object)tenor, (String)"tenor");
        JodaBeanUtils.notNull((Object)spotDateOffset, (String)"spotDateOffset");
        JodaBeanUtils.notNull((Object)businessDayAdjustment, (String)"businessDayAdjustment");
        JodaBeanUtils.notNull((Object)dayCount, (String)"dayCount");
        this.label = label;
        this.observableId = observableId;
        this.tenor = tenor;
        this.spotDateOffset = spotDateOffset;
        this.businessDayAdjustment = businessDayAdjustment;
        this.dayCount = dayCount;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public ObservableId getObservableId() {
        return this.observableId;
    }

    public Tenor getTenor() {
        return this.tenor;
    }

    public DaysAdjustment getSpotDateOffset() {
        return this.spotDateOffset;
    }

    public BusinessDayAdjustment getBusinessDayAdjustment() {
        return this.businessDayAdjustment;
    }

    public DayCount getDayCount() {
        return this.dayCount;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            DepositIsdaCreditCurveNode other = (DepositIsdaCreditCurveNode)obj;
            return JodaBeanUtils.equal((Object)this.label, (Object)other.label) && JodaBeanUtils.equal((Object)this.observableId, (Object)other.observableId) && JodaBeanUtils.equal((Object)this.tenor, (Object)other.tenor) && JodaBeanUtils.equal((Object)this.spotDateOffset, (Object)other.spotDateOffset) && JodaBeanUtils.equal((Object)this.businessDayAdjustment, (Object)other.businessDayAdjustment) && JodaBeanUtils.equal((Object)this.dayCount, (Object)other.dayCount);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.label);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.observableId);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.tenor);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.spotDateOffset);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.businessDayAdjustment);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.dayCount);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(224);
        buf.append("DepositIsdaCreditCurveNode{");
        buf.append("label").append('=').append(JodaBeanUtils.toString((Object)this.label)).append(',').append(' ');
        buf.append("observableId").append('=').append(JodaBeanUtils.toString((Object)this.observableId)).append(',').append(' ');
        buf.append("tenor").append('=').append(JodaBeanUtils.toString((Object)this.tenor)).append(',').append(' ');
        buf.append("spotDateOffset").append('=').append(JodaBeanUtils.toString((Object)this.spotDateOffset)).append(',').append(' ');
        buf.append("businessDayAdjustment").append('=').append(JodaBeanUtils.toString((Object)this.businessDayAdjustment)).append(',').append(' ');
        buf.append("dayCount").append('=').append(JodaBeanUtils.toString((Object)this.dayCount));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<DepositIsdaCreditCurveNode> {
        private String label;
        private ObservableId observableId;
        private Tenor tenor;
        private DaysAdjustment spotDateOffset;
        private BusinessDayAdjustment businessDayAdjustment;
        private DayCount dayCount;

        private Builder() {
        }

        private Builder(DepositIsdaCreditCurveNode beanToCopy) {
            this.label = beanToCopy.getLabel();
            this.observableId = beanToCopy.getObservableId();
            this.tenor = beanToCopy.getTenor();
            this.spotDateOffset = beanToCopy.getSpotDateOffset();
            this.businessDayAdjustment = beanToCopy.getBusinessDayAdjustment();
            this.dayCount = beanToCopy.getDayCount();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 102727412: {
                    return this.label;
                }
                case -518800962: {
                    return this.observableId;
                }
                case 110246592: {
                    return this.tenor;
                }
                case 746995843: {
                    return this.spotDateOffset;
                }
                case -1065319863: {
                    return this.businessDayAdjustment;
                }
                case 1905311443: {
                    return this.dayCount;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 102727412: {
                    this.label = (String)newValue;
                    break;
                }
                case -518800962: {
                    this.observableId = (ObservableId)newValue;
                    break;
                }
                case 110246592: {
                    this.tenor = (Tenor)newValue;
                    break;
                }
                case 746995843: {
                    this.spotDateOffset = (DaysAdjustment)newValue;
                    break;
                }
                case -1065319863: {
                    this.businessDayAdjustment = (BusinessDayAdjustment)newValue;
                    break;
                }
                case 1905311443: {
                    this.dayCount = (DayCount)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public DepositIsdaCreditCurveNode build() {
            DepositIsdaCreditCurveNode.preBuild(this);
            return new DepositIsdaCreditCurveNode(this.label, this.observableId, this.tenor, this.spotDateOffset, this.businessDayAdjustment, this.dayCount);
        }

        public Builder label(String label) {
            JodaBeanUtils.notEmpty((String)label, (String)"label");
            this.label = label;
            return this;
        }

        public Builder observableId(ObservableId observableId) {
            JodaBeanUtils.notNull((Object)observableId, (String)"observableId");
            this.observableId = observableId;
            return this;
        }

        public Builder tenor(Tenor tenor) {
            JodaBeanUtils.notNull((Object)tenor, (String)"tenor");
            this.tenor = tenor;
            return this;
        }

        public Builder spotDateOffset(DaysAdjustment spotDateOffset) {
            JodaBeanUtils.notNull((Object)spotDateOffset, (String)"spotDateOffset");
            this.spotDateOffset = spotDateOffset;
            return this;
        }

        public Builder businessDayAdjustment(BusinessDayAdjustment businessDayAdjustment) {
            JodaBeanUtils.notNull((Object)businessDayAdjustment, (String)"businessDayAdjustment");
            this.businessDayAdjustment = businessDayAdjustment;
            return this;
        }

        public Builder dayCount(DayCount dayCount) {
            JodaBeanUtils.notNull((Object)dayCount, (String)"dayCount");
            this.dayCount = dayCount;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(224);
            buf.append("DepositIsdaCreditCurveNode.Builder{");
            buf.append("label").append('=').append(JodaBeanUtils.toString((Object)this.label)).append(',').append(' ');
            buf.append("observableId").append('=').append(JodaBeanUtils.toString((Object)this.observableId)).append(',').append(' ');
            buf.append("tenor").append('=').append(JodaBeanUtils.toString((Object)this.tenor)).append(',').append(' ');
            buf.append("spotDateOffset").append('=').append(JodaBeanUtils.toString((Object)this.spotDateOffset)).append(',').append(' ');
            buf.append("businessDayAdjustment").append('=').append(JodaBeanUtils.toString((Object)this.businessDayAdjustment)).append(',').append(' ');
            buf.append("dayCount").append('=').append(JodaBeanUtils.toString((Object)this.dayCount));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<String> label = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"label", DepositIsdaCreditCurveNode.class, String.class);
        private final MetaProperty<ObservableId> observableId = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"observableId", DepositIsdaCreditCurveNode.class, ObservableId.class);
        private final MetaProperty<Tenor> tenor = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"tenor", DepositIsdaCreditCurveNode.class, Tenor.class);
        private final MetaProperty<DaysAdjustment> spotDateOffset = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"spotDateOffset", DepositIsdaCreditCurveNode.class, DaysAdjustment.class);
        private final MetaProperty<BusinessDayAdjustment> businessDayAdjustment = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"businessDayAdjustment", DepositIsdaCreditCurveNode.class, BusinessDayAdjustment.class);
        private final MetaProperty<DayCount> dayCount = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"dayCount", DepositIsdaCreditCurveNode.class, DayCount.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"label", "observableId", "tenor", "spotDateOffset", "businessDayAdjustment", "dayCount"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 102727412: {
                    return this.label;
                }
                case -518800962: {
                    return this.observableId;
                }
                case 110246592: {
                    return this.tenor;
                }
                case 746995843: {
                    return this.spotDateOffset;
                }
                case -1065319863: {
                    return this.businessDayAdjustment;
                }
                case 1905311443: {
                    return this.dayCount;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends DepositIsdaCreditCurveNode> beanType() {
            return DepositIsdaCreditCurveNode.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<String> label() {
            return this.label;
        }

        public MetaProperty<ObservableId> observableId() {
            return this.observableId;
        }

        public MetaProperty<Tenor> tenor() {
            return this.tenor;
        }

        public MetaProperty<DaysAdjustment> spotDateOffset() {
            return this.spotDateOffset;
        }

        public MetaProperty<BusinessDayAdjustment> businessDayAdjustment() {
            return this.businessDayAdjustment;
        }

        public MetaProperty<DayCount> dayCount() {
            return this.dayCount;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 102727412: {
                    return ((DepositIsdaCreditCurveNode)bean).getLabel();
                }
                case -518800962: {
                    return ((DepositIsdaCreditCurveNode)bean).getObservableId();
                }
                case 110246592: {
                    return ((DepositIsdaCreditCurveNode)bean).getTenor();
                }
                case 746995843: {
                    return ((DepositIsdaCreditCurveNode)bean).getSpotDateOffset();
                }
                case -1065319863: {
                    return ((DepositIsdaCreditCurveNode)bean).getBusinessDayAdjustment();
                }
                case 1905311443: {
                    return ((DepositIsdaCreditCurveNode)bean).getDayCount();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

