/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.curve;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.collect.Guavate;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.market.curve.CurveMetadata;
import com.opengamma.strata.market.curve.NodalCurve;
import com.opengamma.strata.market.curve.interpolator.BoundCurveInterpolator;
import com.opengamma.strata.market.curve.interpolator.CurveExtrapolator;
import com.opengamma.strata.market.curve.interpolator.CurveExtrapolators;
import com.opengamma.strata.market.curve.interpolator.CurveInterpolator;
import com.opengamma.strata.market.param.CurrencyParameterSensitivity;
import com.opengamma.strata.market.param.ParameterMetadata;
import com.opengamma.strata.market.param.ParameterPerturbation;
import com.opengamma.strata.market.param.UnitParameterSensitivity;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.stream.IntStream;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableConstructor;
import org.joda.beans.gen.ImmutableDefaults;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class InterpolatedNodalCurve
implements NodalCurve,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final CurveMetadata metadata;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final DoubleArray xValues;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final DoubleArray yValues;
    @PropertyDefinition(validate="notNull")
    private final CurveInterpolator interpolator;
    @PropertyDefinition(validate="notNull")
    private final CurveExtrapolator extrapolatorLeft;
    @PropertyDefinition(validate="notNull")
    private final CurveExtrapolator extrapolatorRight;
    private final transient BoundCurveInterpolator boundInterpolator;
    private final transient List<ParameterMetadata> parameterMetadata;
    private static final long serialVersionUID = 1L;

    public static InterpolatedNodalCurve of(CurveMetadata metadata, DoubleArray xValues, DoubleArray yValues, CurveInterpolator interpolator) {
        return InterpolatedNodalCurve.builder().metadata(metadata).xValues(xValues).yValues(yValues).interpolator(interpolator).build();
    }

    public static InterpolatedNodalCurve of(CurveMetadata metadata, DoubleArray xValues, DoubleArray yValues, CurveInterpolator interpolator, CurveExtrapolator extrapolatorLeft, CurveExtrapolator extrapolatorRight) {
        return InterpolatedNodalCurve.builder().metadata(metadata).xValues(xValues).yValues(yValues).interpolator(interpolator).extrapolatorLeft(extrapolatorLeft).extrapolatorRight(extrapolatorRight).build();
    }

    @ImmutableConstructor
    private InterpolatedNodalCurve(CurveMetadata metadata, DoubleArray xValues, DoubleArray yValues, CurveInterpolator interpolator, CurveExtrapolator extrapolatorLeft, CurveExtrapolator extrapolatorRight) {
        JodaBeanUtils.notNull((Object)metadata, (String)"metadata");
        JodaBeanUtils.notNull((Object)xValues, (String)"times");
        JodaBeanUtils.notNull((Object)yValues, (String)"values");
        JodaBeanUtils.notNull((Object)interpolator, (String)"interpolator");
        JodaBeanUtils.notNull((Object)extrapolatorLeft, (String)"extrapolatorLeft");
        JodaBeanUtils.notNull((Object)extrapolatorRight, (String)"extrapolatorRight");
        if (xValues.size() < 2) {
            throw new IllegalArgumentException("Length of x-values must be at least 2");
        }
        if (xValues.size() != yValues.size()) {
            throw new IllegalArgumentException("Length of x-values and y-values must match");
        }
        metadata.getParameterMetadata().ifPresent(params -> {
            if (xValues.size() != params.size()) {
                throw new IllegalArgumentException("Length of x-values and parameter metadata must match when metadata present");
            }
        });
        for (int i2 = 1; i2 < xValues.size(); ++i2) {
            if (!(xValues.get(i2) <= xValues.get(i2 - 1))) continue;
            throw new IllegalArgumentException("Array of x-values must be sorted and unique");
        }
        this.metadata = metadata;
        this.xValues = xValues;
        this.yValues = yValues;
        this.extrapolatorLeft = extrapolatorLeft;
        this.interpolator = interpolator;
        this.extrapolatorRight = extrapolatorRight;
        this.boundInterpolator = interpolator.bind(xValues, yValues, extrapolatorLeft, extrapolatorRight);
        this.parameterMetadata = (List)IntStream.range(0, this.getParameterCount()).mapToObj(i -> this.getParameterMetadata(i)).collect(Guavate.toImmutableList());
    }

    @ImmutableDefaults
    private static void applyDefaults(Builder builder) {
        builder.extrapolatorLeft = CurveExtrapolators.FLAT;
        builder.extrapolatorRight = CurveExtrapolators.FLAT;
    }

    private Object readResolve() {
        return new InterpolatedNodalCurve(this.metadata, this.xValues, this.yValues, this.interpolator, this.extrapolatorLeft, this.extrapolatorRight);
    }

    @Override
    public int getParameterCount() {
        return this.yValues.size();
    }

    @Override
    public double getParameter(int parameterIndex) {
        return this.yValues.get(parameterIndex);
    }

    @Override
    public InterpolatedNodalCurve withParameter(int parameterIndex, double newValue) {
        return this.withYValues(this.yValues.with(parameterIndex, newValue));
    }

    @Override
    public InterpolatedNodalCurve withPerturbation(ParameterPerturbation perturbation) {
        int size = this.yValues.size();
        DoubleArray perturbedValues = DoubleArray.of((int)size, i -> perturbation.perturbParameter(i, this.yValues.get(i), this.getParameterMetadata(i)));
        return this.withYValues(perturbedValues);
    }

    @Override
    public double yValue(double x) {
        return this.boundInterpolator.interpolate(x);
    }

    @Override
    public UnitParameterSensitivity yValueParameterSensitivity(double x) {
        return this.createParameterSensitivity(this.boundInterpolator.parameterSensitivity(x));
    }

    @Override
    public double firstDerivative(double x) {
        return this.boundInterpolator.firstDerivative(x);
    }

    @Override
    public InterpolatedNodalCurve withMetadata(CurveMetadata metadata) {
        return new InterpolatedNodalCurve(metadata, this.xValues, this.yValues, this.interpolator, this.extrapolatorLeft, this.extrapolatorRight);
    }

    @Override
    public InterpolatedNodalCurve withYValues(DoubleArray yValues) {
        return new InterpolatedNodalCurve(this.metadata, this.xValues, yValues, this.interpolator, this.extrapolatorLeft, this.extrapolatorRight);
    }

    @Override
    public InterpolatedNodalCurve withValues(DoubleArray xValues, DoubleArray yValues) {
        return new InterpolatedNodalCurve(this.metadata, xValues, yValues, this.interpolator, this.extrapolatorLeft, this.extrapolatorRight);
    }

    @Override
    public InterpolatedNodalCurve withNode(double x, double y, ParameterMetadata paramMetadata) {
        int index = Arrays.binarySearch(this.xValues.toArrayUnsafe(), x);
        if (index >= 0) {
            CurveMetadata md = this.metadata.getParameterMetadata().map(params -> {
                ArrayList<ParameterMetadata> extended = new ArrayList<ParameterMetadata>((Collection<ParameterMetadata>)params);
                extended.set(index, paramMetadata);
                return this.metadata.withParameterMetadata(extended);
            }).orElse(this.metadata);
            DoubleArray yUpdated = this.yValues.with(index, y);
            return new InterpolatedNodalCurve(md, this.xValues, yUpdated, this.interpolator, this.extrapolatorLeft, this.extrapolatorRight);
        }
        int insertion = -(index + 1);
        DoubleArray xExtended = this.xValues.subArray(0, insertion).concat(new double[]{x}).concat(this.xValues.subArray(insertion));
        DoubleArray yExtended = this.yValues.subArray(0, insertion).concat(new double[]{y}).concat(this.yValues.subArray(insertion));
        CurveMetadata md = this.metadata.getParameterMetadata().map(params -> {
            ArrayList<ParameterMetadata> extended = new ArrayList<ParameterMetadata>((Collection<ParameterMetadata>)params);
            extended.add(insertion, paramMetadata);
            return this.metadata.withParameterMetadata(extended);
        }).orElse(this.metadata);
        return new InterpolatedNodalCurve(md, xExtended, yExtended, this.interpolator, this.extrapolatorLeft, this.extrapolatorRight);
    }

    @Override
    public UnitParameterSensitivity createParameterSensitivity(DoubleArray sensitivities) {
        return UnitParameterSensitivity.of(this.getName(), this.parameterMetadata, sensitivities);
    }

    @Override
    public CurrencyParameterSensitivity createParameterSensitivity(Currency currency, DoubleArray sensitivities) {
        return CurrencyParameterSensitivity.of(this.getName(), this.parameterMetadata, currency, sensitivities);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public CurveMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public DoubleArray getXValues() {
        return this.xValues;
    }

    @Override
    public DoubleArray getYValues() {
        return this.yValues;
    }

    public CurveInterpolator getInterpolator() {
        return this.interpolator;
    }

    public CurveExtrapolator getExtrapolatorLeft() {
        return this.extrapolatorLeft;
    }

    public CurveExtrapolator getExtrapolatorRight() {
        return this.extrapolatorRight;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            InterpolatedNodalCurve other = (InterpolatedNodalCurve)obj;
            return JodaBeanUtils.equal((Object)this.metadata, (Object)other.metadata) && JodaBeanUtils.equal((Object)this.xValues, (Object)other.xValues) && JodaBeanUtils.equal((Object)this.yValues, (Object)other.yValues) && JodaBeanUtils.equal((Object)this.interpolator, (Object)other.interpolator) && JodaBeanUtils.equal((Object)this.extrapolatorLeft, (Object)other.extrapolatorLeft) && JodaBeanUtils.equal((Object)this.extrapolatorRight, (Object)other.extrapolatorRight);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.metadata);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.xValues);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.yValues);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.interpolator);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.extrapolatorLeft);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.extrapolatorRight);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(224);
        buf.append("InterpolatedNodalCurve{");
        buf.append("metadata").append('=').append(JodaBeanUtils.toString((Object)this.metadata)).append(',').append(' ');
        buf.append("xValues").append('=').append(JodaBeanUtils.toString((Object)this.xValues)).append(',').append(' ');
        buf.append("yValues").append('=').append(JodaBeanUtils.toString((Object)this.yValues)).append(',').append(' ');
        buf.append("interpolator").append('=').append(JodaBeanUtils.toString((Object)this.interpolator)).append(',').append(' ');
        buf.append("extrapolatorLeft").append('=').append(JodaBeanUtils.toString((Object)this.extrapolatorLeft)).append(',').append(' ');
        buf.append("extrapolatorRight").append('=').append(JodaBeanUtils.toString((Object)this.extrapolatorRight));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<InterpolatedNodalCurve> {
        private CurveMetadata metadata;
        private DoubleArray xValues;
        private DoubleArray yValues;
        private CurveInterpolator interpolator;
        private CurveExtrapolator extrapolatorLeft;
        private CurveExtrapolator extrapolatorRight;

        private Builder() {
            InterpolatedNodalCurve.applyDefaults(this);
        }

        private Builder(InterpolatedNodalCurve beanToCopy) {
            this.metadata = beanToCopy.getMetadata();
            this.xValues = beanToCopy.getXValues();
            this.yValues = beanToCopy.getYValues();
            this.interpolator = beanToCopy.getInterpolator();
            this.extrapolatorLeft = beanToCopy.getExtrapolatorLeft();
            this.extrapolatorRight = beanToCopy.getExtrapolatorRight();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case -450004177: {
                    return this.metadata;
                }
                case 1681280954: {
                    return this.xValues;
                }
                case -1726182661: {
                    return this.yValues;
                }
                case 2096253127: {
                    return this.interpolator;
                }
                case 1271703994: {
                    return this.extrapolatorLeft;
                }
                case 773779145: {
                    return this.extrapolatorRight;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case -450004177: {
                    this.metadata = (CurveMetadata)newValue;
                    break;
                }
                case 1681280954: {
                    this.xValues = (DoubleArray)newValue;
                    break;
                }
                case -1726182661: {
                    this.yValues = (DoubleArray)newValue;
                    break;
                }
                case 2096253127: {
                    this.interpolator = (CurveInterpolator)newValue;
                    break;
                }
                case 1271703994: {
                    this.extrapolatorLeft = (CurveExtrapolator)newValue;
                    break;
                }
                case 773779145: {
                    this.extrapolatorRight = (CurveExtrapolator)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public InterpolatedNodalCurve build() {
            return new InterpolatedNodalCurve(this.metadata, this.xValues, this.yValues, this.interpolator, this.extrapolatorLeft, this.extrapolatorRight);
        }

        public Builder metadata(CurveMetadata metadata) {
            JodaBeanUtils.notNull((Object)metadata, (String)"metadata");
            this.metadata = metadata;
            return this;
        }

        public Builder xValues(DoubleArray xValues) {
            JodaBeanUtils.notNull((Object)xValues, (String)"xValues");
            this.xValues = xValues;
            return this;
        }

        public Builder yValues(DoubleArray yValues) {
            JodaBeanUtils.notNull((Object)yValues, (String)"yValues");
            this.yValues = yValues;
            return this;
        }

        public Builder interpolator(CurveInterpolator interpolator) {
            JodaBeanUtils.notNull((Object)interpolator, (String)"interpolator");
            this.interpolator = interpolator;
            return this;
        }

        public Builder extrapolatorLeft(CurveExtrapolator extrapolatorLeft) {
            JodaBeanUtils.notNull((Object)extrapolatorLeft, (String)"extrapolatorLeft");
            this.extrapolatorLeft = extrapolatorLeft;
            return this;
        }

        public Builder extrapolatorRight(CurveExtrapolator extrapolatorRight) {
            JodaBeanUtils.notNull((Object)extrapolatorRight, (String)"extrapolatorRight");
            this.extrapolatorRight = extrapolatorRight;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(224);
            buf.append("InterpolatedNodalCurve.Builder{");
            buf.append("metadata").append('=').append(JodaBeanUtils.toString((Object)this.metadata)).append(',').append(' ');
            buf.append("xValues").append('=').append(JodaBeanUtils.toString((Object)this.xValues)).append(',').append(' ');
            buf.append("yValues").append('=').append(JodaBeanUtils.toString((Object)this.yValues)).append(',').append(' ');
            buf.append("interpolator").append('=').append(JodaBeanUtils.toString((Object)this.interpolator)).append(',').append(' ');
            buf.append("extrapolatorLeft").append('=').append(JodaBeanUtils.toString((Object)this.extrapolatorLeft)).append(',').append(' ');
            buf.append("extrapolatorRight").append('=').append(JodaBeanUtils.toString((Object)this.extrapolatorRight));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<CurveMetadata> metadata = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"metadata", InterpolatedNodalCurve.class, CurveMetadata.class);
        private final MetaProperty<DoubleArray> xValues = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"xValues", InterpolatedNodalCurve.class, DoubleArray.class);
        private final MetaProperty<DoubleArray> yValues = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"yValues", InterpolatedNodalCurve.class, DoubleArray.class);
        private final MetaProperty<CurveInterpolator> interpolator = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"interpolator", InterpolatedNodalCurve.class, CurveInterpolator.class);
        private final MetaProperty<CurveExtrapolator> extrapolatorLeft = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"extrapolatorLeft", InterpolatedNodalCurve.class, CurveExtrapolator.class);
        private final MetaProperty<CurveExtrapolator> extrapolatorRight = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"extrapolatorRight", InterpolatedNodalCurve.class, CurveExtrapolator.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"metadata", "xValues", "yValues", "interpolator", "extrapolatorLeft", "extrapolatorRight"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case -450004177: {
                    return this.metadata;
                }
                case 1681280954: {
                    return this.xValues;
                }
                case -1726182661: {
                    return this.yValues;
                }
                case 2096253127: {
                    return this.interpolator;
                }
                case 1271703994: {
                    return this.extrapolatorLeft;
                }
                case 773779145: {
                    return this.extrapolatorRight;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends InterpolatedNodalCurve> beanType() {
            return InterpolatedNodalCurve.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<CurveMetadata> metadata() {
            return this.metadata;
        }

        public MetaProperty<DoubleArray> xValues() {
            return this.xValues;
        }

        public MetaProperty<DoubleArray> yValues() {
            return this.yValues;
        }

        public MetaProperty<CurveInterpolator> interpolator() {
            return this.interpolator;
        }

        public MetaProperty<CurveExtrapolator> extrapolatorLeft() {
            return this.extrapolatorLeft;
        }

        public MetaProperty<CurveExtrapolator> extrapolatorRight() {
            return this.extrapolatorRight;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case -450004177: {
                    return ((InterpolatedNodalCurve)bean).getMetadata();
                }
                case 1681280954: {
                    return ((InterpolatedNodalCurve)bean).getXValues();
                }
                case -1726182661: {
                    return ((InterpolatedNodalCurve)bean).getYValues();
                }
                case 2096253127: {
                    return ((InterpolatedNodalCurve)bean).getInterpolator();
                }
                case 1271703994: {
                    return ((InterpolatedNodalCurve)bean).getExtrapolatorLeft();
                }
                case 773779145: {
                    return ((InterpolatedNodalCurve)bean).getExtrapolatorRight();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

