/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.curve;

import com.google.common.collect.ImmutableList;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.collect.array.DoubleMatrix;
import com.opengamma.strata.market.curve.CurveName;
import com.opengamma.strata.market.curve.CurveParameterSize;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class JacobianCalibrationMatrix
implements ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final ImmutableList<CurveParameterSize> order;
    @PropertyDefinition(validate="notNull")
    private final DoubleMatrix jacobianMatrix;
    private static final long serialVersionUID = 1L;

    public static JacobianCalibrationMatrix of(List<CurveParameterSize> order, DoubleMatrix jacobianMatrix) {
        return new JacobianCalibrationMatrix(order, jacobianMatrix);
    }

    public int getCurveCount() {
        return this.order.size();
    }

    public int getTotalParameterCount() {
        return this.order.stream().mapToInt(CurveParameterSize::getParameterCount).sum();
    }

    public boolean containsCurve(CurveName name) {
        return this.order.stream().anyMatch(o -> o.getName().equals(name));
    }

    public Map<CurveName, DoubleArray> splitValues(DoubleArray array) {
        LinkedHashMap<CurveName, DoubleArray> result = new LinkedHashMap<CurveName, DoubleArray>();
        int start = 0;
        for (CurveParameterSize paramSizes : this.order) {
            int size = paramSizes.getParameterCount();
            result.put(paramSizes.getName(), array.subArray(start, start + size));
            start += size;
        }
        return result;
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private JacobianCalibrationMatrix(List<CurveParameterSize> order, DoubleMatrix jacobianMatrix) {
        JodaBeanUtils.notNull(order, (String)"order");
        JodaBeanUtils.notNull((Object)jacobianMatrix, (String)"jacobianMatrix");
        this.order = ImmutableList.copyOf(order);
        this.jacobianMatrix = jacobianMatrix;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public ImmutableList<CurveParameterSize> getOrder() {
        return this.order;
    }

    public DoubleMatrix getJacobianMatrix() {
        return this.jacobianMatrix;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            JacobianCalibrationMatrix other = (JacobianCalibrationMatrix)obj;
            return JodaBeanUtils.equal(this.order, other.order) && JodaBeanUtils.equal((Object)this.jacobianMatrix, (Object)other.jacobianMatrix);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode(this.order);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.jacobianMatrix);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(96);
        buf.append("JacobianCalibrationMatrix{");
        buf.append("order").append('=').append(JodaBeanUtils.toString(this.order)).append(',').append(' ');
        buf.append("jacobianMatrix").append('=').append(JodaBeanUtils.toString((Object)this.jacobianMatrix));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<JacobianCalibrationMatrix> {
        private List<CurveParameterSize> order = ImmutableList.of();
        private DoubleMatrix jacobianMatrix;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 106006350: {
                    return this.order;
                }
                case 1656240056: {
                    return this.jacobianMatrix;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 106006350: {
                    this.order = (List)newValue;
                    break;
                }
                case 1656240056: {
                    this.jacobianMatrix = (DoubleMatrix)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public JacobianCalibrationMatrix build() {
            return new JacobianCalibrationMatrix(this.order, this.jacobianMatrix);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(96);
            buf.append("JacobianCalibrationMatrix.Builder{");
            buf.append("order").append('=').append(JodaBeanUtils.toString(this.order)).append(',').append(' ');
            buf.append("jacobianMatrix").append('=').append(JodaBeanUtils.toString((Object)this.jacobianMatrix));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<ImmutableList<CurveParameterSize>> order = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"order", JacobianCalibrationMatrix.class, ImmutableList.class);
        private final MetaProperty<DoubleMatrix> jacobianMatrix = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"jacobianMatrix", JacobianCalibrationMatrix.class, DoubleMatrix.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"order", "jacobianMatrix"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 106006350: {
                    return this.order;
                }
                case 1656240056: {
                    return this.jacobianMatrix;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends JacobianCalibrationMatrix> builder() {
            return new Builder();
        }

        public Class<? extends JacobianCalibrationMatrix> beanType() {
            return JacobianCalibrationMatrix.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<ImmutableList<CurveParameterSize>> order() {
            return this.order;
        }

        public MetaProperty<DoubleMatrix> jacobianMatrix() {
            return this.jacobianMatrix;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 106006350: {
                    return ((JacobianCalibrationMatrix)bean).getOrder();
                }
                case 1656240056: {
                    return ((JacobianCalibrationMatrix)bean).getJacobianMatrix();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

