/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.curve;

import com.opengamma.strata.collect.MapStream;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.market.curve.Curve;
import com.opengamma.strata.market.curve.CurveMetadata;
import com.opengamma.strata.market.curve.SimpleCurveParameterMetadata;
import com.opengamma.strata.market.param.ParameterMetadata;
import com.opengamma.strata.market.param.ParameterPerturbation;

public interface NodalCurve
extends Curve {
    @Override
    public NodalCurve withMetadata(CurveMetadata var1);

    @Override
    default public ParameterMetadata getParameterMetadata(int parameterIndex) {
        return this.getMetadata().getParameterMetadata().map(pm -> (ParameterMetadata)pm.get(parameterIndex)).orElse(SimpleCurveParameterMetadata.of(this.getMetadata().getXValueType(), this.getXValues().get(parameterIndex)));
    }

    public DoubleArray getXValues();

    public DoubleArray getYValues();

    public NodalCurve withYValues(DoubleArray var1);

    public NodalCurve withValues(DoubleArray var1, DoubleArray var2);

    default public MapStream<Double, Double> values() {
        return MapStream.zip(this.getXValues().stream().boxed(), this.getYValues().stream().boxed());
    }

    @Override
    public NodalCurve withParameter(int var1, double var2);

    @Override
    default public NodalCurve withPerturbation(ParameterPerturbation perturbation) {
        return (NodalCurve)Curve.super.withPerturbation(perturbation);
    }

    public NodalCurve withNode(double var1, double var3, ParameterMetadata var5);
}

