/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.curve;

import com.opengamma.strata.market.ShiftType;
import com.opengamma.strata.market.curve.Curve;
import com.opengamma.strata.market.curve.CurveMetadata;
import com.opengamma.strata.market.curve.CurveName;
import com.opengamma.strata.market.param.LabelParameterMetadata;
import com.opengamma.strata.market.param.ParameterMetadata;
import com.opengamma.strata.market.param.ParameterPerturbation;
import com.opengamma.strata.market.param.UnitParameterSensitivity;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class ParallelShiftedCurve
implements Curve,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final Curve underlyingCurve;
    @PropertyDefinition(validate="notNull")
    private final ShiftType shiftType;
    @PropertyDefinition(validate="notNull")
    private final double shiftAmount;
    private static final long serialVersionUID = 1L;

    public static ParallelShiftedCurve absolute(Curve curve, double shiftAmount) {
        return new ParallelShiftedCurve(curve, ShiftType.ABSOLUTE, shiftAmount);
    }

    public static ParallelShiftedCurve relative(Curve curve, double shiftAmount) {
        return new ParallelShiftedCurve(curve, ShiftType.RELATIVE, shiftAmount);
    }

    public static ParallelShiftedCurve of(Curve curve, ShiftType shiftType, double shiftAmount) {
        return new ParallelShiftedCurve(curve, shiftType, shiftAmount);
    }

    @Override
    public CurveMetadata getMetadata() {
        return this.underlyingCurve.getMetadata();
    }

    @Override
    public ParallelShiftedCurve withMetadata(CurveMetadata metadata) {
        return new ParallelShiftedCurve(this.underlyingCurve.withMetadata(metadata), this.shiftType, this.shiftAmount);
    }

    @Override
    public CurveName getName() {
        return this.underlyingCurve.getName();
    }

    @Override
    public int getParameterCount() {
        return this.underlyingCurve.getParameterCount() + 1;
    }

    @Override
    public double getParameter(int parameterIndex) {
        if (parameterIndex == this.underlyingCurve.getParameterCount()) {
            return this.shiftAmount;
        }
        return this.underlyingCurve.getParameter(parameterIndex);
    }

    @Override
    public ParameterMetadata getParameterMetadata(int parameterIndex) {
        if (parameterIndex == this.underlyingCurve.getParameterCount()) {
            return LabelParameterMetadata.of((Object)((Object)this.shiftType) + "Shift");
        }
        return this.underlyingCurve.getParameterMetadata(parameterIndex);
    }

    @Override
    public ParallelShiftedCurve withParameter(int parameterIndex, double newValue) {
        if (parameterIndex == this.underlyingCurve.getParameterCount()) {
            return new ParallelShiftedCurve(this.underlyingCurve, this.shiftType, newValue);
        }
        return new ParallelShiftedCurve(this.underlyingCurve.withParameter(parameterIndex, newValue), this.shiftType, this.shiftAmount);
    }

    @Override
    public ParallelShiftedCurve withPerturbation(ParameterPerturbation perturbation) {
        Curve bumpedCurve = this.underlyingCurve.withPerturbation(perturbation);
        int shiftIndex = this.underlyingCurve.getParameterCount();
        double bumpedShift = perturbation.perturbParameter(shiftIndex, this.shiftAmount, this.getParameterMetadata(shiftIndex));
        return new ParallelShiftedCurve(bumpedCurve, this.shiftType, bumpedShift);
    }

    @Override
    public double yValue(double x) {
        return this.shiftType.applyShift(this.underlyingCurve.yValue(x), this.shiftAmount);
    }

    @Override
    public UnitParameterSensitivity yValueParameterSensitivity(double x) {
        return this.underlyingCurve.yValueParameterSensitivity(x);
    }

    @Override
    public double firstDerivative(double x) {
        double firstDerivative = this.underlyingCurve.firstDerivative(x);
        switch (this.shiftType) {
            case ABSOLUTE: {
                return firstDerivative;
            }
            case RELATIVE: {
                return this.shiftType.applyShift(firstDerivative, this.shiftAmount);
            }
        }
        throw new IllegalArgumentException("Unsupported shift type " + (Object)((Object)this.shiftType));
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private ParallelShiftedCurve(Curve underlyingCurve, ShiftType shiftType, double shiftAmount) {
        JodaBeanUtils.notNull((Object)underlyingCurve, (String)"underlyingCurve");
        JodaBeanUtils.notNull((Object)((Object)shiftType), (String)"shiftType");
        JodaBeanUtils.notNull((Object)shiftAmount, (String)"shiftAmount");
        this.underlyingCurve = underlyingCurve;
        this.shiftType = shiftType;
        this.shiftAmount = shiftAmount;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public Curve getUnderlyingCurve() {
        return this.underlyingCurve;
    }

    public ShiftType getShiftType() {
        return this.shiftType;
    }

    public double getShiftAmount() {
        return this.shiftAmount;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            ParallelShiftedCurve other = (ParallelShiftedCurve)obj;
            return JodaBeanUtils.equal((Object)this.underlyingCurve, (Object)other.underlyingCurve) && JodaBeanUtils.equal((Object)((Object)this.shiftType), (Object)((Object)other.shiftType)) && JodaBeanUtils.equal((double)this.shiftAmount, (double)other.shiftAmount);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.underlyingCurve);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.shiftType));
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.shiftAmount);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("ParallelShiftedCurve{");
        buf.append("underlyingCurve").append('=').append(JodaBeanUtils.toString((Object)this.underlyingCurve)).append(',').append(' ');
        buf.append("shiftType").append('=').append(JodaBeanUtils.toString((Object)((Object)this.shiftType))).append(',').append(' ');
        buf.append("shiftAmount").append('=').append(JodaBeanUtils.toString((Object)this.shiftAmount));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<ParallelShiftedCurve> {
        private Curve underlyingCurve;
        private ShiftType shiftType;
        private double shiftAmount;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case -839394414: {
                    return this.underlyingCurve;
                }
                case 893345500: {
                    return this.shiftType;
                }
                case -1043480710: {
                    return this.shiftAmount;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case -839394414: {
                    this.underlyingCurve = (Curve)newValue;
                    break;
                }
                case 893345500: {
                    this.shiftType = (ShiftType)((Object)newValue);
                    break;
                }
                case -1043480710: {
                    this.shiftAmount = (Double)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public ParallelShiftedCurve build() {
            return new ParallelShiftedCurve(this.underlyingCurve, this.shiftType, this.shiftAmount);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(128);
            buf.append("ParallelShiftedCurve.Builder{");
            buf.append("underlyingCurve").append('=').append(JodaBeanUtils.toString((Object)this.underlyingCurve)).append(',').append(' ');
            buf.append("shiftType").append('=').append(JodaBeanUtils.toString((Object)((Object)this.shiftType))).append(',').append(' ');
            buf.append("shiftAmount").append('=').append(JodaBeanUtils.toString((Object)this.shiftAmount));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<Curve> underlyingCurve = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"underlyingCurve", ParallelShiftedCurve.class, Curve.class);
        private final MetaProperty<ShiftType> shiftType = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"shiftType", ParallelShiftedCurve.class, ShiftType.class);
        private final MetaProperty<Double> shiftAmount = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"shiftAmount", ParallelShiftedCurve.class, Double.TYPE);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"underlyingCurve", "shiftType", "shiftAmount"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case -839394414: {
                    return this.underlyingCurve;
                }
                case 893345500: {
                    return this.shiftType;
                }
                case -1043480710: {
                    return this.shiftAmount;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends ParallelShiftedCurve> builder() {
            return new Builder();
        }

        public Class<? extends ParallelShiftedCurve> beanType() {
            return ParallelShiftedCurve.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<Curve> underlyingCurve() {
            return this.underlyingCurve;
        }

        public MetaProperty<ShiftType> shiftType() {
            return this.shiftType;
        }

        public MetaProperty<Double> shiftAmount() {
            return this.shiftAmount;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case -839394414: {
                    return ((ParallelShiftedCurve)bean).getUnderlyingCurve();
                }
                case 893345500: {
                    return ((ParallelShiftedCurve)bean).getShiftType();
                }
                case -1043480710: {
                    return ((ParallelShiftedCurve)bean).getShiftAmount();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

