/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.curve;

import com.google.common.collect.ImmutableList;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.date.DayCount;
import com.opengamma.strata.collect.Guavate;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.collect.tuple.Pair;
import com.opengamma.strata.data.MarketData;
import com.opengamma.strata.market.ValueType;
import com.opengamma.strata.market.curve.CurveDefinition;
import com.opengamma.strata.market.curve.CurveMetadata;
import com.opengamma.strata.market.curve.CurveName;
import com.opengamma.strata.market.curve.CurveNode;
import com.opengamma.strata.market.curve.CurveNodeDateOrder;
import com.opengamma.strata.market.curve.DefaultCurveMetadata;
import com.opengamma.strata.market.curve.ParameterizedFunctionalCurve;
import com.opengamma.strata.market.param.ParameterMetadata;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutablePreBuild;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class ParameterizedFunctionalCurveDefinition
implements CurveDefinition,
ImmutableBean {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final CurveName name;
    @PropertyDefinition(validate="notNull")
    private final ValueType xValueType;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final ValueType yValueType;
    @PropertyDefinition(get="optional")
    private final DayCount dayCount;
    @PropertyDefinition(validate="notNull", builderType="List<? extends CurveNode>", overrideGet=true)
    private final ImmutableList<CurveNode> nodes;
    @PropertyDefinition(validate="notNull")
    private final ImmutableList<Double> initialGuess;
    @PropertyDefinition(validate="notNull", builderType="List<? extends ParameterMetadata>")
    private final ImmutableList<ParameterMetadata> parameterMetadata;
    @PropertyDefinition(validate="notNull")
    private final BiFunction<DoubleArray, Double, Double> valueFunction;
    @PropertyDefinition(validate="notNull")
    private final BiFunction<DoubleArray, Double, Double> derivativeFunction;
    @PropertyDefinition(validate="notNull")
    private final BiFunction<DoubleArray, Double, DoubleArray> sensitivityFunction;

    @ImmutablePreBuild
    private static void preBuild(Builder builder) {
        if (builder.parameterMetadata.size() == 0 && builder.initialGuess != null) {
            builder.parameterMetadata = ParameterMetadata.listOfEmpty(builder.initialGuess.size());
        }
    }

    @Override
    public ParameterizedFunctionalCurveDefinition filtered(LocalDate valuationDate, ReferenceData refData) {
        Pair pairAfter;
        Pair pairBefore;
        CurveNodeDateOrder restriction;
        Pair pair;
        int i;
        ArrayList nodeDates = this.nodes.stream().map(node -> Pair.of((Object)node.date(valuationDate, refData), (Object)node)).collect(Collectors.toCollection(ArrayList::new));
        block10: for (i = 0; i < nodeDates.size(); ++i) {
            pair = (Pair)nodeDates.get(i);
            restriction = ((CurveNode)pair.getSecond()).getDateOrder();
            if (i > 0 && ChronoUnit.DAYS.between((Temporal)(pairBefore = (Pair)nodeDates.get(i - 1)).getFirst(), (Temporal)pair.getFirst()) < (long)restriction.getMinGapInDays()) {
                switch (restriction.getAction()) {
                    case DROP_THIS: {
                        nodeDates.remove(i);
                        i = -1;
                        continue block10;
                    }
                    case DROP_OTHER: {
                        nodeDates.remove(i - 1);
                        i = -1;
                        continue block10;
                    }
                    case EXCEPTION: {
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected enum value");
                    }
                }
            }
            if (i >= nodeDates.size() - 1) continue;
            pairAfter = (Pair)nodeDates.get(i + 1);
            if (ChronoUnit.DAYS.between((Temporal)pair.getFirst(), (Temporal)pairAfter.getFirst()) >= (long)restriction.getMinGapInDays()) continue;
            switch (restriction.getAction()) {
                case DROP_THIS: {
                    nodeDates.remove(i);
                    i = -1;
                    continue block10;
                }
                case DROP_OTHER: {
                    nodeDates.remove(i + 1);
                    i = -1;
                    continue block10;
                }
                case EXCEPTION: {
                    continue block10;
                }
                default: {
                    throw new IllegalStateException("Unexpected enum value");
                }
            }
        }
        for (i = 0; i < nodeDates.size(); ++i) {
            pair = (Pair)nodeDates.get(i);
            restriction = ((CurveNode)pair.getSecond()).getDateOrder();
            if (i > 0 && ChronoUnit.DAYS.between((Temporal)(pairBefore = (Pair)nodeDates.get(i - 1)).getFirst(), (Temporal)pair.getFirst()) < (long)restriction.getMinGapInDays()) {
                throw new IllegalArgumentException(Messages.format((String)"Curve node dates clash, node '{}' and '{}' resolved to dates '{}' and '{}' respectively", (Object[])new Object[]{((CurveNode)pairBefore.getSecond()).getLabel(), ((CurveNode)pair.getSecond()).getLabel(), pairBefore.getFirst(), pair.getFirst()}));
            }
            if (i >= nodeDates.size() - 1) continue;
            pairAfter = (Pair)nodeDates.get(i + 1);
            if (ChronoUnit.DAYS.between((Temporal)pair.getFirst(), (Temporal)pairAfter.getFirst()) >= (long)restriction.getMinGapInDays()) continue;
            throw new IllegalArgumentException(Messages.format((String)"Curve node dates clash, node '{}' and '{}' resolved to dates '{}' and '{}' respectively", (Object[])new Object[]{((CurveNode)pair.getSecond()).getLabel(), ((CurveNode)pairAfter.getSecond()).getLabel(), pair.getFirst(), pairAfter.getFirst()}));
        }
        List filteredNodes = (List)nodeDates.stream().map(p -> (CurveNode)p.getSecond()).collect(Guavate.toImmutableList());
        return new ParameterizedFunctionalCurveDefinition(this.name, this.xValueType, this.yValueType, this.dayCount, filteredNodes, (List<Double>)this.initialGuess, (List<? extends ParameterMetadata>)this.parameterMetadata, this.valueFunction, this.derivativeFunction, this.sensitivityFunction);
    }

    @Override
    public CurveMetadata metadata(LocalDate valuationDate, ReferenceData refData) {
        return DefaultCurveMetadata.builder().curveName(this.name).xValueType(this.xValueType).yValueType(this.yValueType).dayCount(this.dayCount).parameterMetadata((List<? extends ParameterMetadata>)this.parameterMetadata).build();
    }

    @Override
    public ParameterizedFunctionalCurve curve(LocalDate valuationDate, CurveMetadata metadata, DoubleArray parameters) {
        return ParameterizedFunctionalCurve.of(metadata, parameters, this.valueFunction, this.derivativeFunction, this.sensitivityFunction);
    }

    @Override
    public int getParameterCount() {
        return this.initialGuess.size();
    }

    @Override
    public ImmutableList<Double> initialGuess(MarketData marketData) {
        return this.getInitialGuess();
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private ParameterizedFunctionalCurveDefinition(CurveName name, ValueType xValueType, ValueType yValueType, DayCount dayCount, List<? extends CurveNode> nodes, List<Double> initialGuess, List<? extends ParameterMetadata> parameterMetadata, BiFunction<DoubleArray, Double, Double> valueFunction, BiFunction<DoubleArray, Double, Double> derivativeFunction, BiFunction<DoubleArray, Double, DoubleArray> sensitivityFunction) {
        JodaBeanUtils.notNull((Object)name, (String)"name");
        JodaBeanUtils.notNull((Object)((Object)xValueType), (String)"xValueType");
        JodaBeanUtils.notNull((Object)((Object)yValueType), (String)"yValueType");
        JodaBeanUtils.notNull(nodes, (String)"nodes");
        JodaBeanUtils.notNull(initialGuess, (String)"initialGuess");
        JodaBeanUtils.notNull(parameterMetadata, (String)"parameterMetadata");
        JodaBeanUtils.notNull(valueFunction, (String)"valueFunction");
        JodaBeanUtils.notNull(derivativeFunction, (String)"derivativeFunction");
        JodaBeanUtils.notNull(sensitivityFunction, (String)"sensitivityFunction");
        this.name = name;
        this.xValueType = xValueType;
        this.yValueType = yValueType;
        this.dayCount = dayCount;
        this.nodes = ImmutableList.copyOf(nodes);
        this.initialGuess = ImmutableList.copyOf(initialGuess);
        this.parameterMetadata = ImmutableList.copyOf(parameterMetadata);
        this.valueFunction = valueFunction;
        this.derivativeFunction = derivativeFunction;
        this.sensitivityFunction = sensitivityFunction;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public CurveName getName() {
        return this.name;
    }

    public ValueType getXValueType() {
        return this.xValueType;
    }

    @Override
    public ValueType getYValueType() {
        return this.yValueType;
    }

    public Optional<DayCount> getDayCount() {
        return Optional.ofNullable(this.dayCount);
    }

    @Override
    public ImmutableList<CurveNode> getNodes() {
        return this.nodes;
    }

    public ImmutableList<Double> getInitialGuess() {
        return this.initialGuess;
    }

    public ImmutableList<ParameterMetadata> getParameterMetadata() {
        return this.parameterMetadata;
    }

    public BiFunction<DoubleArray, Double, Double> getValueFunction() {
        return this.valueFunction;
    }

    public BiFunction<DoubleArray, Double, Double> getDerivativeFunction() {
        return this.derivativeFunction;
    }

    public BiFunction<DoubleArray, Double, DoubleArray> getSensitivityFunction() {
        return this.sensitivityFunction;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            ParameterizedFunctionalCurveDefinition other = (ParameterizedFunctionalCurveDefinition)obj;
            return JodaBeanUtils.equal((Object)this.name, (Object)other.name) && JodaBeanUtils.equal((Object)((Object)this.xValueType), (Object)((Object)other.xValueType)) && JodaBeanUtils.equal((Object)((Object)this.yValueType), (Object)((Object)other.yValueType)) && JodaBeanUtils.equal((Object)this.dayCount, (Object)other.dayCount) && JodaBeanUtils.equal(this.nodes, other.nodes) && JodaBeanUtils.equal(this.initialGuess, other.initialGuess) && JodaBeanUtils.equal(this.parameterMetadata, other.parameterMetadata) && JodaBeanUtils.equal(this.valueFunction, other.valueFunction) && JodaBeanUtils.equal(this.derivativeFunction, other.derivativeFunction) && JodaBeanUtils.equal(this.sensitivityFunction, other.sensitivityFunction);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.name);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.xValueType));
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.yValueType));
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.dayCount);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.nodes);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.initialGuess);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.parameterMetadata);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.valueFunction);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.derivativeFunction);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.sensitivityFunction);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(352);
        buf.append("ParameterizedFunctionalCurveDefinition{");
        buf.append("name").append('=').append(JodaBeanUtils.toString((Object)this.name)).append(',').append(' ');
        buf.append("xValueType").append('=').append(JodaBeanUtils.toString((Object)((Object)this.xValueType))).append(',').append(' ');
        buf.append("yValueType").append('=').append(JodaBeanUtils.toString((Object)((Object)this.yValueType))).append(',').append(' ');
        buf.append("dayCount").append('=').append(JodaBeanUtils.toString((Object)this.dayCount)).append(',').append(' ');
        buf.append("nodes").append('=').append(JodaBeanUtils.toString(this.nodes)).append(',').append(' ');
        buf.append("initialGuess").append('=').append(JodaBeanUtils.toString(this.initialGuess)).append(',').append(' ');
        buf.append("parameterMetadata").append('=').append(JodaBeanUtils.toString(this.parameterMetadata)).append(',').append(' ');
        buf.append("valueFunction").append('=').append(JodaBeanUtils.toString(this.valueFunction)).append(',').append(' ');
        buf.append("derivativeFunction").append('=').append(JodaBeanUtils.toString(this.derivativeFunction)).append(',').append(' ');
        buf.append("sensitivityFunction").append('=').append(JodaBeanUtils.toString(this.sensitivityFunction));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<ParameterizedFunctionalCurveDefinition> {
        private CurveName name;
        private ValueType xValueType;
        private ValueType yValueType;
        private DayCount dayCount;
        private List<? extends CurveNode> nodes = ImmutableList.of();
        private List<Double> initialGuess = ImmutableList.of();
        private List<? extends ParameterMetadata> parameterMetadata = ImmutableList.of();
        private BiFunction<DoubleArray, Double, Double> valueFunction;
        private BiFunction<DoubleArray, Double, Double> derivativeFunction;
        private BiFunction<DoubleArray, Double, DoubleArray> sensitivityFunction;

        private Builder() {
        }

        private Builder(ParameterizedFunctionalCurveDefinition beanToCopy) {
            this.name = beanToCopy.getName();
            this.xValueType = beanToCopy.getXValueType();
            this.yValueType = beanToCopy.getYValueType();
            this.dayCount = beanToCopy.dayCount;
            this.nodes = beanToCopy.getNodes();
            this.initialGuess = beanToCopy.getInitialGuess();
            this.parameterMetadata = beanToCopy.getParameterMetadata();
            this.valueFunction = beanToCopy.getValueFunction();
            this.derivativeFunction = beanToCopy.getDerivativeFunction();
            this.sensitivityFunction = beanToCopy.getSensitivityFunction();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    return this.name;
                }
                case -868509005: {
                    return this.xValueType;
                }
                case -1065022510: {
                    return this.yValueType;
                }
                case 1905311443: {
                    return this.dayCount;
                }
                case 104993457: {
                    return this.nodes;
                }
                case -431632141: {
                    return this.initialGuess;
                }
                case -1169106440: {
                    return this.parameterMetadata;
                }
                case 636119145: {
                    return this.valueFunction;
                }
                case 1663351423: {
                    return this.derivativeFunction;
                }
                case -1353652329: {
                    return this.sensitivityFunction;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    this.name = (CurveName)newValue;
                    break;
                }
                case -868509005: {
                    this.xValueType = (ValueType)((Object)newValue);
                    break;
                }
                case -1065022510: {
                    this.yValueType = (ValueType)((Object)newValue);
                    break;
                }
                case 1905311443: {
                    this.dayCount = (DayCount)newValue;
                    break;
                }
                case 104993457: {
                    this.nodes = (List)newValue;
                    break;
                }
                case -431632141: {
                    this.initialGuess = (List)newValue;
                    break;
                }
                case -1169106440: {
                    this.parameterMetadata = (List)newValue;
                    break;
                }
                case 636119145: {
                    this.valueFunction = (BiFunction)newValue;
                    break;
                }
                case 1663351423: {
                    this.derivativeFunction = (BiFunction)newValue;
                    break;
                }
                case -1353652329: {
                    this.sensitivityFunction = (BiFunction)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public ParameterizedFunctionalCurveDefinition build() {
            ParameterizedFunctionalCurveDefinition.preBuild(this);
            return new ParameterizedFunctionalCurveDefinition(this.name, this.xValueType, this.yValueType, this.dayCount, this.nodes, this.initialGuess, this.parameterMetadata, this.valueFunction, this.derivativeFunction, this.sensitivityFunction);
        }

        public Builder name(CurveName name) {
            JodaBeanUtils.notNull((Object)name, (String)"name");
            this.name = name;
            return this;
        }

        public Builder xValueType(ValueType xValueType) {
            JodaBeanUtils.notNull((Object)((Object)xValueType), (String)"xValueType");
            this.xValueType = xValueType;
            return this;
        }

        public Builder yValueType(ValueType yValueType) {
            JodaBeanUtils.notNull((Object)((Object)yValueType), (String)"yValueType");
            this.yValueType = yValueType;
            return this;
        }

        public Builder dayCount(DayCount dayCount) {
            this.dayCount = dayCount;
            return this;
        }

        public Builder nodes(List<? extends CurveNode> nodes) {
            JodaBeanUtils.notNull(nodes, (String)"nodes");
            this.nodes = nodes;
            return this;
        }

        public Builder nodes(CurveNode ... nodes) {
            return this.nodes((List<? extends CurveNode>)ImmutableList.copyOf((Object[])nodes));
        }

        public Builder initialGuess(List<Double> initialGuess) {
            JodaBeanUtils.notNull(initialGuess, (String)"initialGuess");
            this.initialGuess = initialGuess;
            return this;
        }

        public Builder initialGuess(Double ... initialGuess) {
            return this.initialGuess((List<Double>)ImmutableList.copyOf((Object[])initialGuess));
        }

        public Builder parameterMetadata(List<? extends ParameterMetadata> parameterMetadata) {
            JodaBeanUtils.notNull(parameterMetadata, (String)"parameterMetadata");
            this.parameterMetadata = parameterMetadata;
            return this;
        }

        public Builder parameterMetadata(ParameterMetadata ... parameterMetadata) {
            return this.parameterMetadata((List<? extends ParameterMetadata>)ImmutableList.copyOf((Object[])parameterMetadata));
        }

        public Builder valueFunction(BiFunction<DoubleArray, Double, Double> valueFunction) {
            JodaBeanUtils.notNull(valueFunction, (String)"valueFunction");
            this.valueFunction = valueFunction;
            return this;
        }

        public Builder derivativeFunction(BiFunction<DoubleArray, Double, Double> derivativeFunction) {
            JodaBeanUtils.notNull(derivativeFunction, (String)"derivativeFunction");
            this.derivativeFunction = derivativeFunction;
            return this;
        }

        public Builder sensitivityFunction(BiFunction<DoubleArray, Double, DoubleArray> sensitivityFunction) {
            JodaBeanUtils.notNull(sensitivityFunction, (String)"sensitivityFunction");
            this.sensitivityFunction = sensitivityFunction;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(352);
            buf.append("ParameterizedFunctionalCurveDefinition.Builder{");
            buf.append("name").append('=').append(JodaBeanUtils.toString((Object)this.name)).append(',').append(' ');
            buf.append("xValueType").append('=').append(JodaBeanUtils.toString((Object)((Object)this.xValueType))).append(',').append(' ');
            buf.append("yValueType").append('=').append(JodaBeanUtils.toString((Object)((Object)this.yValueType))).append(',').append(' ');
            buf.append("dayCount").append('=').append(JodaBeanUtils.toString((Object)this.dayCount)).append(',').append(' ');
            buf.append("nodes").append('=').append(JodaBeanUtils.toString(this.nodes)).append(',').append(' ');
            buf.append("initialGuess").append('=').append(JodaBeanUtils.toString(this.initialGuess)).append(',').append(' ');
            buf.append("parameterMetadata").append('=').append(JodaBeanUtils.toString(this.parameterMetadata)).append(',').append(' ');
            buf.append("valueFunction").append('=').append(JodaBeanUtils.toString(this.valueFunction)).append(',').append(' ');
            buf.append("derivativeFunction").append('=').append(JodaBeanUtils.toString(this.derivativeFunction)).append(',').append(' ');
            buf.append("sensitivityFunction").append('=').append(JodaBeanUtils.toString(this.sensitivityFunction));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<CurveName> name = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"name", ParameterizedFunctionalCurveDefinition.class, CurveName.class);
        private final MetaProperty<ValueType> xValueType = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"xValueType", ParameterizedFunctionalCurveDefinition.class, ValueType.class);
        private final MetaProperty<ValueType> yValueType = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"yValueType", ParameterizedFunctionalCurveDefinition.class, ValueType.class);
        private final MetaProperty<DayCount> dayCount = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"dayCount", ParameterizedFunctionalCurveDefinition.class, DayCount.class);
        private final MetaProperty<ImmutableList<CurveNode>> nodes = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"nodes", ParameterizedFunctionalCurveDefinition.class, ImmutableList.class);
        private final MetaProperty<ImmutableList<Double>> initialGuess = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"initialGuess", ParameterizedFunctionalCurveDefinition.class, ImmutableList.class);
        private final MetaProperty<ImmutableList<ParameterMetadata>> parameterMetadata = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"parameterMetadata", ParameterizedFunctionalCurveDefinition.class, ImmutableList.class);
        private final MetaProperty<BiFunction<DoubleArray, Double, Double>> valueFunction = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"valueFunction", ParameterizedFunctionalCurveDefinition.class, BiFunction.class);
        private final MetaProperty<BiFunction<DoubleArray, Double, Double>> derivativeFunction = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"derivativeFunction", ParameterizedFunctionalCurveDefinition.class, BiFunction.class);
        private final MetaProperty<BiFunction<DoubleArray, Double, DoubleArray>> sensitivityFunction = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"sensitivityFunction", ParameterizedFunctionalCurveDefinition.class, BiFunction.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"name", "xValueType", "yValueType", "dayCount", "nodes", "initialGuess", "parameterMetadata", "valueFunction", "derivativeFunction", "sensitivityFunction"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    return this.name;
                }
                case -868509005: {
                    return this.xValueType;
                }
                case -1065022510: {
                    return this.yValueType;
                }
                case 1905311443: {
                    return this.dayCount;
                }
                case 104993457: {
                    return this.nodes;
                }
                case -431632141: {
                    return this.initialGuess;
                }
                case -1169106440: {
                    return this.parameterMetadata;
                }
                case 636119145: {
                    return this.valueFunction;
                }
                case 1663351423: {
                    return this.derivativeFunction;
                }
                case -1353652329: {
                    return this.sensitivityFunction;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends ParameterizedFunctionalCurveDefinition> beanType() {
            return ParameterizedFunctionalCurveDefinition.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<CurveName> name() {
            return this.name;
        }

        public MetaProperty<ValueType> xValueType() {
            return this.xValueType;
        }

        public MetaProperty<ValueType> yValueType() {
            return this.yValueType;
        }

        public MetaProperty<DayCount> dayCount() {
            return this.dayCount;
        }

        public MetaProperty<ImmutableList<CurveNode>> nodes() {
            return this.nodes;
        }

        public MetaProperty<ImmutableList<Double>> initialGuess() {
            return this.initialGuess;
        }

        public MetaProperty<ImmutableList<ParameterMetadata>> parameterMetadata() {
            return this.parameterMetadata;
        }

        public MetaProperty<BiFunction<DoubleArray, Double, Double>> valueFunction() {
            return this.valueFunction;
        }

        public MetaProperty<BiFunction<DoubleArray, Double, Double>> derivativeFunction() {
            return this.derivativeFunction;
        }

        public MetaProperty<BiFunction<DoubleArray, Double, DoubleArray>> sensitivityFunction() {
            return this.sensitivityFunction;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    return ((ParameterizedFunctionalCurveDefinition)bean).getName();
                }
                case -868509005: {
                    return ((ParameterizedFunctionalCurveDefinition)bean).getXValueType();
                }
                case -1065022510: {
                    return ((ParameterizedFunctionalCurveDefinition)bean).getYValueType();
                }
                case 1905311443: {
                    return ((ParameterizedFunctionalCurveDefinition)bean).dayCount;
                }
                case 104993457: {
                    return ((ParameterizedFunctionalCurveDefinition)bean).getNodes();
                }
                case -431632141: {
                    return ((ParameterizedFunctionalCurveDefinition)bean).getInitialGuess();
                }
                case -1169106440: {
                    return ((ParameterizedFunctionalCurveDefinition)bean).getParameterMetadata();
                }
                case 636119145: {
                    return ((ParameterizedFunctionalCurveDefinition)bean).getValueFunction();
                }
                case 1663351423: {
                    return ((ParameterizedFunctionalCurveDefinition)bean).getDerivativeFunction();
                }
                case -1353652329: {
                    return ((ParameterizedFunctionalCurveDefinition)bean).getSensitivityFunction();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

