/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.curve;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.market.ShiftType;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class SeasonalityDefinition
implements ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final DoubleArray seasonalityMonthOnMonth;
    @PropertyDefinition(validate="notNull")
    private final ShiftType adjustmentType;
    private static final long serialVersionUID = 1L;

    public static SeasonalityDefinition of(DoubleArray seasonalityMonthOnMonth, ShiftType adjustmentType) {
        ArgChecker.isTrue((seasonalityMonthOnMonth.size() == 12 ? 1 : 0) != 0, (String)"seasonality must be of length 12");
        return new SeasonalityDefinition(seasonalityMonthOnMonth, adjustmentType);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private SeasonalityDefinition(DoubleArray seasonalityMonthOnMonth, ShiftType adjustmentType) {
        JodaBeanUtils.notNull((Object)seasonalityMonthOnMonth, (String)"seasonalityMonthOnMonth");
        JodaBeanUtils.notNull((Object)((Object)adjustmentType), (String)"adjustmentType");
        this.seasonalityMonthOnMonth = seasonalityMonthOnMonth;
        this.adjustmentType = adjustmentType;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public DoubleArray getSeasonalityMonthOnMonth() {
        return this.seasonalityMonthOnMonth;
    }

    public ShiftType getAdjustmentType() {
        return this.adjustmentType;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            SeasonalityDefinition other = (SeasonalityDefinition)obj;
            return JodaBeanUtils.equal((Object)this.seasonalityMonthOnMonth, (Object)other.seasonalityMonthOnMonth) && JodaBeanUtils.equal((Object)((Object)this.adjustmentType), (Object)((Object)other.adjustmentType));
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.seasonalityMonthOnMonth);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.adjustmentType));
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(96);
        buf.append("SeasonalityDefinition{");
        buf.append("seasonalityMonthOnMonth").append('=').append(JodaBeanUtils.toString((Object)this.seasonalityMonthOnMonth)).append(',').append(' ');
        buf.append("adjustmentType").append('=').append(JodaBeanUtils.toString((Object)((Object)this.adjustmentType)));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<SeasonalityDefinition> {
        private DoubleArray seasonalityMonthOnMonth;
        private ShiftType adjustmentType;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case -731183871: {
                    return this.seasonalityMonthOnMonth;
                }
                case -1002343865: {
                    return this.adjustmentType;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case -731183871: {
                    this.seasonalityMonthOnMonth = (DoubleArray)newValue;
                    break;
                }
                case -1002343865: {
                    this.adjustmentType = (ShiftType)((Object)newValue);
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public SeasonalityDefinition build() {
            return new SeasonalityDefinition(this.seasonalityMonthOnMonth, this.adjustmentType);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(96);
            buf.append("SeasonalityDefinition.Builder{");
            buf.append("seasonalityMonthOnMonth").append('=').append(JodaBeanUtils.toString((Object)this.seasonalityMonthOnMonth)).append(',').append(' ');
            buf.append("adjustmentType").append('=').append(JodaBeanUtils.toString((Object)((Object)this.adjustmentType)));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<DoubleArray> seasonalityMonthOnMonth = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"seasonalityMonthOnMonth", SeasonalityDefinition.class, DoubleArray.class);
        private final MetaProperty<ShiftType> adjustmentType = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"adjustmentType", SeasonalityDefinition.class, ShiftType.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"seasonalityMonthOnMonth", "adjustmentType"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case -731183871: {
                    return this.seasonalityMonthOnMonth;
                }
                case -1002343865: {
                    return this.adjustmentType;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends SeasonalityDefinition> builder() {
            return new Builder();
        }

        public Class<? extends SeasonalityDefinition> beanType() {
            return SeasonalityDefinition.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<DoubleArray> seasonalityMonthOnMonth() {
            return this.seasonalityMonthOnMonth;
        }

        public MetaProperty<ShiftType> adjustmentType() {
            return this.adjustmentType;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case -731183871: {
                    return ((SeasonalityDefinition)bean).getSeasonalityMonthOnMonth();
                }
                case -1002343865: {
                    return ((SeasonalityDefinition)bean).getAdjustmentType();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

