/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.curve.interpolator;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.market.curve.interpolator.BoundCurveExtrapolator;
import com.opengamma.strata.market.curve.interpolator.BoundCurveInterpolator;
import com.opengamma.strata.market.curve.interpolator.ExceptionCurveExtrapolator;

public abstract class AbstractBoundCurveInterpolator
implements BoundCurveInterpolator {
    private static long NEGATIVE_ZERO_BITS = Double.doubleToRawLongBits(-0.0);
    private final BoundCurveExtrapolator extrapolatorLeft;
    private final BoundCurveExtrapolator extrapolatorRight;
    private final double firstXValue;
    private final double lastXValue;
    private final double lastYValue;

    protected AbstractBoundCurveInterpolator(DoubleArray xValues, DoubleArray yValues) {
        ArgChecker.notNull((Object)xValues, (String)"xValues");
        ArgChecker.notNull((Object)yValues, (String)"yValues");
        int size = xValues.size();
        ArgChecker.isTrue((size == yValues.size() ? 1 : 0) != 0, (String)"Curve node arrays must have same size");
        ArgChecker.isTrue((size > 1 ? 1 : 0) != 0, (String)"Curve node arrays must have at least two nodes");
        this.extrapolatorLeft = ExceptionCurveExtrapolator.INSTANCE;
        this.extrapolatorRight = ExceptionCurveExtrapolator.INSTANCE;
        this.firstXValue = xValues.get(0);
        this.lastXValue = xValues.get(size - 1);
        this.lastYValue = yValues.get(size - 1);
    }

    protected AbstractBoundCurveInterpolator(AbstractBoundCurveInterpolator base, BoundCurveExtrapolator extrapolatorLeft, BoundCurveExtrapolator extrapolatorRight) {
        this.extrapolatorLeft = (BoundCurveExtrapolator)ArgChecker.notNull((Object)extrapolatorLeft, (String)"extrapolatorLeft");
        this.extrapolatorRight = (BoundCurveExtrapolator)ArgChecker.notNull((Object)extrapolatorRight, (String)"extrapolatorRight");
        this.firstXValue = base.firstXValue;
        this.lastXValue = base.lastXValue;
        this.lastYValue = base.lastYValue;
    }

    @Override
    public final double interpolate(double xValue) {
        if (xValue < this.firstXValue) {
            return this.extrapolatorLeft.leftExtrapolate(xValue);
        }
        if (xValue > this.lastXValue) {
            return this.extrapolatorRight.rightExtrapolate(xValue);
        }
        if (xValue == this.lastXValue) {
            return this.lastYValue;
        }
        return this.doInterpolate(xValue);
    }

    protected abstract double doInterpolate(double var1);

    protected double doInterpolateFromExtrapolator(double xValue) {
        return this.doInterpolate(xValue);
    }

    @Override
    public final double firstDerivative(double xValue) {
        if (xValue < this.firstXValue) {
            return this.extrapolatorLeft.leftExtrapolateFirstDerivative(xValue);
        }
        if (xValue > this.lastXValue) {
            return this.extrapolatorRight.rightExtrapolateFirstDerivative(xValue);
        }
        return this.doFirstDerivative(xValue);
    }

    protected abstract double doFirstDerivative(double var1);

    @Override
    public final DoubleArray parameterSensitivity(double xValue) {
        if (xValue < this.firstXValue) {
            return this.extrapolatorLeft.leftExtrapolateParameterSensitivity(xValue);
        }
        if (xValue > this.lastXValue) {
            return this.extrapolatorRight.rightExtrapolateParameterSensitivity(xValue);
        }
        return this.doParameterSensitivity(xValue);
    }

    protected abstract DoubleArray doParameterSensitivity(double var1);

    protected static int lowerBoundIndex(double xValue, double[] xValues) {
        if (Double.doubleToRawLongBits(xValue) == NEGATIVE_ZERO_BITS) {
            return AbstractBoundCurveInterpolator.lowerBoundIndex(0.0, xValues);
        }
        int lo = 1;
        int hi = xValues.length - 1;
        while (lo <= hi) {
            int mid = lo + hi >>> 1;
            double midVal = xValues[mid];
            if (midVal < xValue) {
                lo = mid + 1;
                continue;
            }
            if (midVal > xValue) {
                hi = mid - 1;
                continue;
            }
            return mid;
        }
        return lo - 1;
    }
}

