/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.curve.interpolator;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.collect.named.ExtendedEnum;
import com.opengamma.strata.collect.named.Named;
import com.opengamma.strata.market.curve.interpolator.BoundCurveExtrapolator;
import com.opengamma.strata.market.curve.interpolator.BoundCurveInterpolator;
import com.opengamma.strata.market.curve.interpolator.CurveExtrapolator;
import com.opengamma.strata.market.curve.interpolator.CurveInterpolators;
import org.joda.convert.FromString;
import org.joda.convert.ToString;

public interface CurveInterpolator
extends Named {
    @FromString
    public static CurveInterpolator of(String uniqueName) {
        ArgChecker.notNull((Object)uniqueName, (String)"uniqueName");
        return (CurveInterpolator)CurveInterpolator.extendedEnum().lookup(uniqueName);
    }

    public static ExtendedEnum<CurveInterpolator> extendedEnum() {
        return CurveInterpolators.ENUM_LOOKUP;
    }

    public BoundCurveInterpolator bind(DoubleArray var1, DoubleArray var2);

    default public BoundCurveInterpolator bind(DoubleArray xValues, DoubleArray yValues, CurveExtrapolator extrapolatorLeft, CurveExtrapolator extrapolatorRight) {
        BoundCurveInterpolator interpolatorOnly = this.bind(xValues, yValues);
        BoundCurveExtrapolator boundLeft = extrapolatorLeft.bind(xValues, yValues, interpolatorOnly);
        BoundCurveExtrapolator boundRight = extrapolatorRight.bind(xValues, yValues, interpolatorOnly);
        return interpolatorOnly.bind(boundLeft, boundRight);
    }

    @ToString
    public String getName();
}

