/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.curve.interpolator;

import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.market.curve.interpolator.BoundCurveExtrapolator;
import com.opengamma.strata.market.curve.interpolator.BoundCurveInterpolator;
import com.opengamma.strata.market.curve.interpolator.CurveExtrapolator;
import java.io.Serializable;

class DiscountFactorLinearRightZeroRateCurveExtrapolator
implements CurveExtrapolator,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String NAME = "DiscountFactorLinearRightZeroRateCurve";
    public static final CurveExtrapolator INSTANCE = new DiscountFactorLinearRightZeroRateCurveExtrapolator();
    private static final double EPS = 1.0E-8;

    private DiscountFactorLinearRightZeroRateCurveExtrapolator() {
    }

    private Object readResolve() {
        return INSTANCE;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public BoundCurveExtrapolator bind(DoubleArray xValues, DoubleArray yValues, BoundCurveInterpolator interpolator) {
        return new Bound(xValues, yValues, interpolator);
    }

    public String toString() {
        return NAME;
    }

    static class Bound
    implements BoundCurveExtrapolator {
        private final int nodeCount;
        private final double lastXValue;
        private final double lastYValue;
        private final double lastDf;
        private final double eps;
        private final double rightYGradient;
        private final DoubleArray rightYSens;
        private final double coef1;
        private final double coef0;

        Bound(DoubleArray xValues, DoubleArray yValues, BoundCurveInterpolator interpolator) {
            this.nodeCount = xValues.size();
            this.lastXValue = xValues.get(this.nodeCount - 1);
            this.lastYValue = yValues.get(this.nodeCount - 1);
            this.lastDf = Math.exp(-this.lastXValue * this.lastYValue);
            this.eps = 1.0E-8 * (this.lastXValue - xValues.get(0));
            this.rightYGradient = (this.lastYValue - interpolator.interpolate(this.lastXValue - this.eps)) / this.eps;
            this.rightYSens = interpolator.parameterSensitivity(this.lastXValue - this.eps).multipliedBy(-1.0);
            this.coef1 = -this.lastYValue * this.lastDf - this.lastXValue * this.lastDf * this.rightYGradient;
            this.coef0 = this.lastDf - this.coef1 * this.lastXValue;
        }

        @Override
        public double leftExtrapolate(double xValue) {
            throw new IllegalArgumentException("DiscountFactorLinearRightZeroRateCurveExtrapolator cannot be used for left extrapolation");
        }

        @Override
        public double leftExtrapolateFirstDerivative(double xValue) {
            throw new IllegalArgumentException("DiscountFactorLinearRightZeroRateCurveExtrapolator cannot be used for left extrapolation");
        }

        @Override
        public DoubleArray leftExtrapolateParameterSensitivity(double xValue) {
            throw new IllegalArgumentException("DiscountFactorLinearRightZeroRateCurveExtrapolator cannot be used for left extrapolation");
        }

        @Override
        public double rightExtrapolate(double xValue) {
            if (this.lastXValue <= 0.0) {
                throw new IllegalArgumentException("X value of the right endpoint must be positive");
            }
            return -Math.log(this.coef1 * xValue + this.coef0) / xValue;
        }

        @Override
        public double rightExtrapolateFirstDerivative(double xValue) {
            if (this.lastXValue <= 0.0) {
                throw new IllegalArgumentException("X value of the right endpoint must be positive");
            }
            double df = this.coef1 * xValue + this.coef0;
            double value = -Math.log(df) / xValue;
            return -(value + this.coef1 / df) / xValue;
        }

        @Override
        public DoubleArray rightExtrapolateParameterSensitivity(double xValue) {
            if (this.lastXValue <= 0.0) {
                throw new IllegalArgumentException("X value of the right endpoint must be positive");
            }
            double df = this.coef1 * xValue + this.coef0;
            double[] result = this.rightYSens.toArray();
            double factor = xValue - this.lastXValue;
            int minusOne = this.nodeCount - 1;
            int i = 0;
            while (i < minusOne) {
                int n = i++;
                result[n] = result[n] * (factor / this.eps);
            }
            result[minusOne] = (1.0 + result[minusOne]) * factor / this.eps;
            int n = minusOne;
            result[n] = result[n] + ((1.0 / this.lastXValue - this.lastYValue - this.lastXValue * this.rightYGradient) * xValue + this.lastXValue * this.lastYValue + this.lastXValue * this.lastXValue * this.rightYGradient);
            return DoubleArray.ofUnsafe((double[])result).multipliedBy(this.lastXValue * this.lastDf / (xValue * df));
        }
    }
}

