/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.curve.interpolator;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.market.curve.interpolator.BoundCurveExtrapolator;
import com.opengamma.strata.market.curve.interpolator.BoundCurveInterpolator;
import com.opengamma.strata.market.curve.interpolator.CurveExtrapolator;
import java.io.Serializable;

class DiscountFactorQuadraticLeftZeroRateCurveExtrapolator
implements CurveExtrapolator,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String NAME = "DiscountFactorQuadraticLeftZeroRate";
    public static final CurveExtrapolator INSTANCE = new DiscountFactorQuadraticLeftZeroRateCurveExtrapolator();
    private static final double EPS = 1.0E-8;

    private DiscountFactorQuadraticLeftZeroRateCurveExtrapolator() {
    }

    private Object readResolve() {
        return INSTANCE;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public BoundCurveExtrapolator bind(DoubleArray xValues, DoubleArray yValues, BoundCurveInterpolator interpolator) {
        return new Bound(xValues, yValues, interpolator);
    }

    public String toString() {
        return NAME;
    }

    static class Bound
    implements BoundCurveExtrapolator {
        private final int nodeCount;
        private final double firstXValue;
        private final double firstYValue;
        private final double firstYGradient;
        private final double firstDfValue;
        private final double eps;
        private final double leftQuadCoef;
        private final double leftLinCoef;
        private final Supplier<DoubleArray> leftSens;

        Bound(DoubleArray xValues, DoubleArray yValues, BoundCurveInterpolator interpolator) {
            this.nodeCount = xValues.size();
            this.firstXValue = xValues.get(0);
            this.firstYValue = yValues.get(0);
            this.firstDfValue = Math.exp(-this.firstXValue * this.firstYValue);
            this.firstYGradient = interpolator.firstDerivative(this.firstXValue);
            double gradient = -this.firstYValue * this.firstDfValue - this.firstXValue * this.firstDfValue * this.firstYGradient;
            this.eps = 1.0E-8 * (xValues.get(this.nodeCount - 1) - this.firstXValue);
            this.leftQuadCoef = gradient / this.firstXValue - (this.firstDfValue - 1.0) / this.firstXValue / this.firstXValue;
            this.leftLinCoef = -gradient + 2.0 * (this.firstDfValue - 1.0) / this.firstXValue;
            this.leftSens = Suppliers.memoize(() -> interpolator.parameterSensitivity(this.firstXValue + this.eps));
        }

        @Override
        public double leftExtrapolate(double xValue) {
            if (this.firstXValue == 0.0) {
                throw new IllegalArgumentException("The trivial point at x = 0 is already included");
            }
            if (Math.abs(xValue) < this.eps) {
                return -this.leftLinCoef - (this.leftQuadCoef - 0.5 * this.leftLinCoef * this.leftLinCoef) * xValue - xValue * xValue * (this.leftLinCoef * this.leftLinCoef * this.leftLinCoef / 3.0 - this.leftQuadCoef * this.leftLinCoef);
            }
            double df = this.leftQuadCoef * xValue * xValue + this.leftLinCoef * xValue + 1.0;
            return -Math.log(df) / xValue;
        }

        @Override
        public double leftExtrapolateFirstDerivative(double xValue) {
            if (this.firstXValue == 0.0) {
                throw new IllegalArgumentException("The trivial point at x = 0 is already included");
            }
            if (Math.abs(xValue) < this.eps) {
                return -this.leftQuadCoef + 0.5 * this.leftLinCoef * this.leftLinCoef - xValue * (2.0 * this.leftLinCoef * this.leftLinCoef * this.leftLinCoef / 3.0 - 2.0 * this.leftQuadCoef * this.leftLinCoef);
            }
            double gradDf = 2.0 * this.leftQuadCoef * xValue + this.leftLinCoef;
            double df = this.leftQuadCoef * xValue * xValue + this.leftLinCoef * xValue + 1.0;
            return Math.log(df) / Math.pow(xValue, 2.0) - gradDf / (df * xValue);
        }

        @Override
        public DoubleArray leftExtrapolateParameterSensitivity(double xValue) {
            if (this.firstXValue == 0.0) {
                throw new IllegalArgumentException("The trivial point at x = 0 is already included");
            }
            double[] sensiZero = ((DoubleArray)this.leftSens.get()).toArray();
            double xQuad = xValue * xValue;
            if (Math.abs(xValue) < this.eps) {
                double coef1 = -(this.leftLinCoef * this.leftLinCoef - this.leftQuadCoef) * xQuad + this.leftLinCoef * xValue - 1.0;
                double coef2 = -xValue + this.leftLinCoef * xQuad;
                double factor = this.firstDfValue * (this.firstXValue * coef1 - coef2);
                int i = 1;
                while (i < this.nodeCount) {
                    int n = i++;
                    sensiZero[n] = sensiZero[n] * (factor / this.eps);
                }
                sensiZero[0] = (sensiZero[0] - 1.0) * factor / this.eps;
                sensiZero[0] = sensiZero[0] + (-this.firstDfValue * coef1 * (1.0 + this.firstXValue * this.firstYValue + this.firstXValue * this.firstXValue * this.firstYGradient) + this.firstDfValue * (this.firstYValue + this.firstXValue * this.firstYGradient) * coef2);
                return DoubleArray.ofUnsafe((double[])sensiZero);
            }
            double df = this.leftQuadCoef * xQuad + this.leftLinCoef * xValue + 1.0;
            double factor = xQuad / this.firstXValue - xValue;
            int i = 1;
            while (i < this.nodeCount) {
                int n = i++;
                sensiZero[n] = sensiZero[n] * (factor / this.eps);
            }
            sensiZero[0] = (sensiZero[0] - 1.0) * factor / this.eps;
            sensiZero[0] = sensiZero[0] + (xValue / this.firstXValue - (xQuad / this.firstXValue - xValue) * (this.firstYValue + this.firstXValue * this.firstYGradient));
            return DoubleArray.ofUnsafe((double[])sensiZero).multipliedBy(this.firstXValue * this.firstDfValue / (xValue * df));
        }

        @Override
        public double rightExtrapolate(double xValue) {
            throw new IllegalArgumentException("QuadraticLeftZeroRateCurveExtrapolator cannot be used for right extrapolation");
        }

        @Override
        public double rightExtrapolateFirstDerivative(double xValue) {
            throw new IllegalArgumentException("QuadraticLeftZeroRateCurveExtrapolator cannot be used for right extrapolation");
        }

        @Override
        public DoubleArray rightExtrapolateParameterSensitivity(double xValue) {
            throw new IllegalArgumentException("QuadraticLeftZeroRateCurveExtrapolator cannot be used for right extrapolation");
        }
    }
}

