/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.curve.interpolator;

import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.market.curve.interpolator.BoundCurveExtrapolator;
import com.opengamma.strata.market.curve.interpolator.BoundCurveInterpolator;
import com.opengamma.strata.market.curve.interpolator.CurveExtrapolator;
import java.io.Serializable;

final class ExponentialCurveExtrapolator
implements CurveExtrapolator,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String NAME = "Exponential";
    public static final CurveExtrapolator INSTANCE = new ExponentialCurveExtrapolator();

    private ExponentialCurveExtrapolator() {
    }

    private Object readResolve() {
        return INSTANCE;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public BoundCurveExtrapolator bind(DoubleArray xValues, DoubleArray yValues, BoundCurveInterpolator interpolator) {
        return new Bound(xValues, yValues, interpolator);
    }

    public String toString() {
        return NAME;
    }

    static class Bound
    implements BoundCurveExtrapolator {
        private final int nodeCount;
        private final double firstXValue;
        private final double firstYValue;
        private final double lastXValue;
        private final double lastYValue;
        private final double leftGradient;
        private final double rightGradient;

        Bound(DoubleArray xValues, DoubleArray yValues, BoundCurveInterpolator interpolator) {
            this.nodeCount = xValues.size();
            this.firstXValue = xValues.get(0);
            this.firstYValue = yValues.get(0);
            this.lastXValue = xValues.get(this.nodeCount - 1);
            this.lastYValue = yValues.get(this.nodeCount - 1);
            this.leftGradient = Math.log(this.firstYValue) / this.firstXValue;
            this.rightGradient = Math.log(this.lastYValue) / this.lastXValue;
        }

        @Override
        public double leftExtrapolate(double xValue) {
            return Math.exp(this.leftGradient * xValue);
        }

        @Override
        public double leftExtrapolateFirstDerivative(double xValue) {
            return this.leftGradient * Math.exp(this.leftGradient * xValue);
        }

        @Override
        public DoubleArray leftExtrapolateParameterSensitivity(double xValue) {
            double ex = Math.exp(this.leftGradient * xValue);
            double[] result = new double[this.nodeCount];
            result[0] = ex * xValue / (this.firstXValue * this.firstYValue);
            return DoubleArray.ofUnsafe((double[])result);
        }

        @Override
        public double rightExtrapolate(double xValue) {
            return Math.exp(this.rightGradient * xValue);
        }

        @Override
        public double rightExtrapolateFirstDerivative(double xValue) {
            return this.rightGradient * Math.exp(this.rightGradient * xValue);
        }

        @Override
        public DoubleArray rightExtrapolateParameterSensitivity(double xValue) {
            double ex = Math.exp(this.rightGradient * xValue);
            double[] result = new double[this.nodeCount];
            result[this.nodeCount - 1] = ex * xValue / (this.lastXValue * this.lastYValue);
            return DoubleArray.ofUnsafe((double[])result);
        }
    }
}

