/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.curve.interpolator;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.market.curve.interpolator.AbstractBoundCurveInterpolator;
import com.opengamma.strata.market.curve.interpolator.BoundCurveExtrapolator;
import com.opengamma.strata.market.curve.interpolator.BoundCurveInterpolator;
import com.opengamma.strata.market.curve.interpolator.CurveExtrapolator;
import java.io.Serializable;

final class InterpolatorCurveExtrapolator
implements CurveExtrapolator,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String NAME = "Interpolator";
    public static final CurveExtrapolator INSTANCE = new InterpolatorCurveExtrapolator();

    private InterpolatorCurveExtrapolator() {
    }

    private Object readResolve() {
        return INSTANCE;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public BoundCurveExtrapolator bind(DoubleArray xValues, DoubleArray yValues, BoundCurveInterpolator interpolator) {
        return new Bound(xValues, yValues, interpolator);
    }

    public String toString() {
        return NAME;
    }

    static class Bound
    implements BoundCurveExtrapolator {
        private final AbstractBoundCurveInterpolator interpolator;

        Bound(DoubleArray xValues, DoubleArray yValues, BoundCurveInterpolator interpolator) {
            ArgChecker.isTrue((boolean)(interpolator instanceof AbstractBoundCurveInterpolator));
            this.interpolator = (AbstractBoundCurveInterpolator)interpolator;
        }

        @Override
        public double leftExtrapolate(double xValue) {
            return this.interpolator.doInterpolateFromExtrapolator(xValue);
        }

        @Override
        public double leftExtrapolateFirstDerivative(double xValue) {
            return this.interpolator.doFirstDerivative(xValue);
        }

        @Override
        public DoubleArray leftExtrapolateParameterSensitivity(double xValue) {
            return this.interpolator.doParameterSensitivity(xValue);
        }

        @Override
        public double rightExtrapolate(double xValue) {
            return this.interpolator.doInterpolateFromExtrapolator(xValue);
        }

        @Override
        public double rightExtrapolateFirstDerivative(double xValue) {
            return this.interpolator.doFirstDerivative(xValue);
        }

        @Override
        public DoubleArray rightExtrapolateParameterSensitivity(double xValue) {
            return this.interpolator.doParameterSensitivity(xValue);
        }
    }
}

