/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.curve.interpolator;

import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.market.curve.interpolator.BoundCurveExtrapolator;
import com.opengamma.strata.market.curve.interpolator.BoundCurveInterpolator;
import com.opengamma.strata.market.curve.interpolator.CurveExtrapolator;
import java.io.Serializable;

final class LinearCurveExtrapolator
implements CurveExtrapolator,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String NAME = "Linear";
    public static final CurveExtrapolator INSTANCE = new LinearCurveExtrapolator();
    private static final double EPS = 1.0E-8;

    private LinearCurveExtrapolator() {
    }

    private Object readResolve() {
        return INSTANCE;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public BoundCurveExtrapolator bind(DoubleArray xValues, DoubleArray yValues, BoundCurveInterpolator interpolator) {
        return new Bound(xValues, yValues, interpolator);
    }

    public String toString() {
        return NAME;
    }

    static class Bound
    implements BoundCurveExtrapolator {
        private final int nodeCount;
        private final double firstXValue;
        private final double firstYValue;
        private final double lastXValue;
        private final double lastYValue;
        private final double eps;
        private final double leftGradient;
        private final DoubleArray leftSens;
        private final double rightGradient;
        private final DoubleArray rightSens;

        Bound(DoubleArray xValues, DoubleArray yValues, BoundCurveInterpolator interpolator) {
            this.nodeCount = xValues.size();
            this.firstXValue = xValues.get(0);
            this.firstYValue = yValues.get(0);
            this.lastXValue = xValues.get(this.nodeCount - 1);
            this.lastYValue = yValues.get(this.nodeCount - 1);
            this.eps = 1.0E-8 * (this.lastXValue - this.firstXValue);
            this.leftGradient = (interpolator.interpolate(this.firstXValue + this.eps) - this.firstYValue) / this.eps;
            this.leftSens = interpolator.parameterSensitivity(this.firstXValue + this.eps);
            this.rightGradient = (this.lastYValue - interpolator.interpolate(this.lastXValue - this.eps)) / this.eps;
            this.rightSens = interpolator.parameterSensitivity(this.lastXValue - this.eps);
        }

        @Override
        public double leftExtrapolate(double xValue) {
            return this.firstYValue + (xValue - this.firstXValue) * this.leftGradient;
        }

        @Override
        public double leftExtrapolateFirstDerivative(double xValue) {
            return this.leftGradient;
        }

        @Override
        public DoubleArray leftExtrapolateParameterSensitivity(double xValue) {
            double[] result = this.leftSens.toArray();
            int n = result.length;
            for (int i = 1; i < n; ++i) {
                result[i] = result[i] * (xValue - this.firstXValue) / this.eps;
            }
            result[0] = 1.0 + (result[0] - 1.0) * (xValue - this.firstXValue) / this.eps;
            return DoubleArray.ofUnsafe((double[])result);
        }

        @Override
        public double rightExtrapolate(double xValue) {
            return this.lastYValue + (xValue - this.lastXValue) * this.rightGradient;
        }

        @Override
        public double rightExtrapolateFirstDerivative(double xValue) {
            return this.rightGradient;
        }

        @Override
        public DoubleArray rightExtrapolateParameterSensitivity(double xValue) {
            double[] result = this.rightSens.toArray();
            int n = result.length;
            for (int i = 0; i < n - 1; ++i) {
                result[i] = -result[i] * (xValue - this.lastXValue) / this.eps;
            }
            result[n - 1] = 1.0 + (1.0 - result[n - 1]) * (xValue - this.lastXValue) / this.eps;
            return DoubleArray.ofUnsafe((double[])result);
        }
    }
}

