/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.curve.interpolator;

import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.market.curve.interpolator.AbstractBoundCurveInterpolator;
import com.opengamma.strata.market.curve.interpolator.BoundCurveExtrapolator;
import com.opengamma.strata.market.curve.interpolator.BoundCurveInterpolator;
import com.opengamma.strata.market.curve.interpolator.CurveInterpolator;
import java.io.Serializable;

final class LogLinearCurveInterpolator
implements CurveInterpolator,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String NAME = "LogLinear";
    public static final CurveInterpolator INSTANCE = new LogLinearCurveInterpolator();

    private LogLinearCurveInterpolator() {
    }

    private Object readResolve() {
        return INSTANCE;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public BoundCurveInterpolator bind(DoubleArray xValues, DoubleArray yValues) {
        return new Bound(xValues, yValues);
    }

    public String toString() {
        return NAME;
    }

    static class Bound
    extends AbstractBoundCurveInterpolator {
        private final double[] xValues;
        private final double[] yValues;
        private final int intervalCount;

        Bound(DoubleArray xValues, DoubleArray yValues) {
            super(xValues, yValues);
            this.xValues = xValues.toArrayUnsafe();
            this.yValues = yValues.toArrayUnsafe();
            this.intervalCount = xValues.size() - 1;
        }

        Bound(Bound base, BoundCurveExtrapolator extrapolatorLeft, BoundCurveExtrapolator extrapolatorRight) {
            super(base, extrapolatorLeft, extrapolatorRight);
            this.xValues = base.xValues;
            this.yValues = base.yValues;
            this.intervalCount = base.intervalCount;
        }

        @Override
        protected double doInterpolate(double xValue) {
            int lowerIndex = Bound.lowerBoundIndex(xValue, this.xValues);
            double x1 = this.xValues[lowerIndex];
            double x2 = this.xValues[lowerIndex + 1];
            double y1 = this.yValues[lowerIndex];
            double y2 = this.yValues[lowerIndex + 1];
            return Math.pow(y2 / y1, (xValue - x1) / (x2 - x1)) * y1;
        }

        @Override
        protected double doInterpolateFromExtrapolator(double xValue) {
            int lowerIndex = Bound.lowerBoundIndex(xValue, this.xValues);
            if (lowerIndex == this.intervalCount) {
                --lowerIndex;
            }
            double x1 = this.xValues[lowerIndex];
            double x2 = this.xValues[lowerIndex + 1];
            double y1 = this.yValues[lowerIndex];
            double y2 = this.yValues[lowerIndex + 1];
            return Math.pow(y2 / y1, (xValue - x1) / (x2 - x1)) * y1;
        }

        @Override
        protected double doFirstDerivative(double xValue) {
            int lowerIndex = Bound.lowerBoundIndex(xValue, this.xValues);
            if (lowerIndex == this.intervalCount) {
                double x1 = this.xValues[lowerIndex - 1];
                double x2 = this.xValues[lowerIndex];
                double y1 = this.yValues[lowerIndex - 1];
                double y2 = this.yValues[lowerIndex];
                return y2 * Math.log(y2 / y1) / (x2 - x1);
            }
            double x1 = this.xValues[lowerIndex];
            double x2 = this.xValues[lowerIndex + 1];
            double y1 = this.yValues[lowerIndex];
            double y2 = this.yValues[lowerIndex + 1];
            double yDiv = y2 / y1;
            double xDiff = x2 - x1;
            return Math.pow(yDiv, (xValue - x1) / xDiff) * y1 * Math.log(yDiv) / xDiff;
        }

        @Override
        protected DoubleArray doParameterSensitivity(double xValue) {
            double[] result = new double[this.yValues.length];
            int lowerIndex = Bound.lowerBoundIndex(xValue, this.xValues);
            if (lowerIndex == this.intervalCount) {
                result[this.intervalCount] = 1.0;
            } else {
                double x1 = this.xValues[lowerIndex];
                double x2 = this.xValues[lowerIndex + 1];
                double y1 = this.yValues[lowerIndex];
                double y2 = this.yValues[lowerIndex + 1];
                double diffInv = 1.0 / (x2 - x1);
                double x1diffInv = (xValue - x1) * diffInv;
                double x2diffInv = (x2 - xValue) * diffInv;
                double yDiv = y1 / y2;
                result[lowerIndex] = Math.pow(yDiv, -x1diffInv) * x2diffInv;
                result[lowerIndex + 1] = Math.pow(yDiv, x2diffInv) * x1diffInv;
            }
            return DoubleArray.ofUnsafe((double[])result);
        }

        @Override
        public BoundCurveInterpolator bind(BoundCurveExtrapolator extrapolatorLeft, BoundCurveExtrapolator extrapolatorRight) {
            return new Bound(this, extrapolatorLeft, extrapolatorRight);
        }
    }
}

