/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.curve.interpolator;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.opengamma.strata.basics.value.ValueDerivatives;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.market.curve.interpolator.AbstractBoundCurveInterpolator;
import com.opengamma.strata.market.curve.interpolator.BoundCurveExtrapolator;
import com.opengamma.strata.market.curve.interpolator.BoundCurveInterpolator;
import com.opengamma.strata.market.curve.interpolator.CurveInterpolator;
import com.opengamma.strata.math.impl.function.PiecewisePolynomialWithSensitivityFunction1D;
import com.opengamma.strata.math.impl.interpolation.ClampedPiecewisePolynomialInterpolator;
import com.opengamma.strata.math.impl.interpolation.NaturalSplineInterpolator;
import com.opengamma.strata.math.impl.interpolation.PiecewisePolynomialInterpolator;
import com.opengamma.strata.math.impl.interpolation.PiecewisePolynomialResult;
import com.opengamma.strata.math.impl.interpolation.PiecewisePolynomialResultsWithSensitivity;
import java.io.Serializable;

final class LogNaturalSplineDiscountFactorCurveInterpolator
implements CurveInterpolator,
Serializable {
    public static final String NAME = "LogNaturalSplineDiscountFactor";
    public static final CurveInterpolator INSTANCE = new LogNaturalSplineDiscountFactorCurveInterpolator();
    private static final long serialVersionUID = 1L;
    private static final PiecewisePolynomialWithSensitivityFunction1D FUNCTION = new PiecewisePolynomialWithSensitivityFunction1D();

    private LogNaturalSplineDiscountFactorCurveInterpolator() {
    }

    private Object readResolve() {
        return INSTANCE;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public BoundCurveInterpolator bind(DoubleArray xValues, DoubleArray yValues) {
        return new Bound(xValues, yValues);
    }

    public String toString() {
        return NAME;
    }

    static class Bound
    extends AbstractBoundCurveInterpolator {
        private final double[] xValues;
        private final double[] yValues;
        private final PiecewisePolynomialResult poly;
        private final Supplier<PiecewisePolynomialResultsWithSensitivity> polySens;
        private double[] logYValues;

        Bound(DoubleArray xValues, DoubleArray yValues) {
            super(xValues, yValues);
            this.xValues = xValues.toArrayUnsafe();
            this.yValues = yValues.toArrayUnsafe();
            this.logYValues = Bound.getYLogValues(this.yValues);
            ClampedPiecewisePolynomialInterpolator underlying = new ClampedPiecewisePolynomialInterpolator((PiecewisePolynomialInterpolator)new NaturalSplineInterpolator(), new double[]{0.0}, new double[]{0.0});
            this.poly = underlying.interpolate(xValues.toArray(), this.logYValues);
            this.polySens = Suppliers.memoize(() -> underlying.interpolateWithSensitivity(xValues.toArray(), this.logYValues));
        }

        Bound(Bound base, BoundCurveExtrapolator extrapolatorLeft, BoundCurveExtrapolator extrapolatorRight) {
            super(base, extrapolatorLeft, extrapolatorRight);
            this.xValues = base.xValues;
            this.yValues = base.yValues;
            this.logYValues = base.logYValues;
            this.poly = base.poly;
            this.polySens = base.polySens;
        }

        private static double[] getYLogValues(double[] yValues) {
            int nData = yValues.length;
            double[] logYValues = new double[nData];
            for (int i = 0; i < nData; ++i) {
                logYValues[i] = Math.log(yValues[i]);
            }
            return logYValues;
        }

        @Override
        protected double doInterpolate(double xValue) {
            double resValue = FUNCTION.evaluate(this.poly, xValue).get(0);
            return Math.exp(resValue);
        }

        @Override
        protected double doFirstDerivative(double xValue) {
            ValueDerivatives resValue = FUNCTION.evaluateAndDifferentiate(this.poly, xValue);
            return Math.exp(resValue.getValue()) * resValue.getDerivative(0);
        }

        @Override
        protected DoubleArray doParameterSensitivity(double xValue) {
            int nParams = this.yValues.length;
            double resValue = FUNCTION.evaluate(this.poly, xValue).get(0);
            DoubleArray resSense = FUNCTION.nodeSensitivity((PiecewisePolynomialResultsWithSensitivity)this.polySens.get(), xValue);
            double expResValue = Math.exp(resValue);
            double[] res = new double[nParams];
            for (int i = 0; i < nParams; ++i) {
                res[i] = resSense.get(i + 1) * expResValue / this.yValues[i];
            }
            return DoubleArray.ofUnsafe((double[])res);
        }

        @Override
        public BoundCurveInterpolator bind(BoundCurveExtrapolator extrapolatorLeft, BoundCurveExtrapolator extrapolatorRight) {
            return new Bound(this, extrapolatorLeft, extrapolatorRight);
        }
    }
}

