/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.curve.interpolator;

import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.collect.array.DoubleMatrix;
import com.opengamma.strata.collect.array.Matrix;
import com.opengamma.strata.market.curve.interpolator.AbstractBoundCurveInterpolator;
import com.opengamma.strata.market.curve.interpolator.BoundCurveExtrapolator;
import com.opengamma.strata.market.curve.interpolator.BoundCurveInterpolator;
import com.opengamma.strata.market.curve.interpolator.CurveInterpolator;
import com.opengamma.strata.math.MathException;
import com.opengamma.strata.math.impl.linearalgebra.InverseTridiagonalMatrixCalculator;
import com.opengamma.strata.math.impl.linearalgebra.TridiagonalMatrix;
import com.opengamma.strata.math.impl.matrix.MatrixAlgebraFactory;
import java.io.Serializable;

final class NaturalCubicSplineCurveInterpolator
implements CurveInterpolator,
Serializable {
    public static final String NAME = "NaturalCubicSpline";
    public static final CurveInterpolator INSTANCE = new NaturalCubicSplineCurveInterpolator();
    private static final long serialVersionUID = 1L;
    private static final double EPS = 1.0E-12;

    private NaturalCubicSplineCurveInterpolator() {
    }

    private Object readResolve() {
        return INSTANCE;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public BoundCurveInterpolator bind(DoubleArray xValues, DoubleArray yValues) {
        return new Bound(xValues, yValues);
    }

    public String toString() {
        return NAME;
    }

    static class Bound
    extends AbstractBoundCurveInterpolator {
        private final double[] xValues;
        private final double[] yValues;
        private final int dataSize;
        private final double leftFirstDev;
        private final double rightFirstDev;
        private final boolean leftNatural;
        private final boolean rightNatural;

        Bound(DoubleArray xValues, DoubleArray yValues) {
            super(xValues, yValues);
            this.xValues = xValues.toArrayUnsafe();
            this.yValues = yValues.toArrayUnsafe();
            this.dataSize = xValues.size();
            this.leftFirstDev = 0.0;
            this.rightFirstDev = 0.0;
            this.leftNatural = true;
            this.rightNatural = true;
        }

        Bound(Bound base, BoundCurveExtrapolator extrapolatorLeft, BoundCurveExtrapolator extrapolatorRight) {
            super(base, extrapolatorLeft, extrapolatorRight);
            this.xValues = base.xValues;
            this.yValues = base.yValues;
            this.leftFirstDev = base.leftFirstDev;
            this.rightFirstDev = base.rightFirstDev;
            this.leftNatural = base.leftNatural;
            this.rightNatural = base.rightNatural;
            this.dataSize = this.xValues.length;
        }

        private static double[] calculateSecondDerivative(double[] xValues, double[] yValues, int dataSize, double leftFirstDev, double rightFirstDev, boolean leftNatural, boolean rightNatural) {
            double[] deltaX = new double[dataSize - 1];
            double[] deltaYOverDeltaX = new double[dataSize - 1];
            double[] oneOverDeltaX = new double[dataSize - 1];
            for (int i = 0; i < dataSize - 1; ++i) {
                deltaX[i] = xValues[i + 1] - xValues[i];
                oneOverDeltaX[i] = 1.0 / deltaX[i];
                deltaYOverDeltaX[i] = (yValues[i + 1] - yValues[i]) * oneOverDeltaX[i];
            }
            DoubleMatrix inverseTriDiag = Bound.getInverseTridiagonalMatrix(deltaX, leftNatural, rightNatural);
            DoubleArray rhsVector = Bound.getRightVector(deltaYOverDeltaX, leftFirstDev, rightFirstDev, leftNatural, rightNatural);
            return ((DoubleArray)MatrixAlgebraFactory.OG_ALGEBRA.multiply((Matrix)inverseTriDiag, (Matrix)rhsVector)).toArrayUnsafe();
        }

        private static double[][] getSecondDerivativesSensitivities(double[] xValues, double[] yValues, int dataSize, boolean leftNatural, boolean rightNatural) {
            double[] deltaX = new double[dataSize - 1];
            double[] oneOverDeltaX = new double[dataSize - 1];
            for (int i = 0; i < dataSize - 1; ++i) {
                deltaX[i] = xValues[i + 1] - xValues[i];
                oneOverDeltaX[i] = 1.0 / deltaX[i];
            }
            DoubleMatrix inverseTriDiag = Bound.getInverseTridiagonalMatrix(deltaX, leftNatural, rightNatural);
            DoubleMatrix rhsMatrix = Bound.getRightMatrix(oneOverDeltaX, leftNatural, rightNatural);
            return ((DoubleMatrix)MatrixAlgebraFactory.OG_ALGEBRA.multiply((Matrix)inverseTriDiag, (Matrix)rhsMatrix)).toArrayUnsafe();
        }

        private static DoubleMatrix getInverseTridiagonalMatrix(double[] deltaX, boolean leftNatural, boolean rightNatural) {
            InverseTridiagonalMatrixCalculator invertor = new InverseTridiagonalMatrixCalculator();
            int n = deltaX.length + 1;
            double[] a = new double[n];
            double[] b = new double[n - 1];
            double[] c = new double[n - 1];
            for (int i = 1; i < n - 1; ++i) {
                a[i] = (deltaX[i - 1] + deltaX[i]) / 3.0;
                b[i] = deltaX[i] / 6.0;
                c[i - 1] = deltaX[i - 1] / 6.0;
            }
            if (leftNatural) {
                a[0] = 1.0;
                b[0] = 0.0;
            } else {
                a[0] = -deltaX[0] / 3.0;
                b[0] = deltaX[0] / 6.0;
            }
            if (rightNatural) {
                a[n - 1] = 1.0;
                c[n - 2] = 0.0;
            } else {
                a[n - 1] = deltaX[n - 2] / 3.0;
                c[n - 2] = deltaX[n - 2] / 6.0;
            }
            TridiagonalMatrix tridiagonal = new TridiagonalMatrix(a, b, c);
            return invertor.apply(tridiagonal);
        }

        private static DoubleArray getRightVector(double[] deltaYOverDeltaX, double leftFirstDev, double rightFirstDev, boolean leftNatural, boolean rightNatural) {
            int n = deltaYOverDeltaX.length + 1;
            double[] res = new double[n];
            for (int i = 1; i < n - 1; ++i) {
                res[i] = deltaYOverDeltaX[i] - deltaYOverDeltaX[i - 1];
            }
            if (!leftNatural) {
                res[0] = leftFirstDev - deltaYOverDeltaX[0];
            }
            if (!rightNatural) {
                res[n - 1] = rightFirstDev - deltaYOverDeltaX[n - 2];
            }
            return DoubleArray.ofUnsafe((double[])res);
        }

        private static DoubleMatrix getRightMatrix(double[] oneOverDeltaX, boolean leftNatural, boolean rightNatural) {
            int n = oneOverDeltaX.length + 1;
            double[][] res = new double[n][n];
            for (int i = 1; i < n - 1; ++i) {
                res[i][i - 1] = oneOverDeltaX[i - 1];
                res[i][i] = -oneOverDeltaX[i] - oneOverDeltaX[i - 1];
                res[i][i + 1] = oneOverDeltaX[i];
            }
            if (!leftNatural) {
                res[0][0] = oneOverDeltaX[0];
                res[0][1] = -oneOverDeltaX[0];
            }
            if (!rightNatural) {
                res[n - 1][n - 1] = -oneOverDeltaX[n - 2];
                res[n - 2][n - 2] = oneOverDeltaX[n - 2];
            }
            return DoubleMatrix.ofUnsafe((double[][])res);
        }

        @Override
        protected double doInterpolate(double xValue) {
            int low = Bound.lowerBoundIndex(xValue, this.xValues);
            int high = low + 1;
            int n = this.dataSize - 1;
            if (low == n) {
                return this.yValues[n];
            }
            double delta = this.xValues[high] - this.xValues[low];
            if (Math.abs(delta) < 1.0E-12) {
                throw new MathException("x data points were not distinct");
            }
            double a = (this.xValues[high] - xValue) / delta;
            double b = (xValue - this.xValues[low]) / delta;
            double[] y2 = Bound.calculateSecondDerivative(this.xValues, this.yValues, this.dataSize, this.leftFirstDev, this.rightFirstDev, this.leftNatural, this.rightNatural);
            return a * this.yValues[low] + b * this.yValues[high] + (a * (a * a - 1.0) * y2[low] + b * (b * b - 1.0) * y2[high]) * delta * delta / 6.0;
        }

        @Override
        protected double doFirstDerivative(double xValue) {
            double delta;
            int low = Bound.lowerBoundIndex(xValue, this.xValues);
            int high = low + 1;
            int n = this.dataSize - 1;
            if (low == n) {
                low = n - 1;
                high = n;
            }
            if (Math.abs(delta = this.xValues[high] - this.xValues[low]) < 1.0E-12) {
                throw new MathException("x data points were not distinct");
            }
            double a = (this.xValues[high] - xValue) / delta;
            double b = (xValue - this.xValues[low]) / delta;
            double[] y2 = Bound.calculateSecondDerivative(this.xValues, this.yValues, this.dataSize, this.leftFirstDev, this.rightFirstDev, this.leftNatural, this.rightNatural);
            return (this.yValues[high] - this.yValues[low]) / delta + ((-3.0 * a * a + 1.0) * y2[low] + (3.0 * b * b - 1.0) * y2[high]) * delta / 6.0;
        }

        @Override
        protected DoubleArray doParameterSensitivity(double xValue) {
            int low = Bound.lowerBoundIndex(xValue, this.xValues);
            double[] result = new double[this.dataSize];
            if (low == this.dataSize - 1) {
                result[this.dataSize - 1] = 1.0;
                return DoubleArray.ofUnsafe((double[])result);
            }
            int high = low + 1;
            double delta = this.xValues[high] - this.xValues[low];
            double a = (this.xValues[high] - xValue) / delta;
            double b = (xValue - this.xValues[low]) / delta;
            double c = a * (a * a - 1.0) * delta * delta / 6.0;
            double d = b * (b * b - 1.0) * delta * delta / 6.0;
            double[][] y2Sensitivities = Bound.getSecondDerivativesSensitivities(this.xValues, this.yValues, this.dataSize, this.leftNatural, this.rightNatural);
            for (int i = 0; i < this.dataSize; ++i) {
                result[i] = c * y2Sensitivities[low][i] + d * y2Sensitivities[high][i];
            }
            int n = low;
            result[n] = result[n] + a;
            int n2 = high;
            result[n2] = result[n2] + b;
            return DoubleArray.ofUnsafe((double[])result);
        }

        @Override
        public BoundCurveInterpolator bind(BoundCurveExtrapolator extrapolatorLeft, BoundCurveExtrapolator extrapolatorRight) {
            return new Bound(this, extrapolatorLeft, extrapolatorRight);
        }
    }
}

