/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.curve.interpolator;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.collect.array.DoubleMatrix;
import com.opengamma.strata.collect.array.Matrix;
import com.opengamma.strata.market.curve.interpolator.AbstractBoundCurveInterpolator;
import com.opengamma.strata.market.curve.interpolator.BoundCurveExtrapolator;
import com.opengamma.strata.market.curve.interpolator.BoundCurveInterpolator;
import com.opengamma.strata.market.curve.interpolator.CurveInterpolator;
import com.opengamma.strata.math.impl.FunctionUtils;
import com.opengamma.strata.math.impl.interpolation.PiecewiseCubicHermiteSplineInterpolatorWithSensitivity;
import com.opengamma.strata.math.impl.interpolation.PiecewisePolynomialInterpolator;
import com.opengamma.strata.math.impl.interpolation.PiecewisePolynomialResult;
import com.opengamma.strata.math.impl.matrix.MatrixAlgebra;
import com.opengamma.strata.math.impl.matrix.OGMatrixAlgebra;
import java.io.Serializable;

final class PiecewiseCubicHermiteMonotonicityCurveInterpolator
implements CurveInterpolator,
Serializable {
    public static final String NAME = "PiecewiseCubicHermiteMonotonicity";
    public static final PiecewiseCubicHermiteMonotonicityCurveInterpolator INSTANCE = new PiecewiseCubicHermiteMonotonicityCurveInterpolator();
    private static final long serialVersionUID = 1L;
    private static final MatrixAlgebra MA = new OGMatrixAlgebra();

    private PiecewiseCubicHermiteMonotonicityCurveInterpolator() {
    }

    private Object readResolve() {
        return INSTANCE;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public BoundCurveInterpolator bind(DoubleArray xValues, DoubleArray yValues) {
        return new Bound(xValues, yValues);
    }

    public String toString() {
        return NAME;
    }

    static class Bound
    extends AbstractBoundCurveInterpolator {
        private final double[] xValues;
        private final double[] yValues;
        private final DoubleArray knots;
        private final DoubleMatrix coefMatrix;
        private final Supplier<DoubleMatrix[]> coefMatrixSensi;

        Bound(DoubleArray xValues, DoubleArray yValues) {
            super(xValues, yValues);
            this.xValues = xValues.toArrayUnsafe();
            this.yValues = yValues.toArrayUnsafe();
            PiecewiseCubicHermiteSplineInterpolatorWithSensitivity underlying = new PiecewiseCubicHermiteSplineInterpolatorWithSensitivity();
            PiecewisePolynomialResult poly = underlying.interpolate(xValues.toArray(), yValues.toArray());
            this.knots = poly.getKnots();
            this.coefMatrix = poly.getCoefMatrix();
            this.coefMatrixSensi = Suppliers.memoize(() -> Bound.lambda$new$0((PiecewisePolynomialInterpolator)underlying, xValues, yValues));
        }

        Bound(Bound base, BoundCurveExtrapolator extrapolatorLeft, BoundCurveExtrapolator extrapolatorRight) {
            super(base, extrapolatorLeft, extrapolatorRight);
            this.xValues = base.xValues;
            this.yValues = base.yValues;
            this.knots = base.knots;
            this.coefMatrix = base.coefMatrix;
            this.coefMatrixSensi = base.coefMatrixSensi;
        }

        private static double evaluate(double xValue, DoubleArray knots, DoubleMatrix coefMatrix) {
            int indicator = Bound.getIndicator(xValue, knots);
            DoubleArray coefs = coefMatrix.row(indicator);
            return Bound.getValue(coefs.toArrayUnsafe(), xValue, knots.get(indicator));
        }

        private static double differentiate(double xValue, DoubleArray knots, DoubleMatrix coefMatrix) {
            int indicator = Bound.getIndicator(xValue, knots);
            DoubleArray coefs = coefMatrix.row(indicator);
            return Bound.getDerivativeValue(coefs.toArrayUnsafe(), xValue, knots.get(indicator));
        }

        private static int getIndicator(double xValue, DoubleArray knots) {
            int lowerBound = FunctionUtils.getLowerBoundIndex((DoubleArray)knots, (double)xValue);
            return lowerBound == knots.size() - 1 ? lowerBound - 1 : lowerBound;
        }

        private static double getValue(double[] coefs, double x, double leftknot) {
            int nCoefs = coefs.length;
            double s = x - leftknot;
            double res = coefs[0];
            for (int i = 1; i < nCoefs; ++i) {
                res *= s;
                res += coefs[i];
            }
            return res;
        }

        private static double getDerivativeValue(double[] coefs, double x, double leftknot) {
            int nCoefs = coefs.length;
            double s = x - leftknot;
            double res = (double)(nCoefs - 1) * coefs[0];
            for (int i = 1; i < nCoefs - 1; ++i) {
                res *= s;
                res += ((double)(nCoefs - i) - 1.0) * coefs[i];
            }
            return res;
        }

        @Override
        protected double doInterpolate(double xValue) {
            return Bound.evaluate(xValue, this.knots, this.coefMatrix);
        }

        @Override
        protected double doFirstDerivative(double xValue) {
            return Bound.differentiate(xValue, this.knots, this.coefMatrix);
        }

        @Override
        protected DoubleArray doParameterSensitivity(double xValue) {
            int indicator = Bound.getIndicator(xValue, this.knots);
            DoubleMatrix coefficientSensitivity = ((DoubleMatrix[])this.coefMatrixSensi.get())[indicator];
            int nCoefs = coefficientSensitivity.rowCount();
            double s = xValue - this.knots.get(indicator);
            DoubleArray res = coefficientSensitivity.row(0);
            for (int i = 1; i < nCoefs; ++i) {
                res = (DoubleArray)MA.scale((Matrix)res, s);
                res = (DoubleArray)MA.add((Matrix)res, (Matrix)coefficientSensitivity.row(i));
            }
            return res;
        }

        @Override
        public BoundCurveInterpolator bind(BoundCurveExtrapolator extrapolatorLeft, BoundCurveExtrapolator extrapolatorRight) {
            return new Bound(this, extrapolatorLeft, extrapolatorRight);
        }

        private static /* synthetic */ DoubleMatrix[] lambda$new$0(PiecewisePolynomialInterpolator underlying, DoubleArray xValues, DoubleArray yValues) {
            return underlying.interpolateWithSensitivity(xValues.toArray(), yValues.toArray()).getCoefficientSensitivityAll();
        }
    }
}

