/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.curve.interpolator;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.market.curve.interpolator.BoundCurveExtrapolator;
import com.opengamma.strata.market.curve.interpolator.BoundCurveInterpolator;
import com.opengamma.strata.market.curve.interpolator.CurveExtrapolator;
import java.io.Serializable;

final class ProductLinearCurveExtrapolator
implements CurveExtrapolator,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String NAME = "ProductLinear";
    public static final CurveExtrapolator INSTANCE = new ProductLinearCurveExtrapolator();
    private static final double EPS = 1.0E-8;

    private ProductLinearCurveExtrapolator() {
    }

    private Object readResolve() {
        return INSTANCE;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public BoundCurveExtrapolator bind(DoubleArray xValues, DoubleArray yValues, BoundCurveInterpolator interpolator) {
        return new Bound(xValues, yValues, interpolator);
    }

    public String toString() {
        return NAME;
    }

    static class Bound
    implements BoundCurveExtrapolator {
        private final int nodeCount;
        private final double lastXValue;
        private final double lastYValue;
        private final double eps;
        private final double lastGradient;
        private final Supplier<DoubleArray> lastSens;
        private final Supplier<DoubleArray> lastGradSens;
        private final double firstXValue;
        private final double firstYValue;
        private final double firstGradient;
        private final Supplier<DoubleArray> firstSens;
        private final Supplier<DoubleArray> firstGradSens;

        Bound(DoubleArray xValues, DoubleArray yValues, BoundCurveInterpolator interpolator) {
            this.nodeCount = xValues.size();
            this.firstXValue = xValues.get(0);
            this.firstYValue = yValues.get(0);
            this.lastXValue = xValues.get(this.nodeCount - 1);
            this.lastYValue = yValues.get(this.nodeCount - 1);
            this.eps = 1.0E-8 * (this.lastXValue - this.firstXValue);
            this.firstGradient = interpolator.firstDerivative(this.firstXValue);
            this.firstSens = Suppliers.memoize(() -> interpolator.parameterSensitivity(this.firstXValue));
            this.firstGradSens = Suppliers.memoize(() -> interpolator.parameterSensitivity(this.firstXValue + this.eps).minus((DoubleArray)this.firstSens.get()).dividedBy(this.eps));
            this.lastGradient = interpolator.firstDerivative(this.lastXValue);
            this.lastSens = Suppliers.memoize(() -> interpolator.parameterSensitivity(this.lastXValue));
            this.lastGradSens = Suppliers.memoize(() -> ((DoubleArray)this.lastSens.get()).minus(interpolator.parameterSensitivity(this.lastXValue - this.eps)).dividedBy(this.eps));
        }

        @Override
        public double leftExtrapolate(double xValue) {
            ArgChecker.isTrue((this.firstXValue < -1.0E-8 ? 1 : 0) != 0, (String)"the first x value must be negative for left extrapolation");
            return this.firstGradient * this.firstXValue * (1.0 - this.firstXValue / xValue) + this.firstYValue;
        }

        @Override
        public double leftExtrapolateFirstDerivative(double xValue) {
            ArgChecker.isTrue((this.firstXValue < -1.0E-8 ? 1 : 0) != 0, (String)"the first x value must be negative for left extrapolation");
            return this.firstGradient * Math.pow(this.firstXValue / xValue, 2.0);
        }

        @Override
        public DoubleArray leftExtrapolateParameterSensitivity(double xValue) {
            ArgChecker.isTrue((this.firstXValue < -1.0E-8 ? 1 : 0) != 0, (String)"the first x value must be negative for left extrapolation");
            double factor = (1.0 - this.firstXValue / xValue) * this.firstXValue;
            return ((DoubleArray)this.firstGradSens.get()).multipliedBy(factor).plus((DoubleArray)this.firstSens.get());
        }

        @Override
        public double rightExtrapolate(double xValue) {
            ArgChecker.isTrue((this.lastXValue > 1.0E-8 ? 1 : 0) != 0, (String)"the last x value must be positive for right extrapolation");
            return this.lastGradient * this.lastXValue * (1.0 - this.lastXValue / xValue) + this.lastYValue;
        }

        @Override
        public double rightExtrapolateFirstDerivative(double xValue) {
            ArgChecker.isTrue((this.lastXValue > 1.0E-8 ? 1 : 0) != 0, (String)"the last x value must be positive for right extrapolation");
            return this.lastGradient * Math.pow(this.lastXValue / xValue, 2.0);
        }

        @Override
        public DoubleArray rightExtrapolateParameterSensitivity(double xValue) {
            ArgChecker.isTrue((this.lastXValue > 1.0E-8 ? 1 : 0) != 0, (String)"the last x value must be positive for right extrapolation");
            double factor = (1.0 - this.lastXValue / xValue) * this.lastXValue;
            return ((DoubleArray)this.lastGradSens.get()).multipliedBy(factor).plus((DoubleArray)this.lastSens.get());
        }
    }
}

