/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.curve.interpolator;

import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.market.curve.interpolator.AbstractBoundCurveInterpolator;
import com.opengamma.strata.market.curve.interpolator.BoundCurveExtrapolator;
import com.opengamma.strata.market.curve.interpolator.BoundCurveInterpolator;
import com.opengamma.strata.market.curve.interpolator.CurveInterpolator;
import java.io.Serializable;

final class SquareLinearCurveInterpolator
implements CurveInterpolator,
Serializable {
    public static final String NAME = "SquareLinear";
    public static final CurveInterpolator INSTANCE = new SquareLinearCurveInterpolator();
    private static final long serialVersionUID = 1L;
    private static final double EPS = 1.0E-10;

    private SquareLinearCurveInterpolator() {
    }

    private Object readResolve() {
        return INSTANCE;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public BoundCurveInterpolator bind(DoubleArray xValues, DoubleArray yValues) {
        return new Bound(xValues, yValues);
    }

    public String toString() {
        return NAME;
    }

    static class Bound
    extends AbstractBoundCurveInterpolator {
        private final double[] xValues;
        private final double[] yValues;
        private final int dataSize;

        Bound(DoubleArray xValues, DoubleArray yValues) {
            super(xValues, yValues);
            this.xValues = xValues.toArrayUnsafe();
            this.yValues = yValues.toArrayUnsafe();
            this.dataSize = xValues.size();
        }

        Bound(Bound base, BoundCurveExtrapolator extrapolatorLeft, BoundCurveExtrapolator extrapolatorRight) {
            super(base, extrapolatorLeft, extrapolatorRight);
            this.xValues = base.xValues;
            this.yValues = base.yValues;
            this.dataSize = this.xValues.length;
        }

        @Override
        protected double doInterpolate(double xValue) {
            int lowerIndex = Bound.lowerBoundIndex(xValue, this.xValues);
            double x1 = this.xValues[lowerIndex];
            double y1 = this.yValues[lowerIndex];
            int higherIndex = lowerIndex + 1;
            double x2 = this.xValues[higherIndex];
            double y2 = this.yValues[higherIndex];
            double w = (x2 - xValue) / (x2 - x1);
            double y21 = y1 * y1;
            double y22 = y2 * y2;
            double ySq = w * y21 + (1.0 - w) * y22;
            return Math.sqrt(ySq);
        }

        @Override
        protected double doInterpolateFromExtrapolator(double xValue) {
            int lowerIndex = Bound.lowerBoundIndex(xValue, this.xValues);
            if (lowerIndex == this.dataSize - 1) {
                --lowerIndex;
            }
            double x1 = this.xValues[lowerIndex];
            double y1 = this.yValues[lowerIndex];
            int higherIndex = lowerIndex + 1;
            double x2 = this.xValues[higherIndex];
            double y2 = this.yValues[higherIndex];
            double w = (x2 - xValue) / (x2 - x1);
            double y21 = y1 * y1;
            double y22 = y2 * y2;
            double ySq = w * y21 + (1.0 - w) * y22;
            return Math.sqrt(ySq);
        }

        @Override
        protected double doFirstDerivative(double xValue) {
            int lowerIndex = Bound.lowerBoundIndex(xValue, this.xValues);
            int index = lowerIndex == this.dataSize - 1 ? this.dataSize - 2 : lowerIndex;
            double x1 = this.xValues[index];
            double y1 = this.yValues[index];
            double x2 = this.xValues[index + 1];
            double y2 = this.yValues[index + 1];
            if (y1 < 1.0E-10 && y2 >= 1.0E-10 && xValue - x1 < 1.0E-10) {
                throw new IllegalArgumentException("ask for first derivative on a value without derivative; value " + xValue + " is close to vertex " + x1 + " and value at vertex is " + y1);
            }
            if (y2 < 1.0E-10 && y1 >= 1.0E-10 && x2 - xValue < 1.0E-10) {
                throw new IllegalArgumentException("ask for first derivative on a value without derivative; value " + xValue + " is close to vertex " + x2 + " and value at vertex is " + y2);
            }
            if (y1 < 1.0E-10 && y2 < 1.0E-10) {
                return 0.0;
            }
            double w = (x2 - xValue) / (x2 - x1);
            double y21 = y1 * y1;
            double y22 = y2 * y2;
            double ySq = w * y21 + (1.0 - w) * y22;
            return 0.5 * (y22 - y21) / (x2 - x1) / Math.sqrt(ySq);
        }

        @Override
        protected DoubleArray doParameterSensitivity(double xValue) {
            double[] result = new double[this.dataSize];
            int lowerIndex = Bound.lowerBoundIndex(xValue, this.xValues);
            double x1 = this.xValues[lowerIndex];
            double y1 = this.yValues[lowerIndex];
            if (lowerIndex == this.dataSize - 1) {
                result[this.dataSize - 1] = 1.0;
                return DoubleArray.ofUnsafe((double[])result);
            }
            int higherIndex = lowerIndex + 1;
            double x2 = this.xValues[higherIndex];
            double y2 = this.yValues[higherIndex];
            if (xValue - x1 < 1.0E-10) {
                result[lowerIndex] = 1.0;
                return DoubleArray.ofUnsafe((double[])result);
            }
            if (x2 - xValue < 1.0E-10) {
                result[lowerIndex + 1] = 1.0;
                return DoubleArray.ofUnsafe((double[])result);
            }
            double w2 = (x2 - xValue) / (x2 - x1);
            if (y2 < 1.0E-10 && y1 < 1.0E-10) {
                result[lowerIndex] = Math.sqrt(w2);
                result[lowerIndex + 1] = Math.sqrt(1.0 - w2);
                return DoubleArray.ofUnsafe((double[])result);
            }
            double y21 = y1 * y1;
            double y22 = y2 * y2;
            double ySq = w2 * y21 + (1.0 - w2) * y22;
            double ySqBar = 0.5 / Math.sqrt(ySq);
            double y22Bar = (1.0 - w2) * ySqBar;
            double y21Bar = w2 * ySqBar;
            double y1Bar = 2.0 * y1 * y21Bar;
            double y2Bar = 2.0 * y2 * y22Bar;
            result[lowerIndex] = y1Bar;
            result[lowerIndex + 1] = y2Bar;
            return DoubleArray.ofUnsafe((double[])result);
        }

        @Override
        public BoundCurveInterpolator bind(BoundCurveExtrapolator extrapolatorLeft, BoundCurveExtrapolator extrapolatorRight) {
            return new Bound(this, extrapolatorLeft, extrapolatorRight);
        }
    }
}

