/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.curve.interpolator;

import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.market.curve.interpolator.AbstractBoundCurveInterpolator;
import com.opengamma.strata.market.curve.interpolator.BoundCurveExtrapolator;
import com.opengamma.strata.market.curve.interpolator.BoundCurveInterpolator;
import com.opengamma.strata.market.curve.interpolator.CurveInterpolator;
import java.io.Serializable;

final class StepUpperCurveInterpolator
implements CurveInterpolator,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final double EPS = 1.0E-12;
    public static final String NAME = "StepUpper";
    public static final CurveInterpolator INSTANCE = new StepUpperCurveInterpolator();

    private StepUpperCurveInterpolator() {
    }

    private Object readResolve() {
        return INSTANCE;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public BoundCurveInterpolator bind(DoubleArray xValues, DoubleArray yValues) {
        return new Bound(xValues, yValues);
    }

    public String toString() {
        return NAME;
    }

    static class Bound
    extends AbstractBoundCurveInterpolator {
        private final double[] xValues;
        private final double[] yValues;
        private final int maxIndex;

        Bound(DoubleArray xValues, DoubleArray yValues) {
            super(xValues, yValues);
            this.xValues = xValues.toArrayUnsafe();
            this.yValues = yValues.toArrayUnsafe();
            this.maxIndex = xValues.size() - 1;
        }

        Bound(Bound base, BoundCurveExtrapolator extrapolatorLeft, BoundCurveExtrapolator extrapolatorRight) {
            super(base, extrapolatorLeft, extrapolatorRight);
            this.xValues = base.xValues;
            this.yValues = base.yValues;
            this.maxIndex = base.maxIndex;
        }

        @Override
        protected double doInterpolate(double xValue) {
            int upperIndex = this.getUpperBoundIndex(xValue);
            return this.yValues[upperIndex];
        }

        @Override
        protected double doFirstDerivative(double xValue) {
            return 0.0;
        }

        @Override
        protected DoubleArray doParameterSensitivity(double xValue) {
            double[] result = new double[this.yValues.length];
            int upperIndex = this.getUpperBoundIndex(xValue);
            result[upperIndex] = 1.0;
            return DoubleArray.ofUnsafe((double[])result);
        }

        @Override
        public BoundCurveInterpolator bind(BoundCurveExtrapolator extrapolatorLeft, BoundCurveExtrapolator extrapolatorRight) {
            return new Bound(this, extrapolatorLeft, extrapolatorRight);
        }

        private int getUpperBoundIndex(double xValue) {
            if (xValue <= this.xValues[0] + 1.0E-12) {
                return 0;
            }
            if (xValue >= this.xValues[this.maxIndex - 1] + 1.0E-12) {
                return this.maxIndex;
            }
            int lowerIndex = Bound.lowerBoundIndex(xValue, this.xValues);
            if (Math.abs(this.xValues[lowerIndex] - xValue) < 1.0E-12) {
                return lowerIndex;
            }
            return lowerIndex + 1;
        }
    }
}

