/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.curve.interpolator;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.market.curve.interpolator.AbstractBoundCurveInterpolator;
import com.opengamma.strata.market.curve.interpolator.BoundCurveExtrapolator;
import com.opengamma.strata.market.curve.interpolator.BoundCurveInterpolator;
import com.opengamma.strata.market.curve.interpolator.CurveInterpolator;
import java.io.Serializable;

final class TimeSquareCurveInterpolator
implements CurveInterpolator,
Serializable {
    public static final String NAME = "TimeSquare";
    public static final CurveInterpolator INSTANCE = new TimeSquareCurveInterpolator();
    private static final long serialVersionUID = 1L;
    private static final double EPS = 1.0E-10;

    private TimeSquareCurveInterpolator() {
    }

    private Object readResolve() {
        return INSTANCE;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public BoundCurveInterpolator bind(DoubleArray xValues, DoubleArray yValues) {
        return new Bound(xValues, yValues);
    }

    public String toString() {
        return NAME;
    }

    static class Bound
    extends AbstractBoundCurveInterpolator {
        private final double[] xValues;
        private final double[] yValues;
        private final int dataSize;

        Bound(DoubleArray xValues, DoubleArray yValues) {
            super(xValues, yValues);
            this.xValues = xValues.toArrayUnsafe();
            this.yValues = yValues.toArrayUnsafe();
            this.dataSize = xValues.size();
        }

        Bound(Bound base, BoundCurveExtrapolator extrapolatorLeft, BoundCurveExtrapolator extrapolatorRight) {
            super(base, extrapolatorLeft, extrapolatorRight);
            this.xValues = base.xValues;
            this.yValues = base.yValues;
            this.dataSize = this.xValues.length;
        }

        @Override
        protected double doInterpolate(double xValue) {
            ArgChecker.isTrue((xValue > 0.0 ? 1 : 0) != 0, (String)"Value should be stricly positive");
            int lowerIndex = Bound.lowerBoundIndex(xValue, this.xValues);
            double x1 = this.xValues[lowerIndex];
            double y1 = this.yValues[lowerIndex];
            if (lowerIndex == this.dataSize - 1) {
                return y1;
            }
            int higherIndex = lowerIndex + 1;
            double x2 = this.xValues[higherIndex];
            double y2 = this.yValues[higherIndex];
            double w = (x2 - xValue) / (x2 - x1);
            double xy21 = x1 * y1 * y1;
            double xy22 = x2 * y2 * y2;
            double xy2 = w * xy21 + (1.0 - w) * xy22;
            return Math.sqrt(xy2 / xValue);
        }

        @Override
        protected double doFirstDerivative(double xValue) {
            ArgChecker.isTrue((xValue > 0.0 ? 1 : 0) != 0, (String)"Value should be stricly positive");
            int lowerIndex = Bound.lowerBoundIndex(xValue, this.xValues);
            int index = lowerIndex == this.dataSize - 1 ? this.dataSize - 2 : lowerIndex;
            double x1 = this.xValues[index];
            double y1 = this.yValues[index];
            int higherIndex = index + 1;
            double x2 = this.xValues[higherIndex];
            double y2 = this.yValues[higherIndex];
            if (y1 < 1.0E-10 || y2 < 1.0E-10) {
                throw new UnsupportedOperationException("node sensitivity not implemented when one node is 0 value");
            }
            double w = (x2 - xValue) / (x2 - x1);
            double xy21 = x1 * y1 * y1;
            double xy22 = x2 * y2 * y2;
            double xy2 = w * xy21 + (1.0 - w) * xy22;
            return 0.5 * (-Math.sqrt(xy2 / xValue) + (-xy21 + xy22) / (x2 - x1) / Math.sqrt(xy2 / xValue)) / xValue;
        }

        @Override
        protected DoubleArray doParameterSensitivity(double xValue) {
            double y1Bar;
            double[] resultSensitivity = new double[this.dataSize];
            int lowerIndex = Bound.lowerBoundIndex(xValue, this.xValues);
            double x1 = this.xValues[lowerIndex];
            double y1 = this.yValues[lowerIndex];
            if (lowerIndex == this.dataSize - 1) {
                resultSensitivity[this.dataSize - 1] = 1.0;
                return DoubleArray.ofUnsafe((double[])resultSensitivity);
            }
            int higherIndex = lowerIndex + 1;
            double x2 = this.xValues[higherIndex];
            double y2 = this.yValues[higherIndex];
            if (y1 < 1.0E-10 || y2 < 1.0E-10) {
                throw new UnsupportedOperationException("node sensitivity not implemented when one node is 0 value");
            }
            double w = (x2 - xValue) / (x2 - x1);
            double xy21 = x1 * y1 * y1;
            double xy22 = x2 * y2 * y2;
            double xy2 = w * xy21 + (1.0 - w) * xy22;
            double resultValue = Math.sqrt(xy2 / xValue);
            double resultValueBar = 1.0;
            double xy2Bar = 0.5 / resultValue / xValue * resultValueBar;
            double xy21Bar = w * xy2Bar;
            double xy22Bar = (1.0 - w) * xy2Bar;
            double y2Bar = 2.0 * x2 * y2 * xy22Bar;
            resultSensitivity[lowerIndex] = y1Bar = 2.0 * x1 * y1 * xy21Bar;
            resultSensitivity[lowerIndex + 1] = y2Bar;
            return DoubleArray.ofUnsafe((double[])resultSensitivity);
        }

        @Override
        public BoundCurveInterpolator bind(BoundCurveExtrapolator extrapolatorLeft, BoundCurveExtrapolator extrapolatorRight) {
            return new Bound(this, extrapolatorLeft, extrapolatorRight);
        }
    }
}

