/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.curve.node;

import com.google.common.collect.ImmutableList;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.StandardId;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.data.MarketData;
import com.opengamma.strata.data.MarketDataId;
import com.opengamma.strata.data.ObservableId;
import com.opengamma.strata.market.curve.IsdaCreditCurveNode;
import com.opengamma.strata.market.param.DatedParameterMetadata;
import com.opengamma.strata.market.param.LabelDateParameterMetadata;
import com.opengamma.strata.market.param.TenorDateParameterMetadata;
import com.opengamma.strata.product.common.BuySell;
import com.opengamma.strata.product.credit.Cds;
import com.opengamma.strata.product.credit.CdsIndex;
import com.opengamma.strata.product.credit.CdsIndexCalibrationTrade;
import com.opengamma.strata.product.credit.CdsIndexTrade;
import com.opengamma.strata.product.credit.CdsQuote;
import com.opengamma.strata.product.credit.CdsTrade;
import com.opengamma.strata.product.credit.type.CdsQuoteConvention;
import com.opengamma.strata.product.credit.type.CdsTemplate;
import com.opengamma.strata.product.credit.type.DatesCdsTemplate;
import com.opengamma.strata.product.credit.type.TenorCdsTemplate;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.OptionalDouble;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutablePreBuild;
import org.joda.beans.gen.ImmutableValidator;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class CdsIndexIsdaCreditCurveNode
implements IsdaCreditCurveNode,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final CdsTemplate template;
    @PropertyDefinition(validate="notEmpty", overrideGet=true)
    private final String label;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final ObservableId observableId;
    @PropertyDefinition(validate="notNull")
    private final StandardId cdsIndexId;
    @PropertyDefinition(validate="notNull")
    private final ImmutableList<StandardId> legalEntityIds;
    @PropertyDefinition(validate="notNull")
    private final CdsQuoteConvention quoteConvention;
    @PropertyDefinition(get="optional")
    private final Double fixedRate;
    private static final long serialVersionUID = 1L;

    public static CdsIndexIsdaCreditCurveNode ofParSpread(CdsTemplate template, ObservableId observableId, StandardId cdsIndexId, List<StandardId> legalEntityIds) {
        return CdsIndexIsdaCreditCurveNode.builder().template(template).observableId(observableId).cdsIndexId(cdsIndexId).legalEntityIds(legalEntityIds).quoteConvention(CdsQuoteConvention.PAR_SPREAD).build();
    }

    public static CdsIndexIsdaCreditCurveNode ofPointsUpfront(CdsTemplate template, ObservableId observableId, StandardId cdsIndexId, List<StandardId> legalEntityIds, Double fixedRate) {
        return CdsIndexIsdaCreditCurveNode.builder().template(template).observableId(observableId).cdsIndexId(cdsIndexId).legalEntityIds(legalEntityIds).quoteConvention(CdsQuoteConvention.POINTS_UPFRONT).fixedRate(fixedRate).build();
    }

    public static CdsIndexIsdaCreditCurveNode ofQuotedSpread(CdsTemplate template, ObservableId observableId, StandardId cdsIndexId, List<StandardId> legalEntityIds, Double fixedRate) {
        return CdsIndexIsdaCreditCurveNode.builder().template(template).observableId(observableId).cdsIndexId(cdsIndexId).legalEntityIds(legalEntityIds).quoteConvention(CdsQuoteConvention.QUOTED_SPREAD).fixedRate(fixedRate).build();
    }

    @ImmutablePreBuild
    private static void preBuild(Builder builder) {
        if (builder.template != null && builder.label == null) {
            builder.label = builder.template instanceof TenorCdsTemplate ? ((TenorCdsTemplate)builder.template).getTenor().toString() : ((DatesCdsTemplate)builder.template).getEndDate().toString();
        }
    }

    @ImmutableValidator
    private void validate() {
        if (this.quoteConvention.equals((Object)CdsQuoteConvention.PAR_SPREAD)) {
            ArgChecker.isTrue((this.fixedRate == null ? 1 : 0) != 0, (String)"The fixed rate must be empty for par spread quote");
        } else {
            ArgChecker.isTrue((this.fixedRate != null ? 1 : 0) != 0, (String)"The fixed rate must be specifed if quote convention is points upfront or quoted spread");
        }
    }

    @Override
    public LocalDate date(LocalDate tradeDate, ReferenceData refData) {
        CdsTrade trade = this.template.createTrade(this.cdsIndexId, tradeDate, BuySell.BUY, 1.0, 1.0, refData);
        return trade.getProduct().resolve(refData).getProtectionEndDate();
    }

    @Override
    public DatedParameterMetadata metadata(LocalDate nodeDate) {
        return this.template instanceof TenorCdsTemplate ? TenorDateParameterMetadata.of(nodeDate, ((TenorCdsTemplate)this.template).getTenor(), this.label) : LabelDateParameterMetadata.of(nodeDate, this.label);
    }

    public CdsIndexCalibrationTrade trade(double quantity, MarketData marketData, ReferenceData refData) {
        BuySell buySell = quantity > 0.0 ? BuySell.BUY : BuySell.SELL;
        LocalDate valuationDate = marketData.getValuationDate();
        double quoteValue = (Double)marketData.getValue((MarketDataId)this.observableId);
        CdsQuote quote = CdsQuote.of((CdsQuoteConvention)this.quoteConvention, (double)quoteValue);
        double notional = Math.abs(quantity);
        CdsTrade cdsTrade = null;
        if (this.quoteConvention.equals((Object)CdsQuoteConvention.PAR_SPREAD)) {
            cdsTrade = this.template.createTrade(this.cdsIndexId, valuationDate, buySell, notional, quoteValue, refData);
        } else {
            double coupon = this.getFixedRate().getAsDouble();
            cdsTrade = this.template.createTrade(this.cdsIndexId, valuationDate, buySell, notional, coupon, refData);
        }
        Cds cdsProduct = cdsTrade.getProduct();
        CdsIndexTrade cdsIndex = CdsIndexTrade.builder().info(cdsTrade.getInfo()).product(CdsIndex.builder().buySell(cdsProduct.getBuySell()).currency(cdsProduct.getCurrency()).notional(cdsProduct.getNotional()).cdsIndexId(this.cdsIndexId).legalEntityIds(this.legalEntityIds).dayCount(cdsProduct.getDayCount()).paymentSchedule(cdsProduct.getPaymentSchedule()).fixedRate(cdsProduct.getFixedRate()).paymentOnDefault(cdsProduct.getPaymentOnDefault()).protectionStart(cdsProduct.getProtectionStart()).settlementDateOffset(cdsProduct.getSettlementDateOffset()).stepinDateOffset(cdsProduct.getStepinDateOffset()).build()).build();
        return CdsIndexCalibrationTrade.of((CdsIndexTrade)cdsIndex, (CdsQuote)quote);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private CdsIndexIsdaCreditCurveNode(CdsTemplate template, String label, ObservableId observableId, StandardId cdsIndexId, List<StandardId> legalEntityIds, CdsQuoteConvention quoteConvention, Double fixedRate) {
        JodaBeanUtils.notNull((Object)template, (String)"template");
        JodaBeanUtils.notEmpty((String)label, (String)"label");
        JodaBeanUtils.notNull((Object)observableId, (String)"observableId");
        JodaBeanUtils.notNull((Object)cdsIndexId, (String)"cdsIndexId");
        JodaBeanUtils.notNull(legalEntityIds, (String)"legalEntityIds");
        JodaBeanUtils.notNull((Object)quoteConvention, (String)"quoteConvention");
        this.template = template;
        this.label = label;
        this.observableId = observableId;
        this.cdsIndexId = cdsIndexId;
        this.legalEntityIds = ImmutableList.copyOf(legalEntityIds);
        this.quoteConvention = quoteConvention;
        this.fixedRate = fixedRate;
        this.validate();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public CdsTemplate getTemplate() {
        return this.template;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public ObservableId getObservableId() {
        return this.observableId;
    }

    public StandardId getCdsIndexId() {
        return this.cdsIndexId;
    }

    public ImmutableList<StandardId> getLegalEntityIds() {
        return this.legalEntityIds;
    }

    public CdsQuoteConvention getQuoteConvention() {
        return this.quoteConvention;
    }

    public OptionalDouble getFixedRate() {
        return this.fixedRate != null ? OptionalDouble.of(this.fixedRate) : OptionalDouble.empty();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            CdsIndexIsdaCreditCurveNode other = (CdsIndexIsdaCreditCurveNode)obj;
            return JodaBeanUtils.equal((Object)this.template, (Object)other.template) && JodaBeanUtils.equal((Object)this.label, (Object)other.label) && JodaBeanUtils.equal((Object)this.observableId, (Object)other.observableId) && JodaBeanUtils.equal((Object)this.cdsIndexId, (Object)other.cdsIndexId) && JodaBeanUtils.equal(this.legalEntityIds, other.legalEntityIds) && JodaBeanUtils.equal((Object)this.quoteConvention, (Object)other.quoteConvention) && JodaBeanUtils.equal((Object)this.fixedRate, (Object)other.fixedRate);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.template);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.label);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.observableId);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.cdsIndexId);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.legalEntityIds);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.quoteConvention);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.fixedRate);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(256);
        buf.append("CdsIndexIsdaCreditCurveNode{");
        buf.append("template").append('=').append(JodaBeanUtils.toString((Object)this.template)).append(',').append(' ');
        buf.append("label").append('=').append(JodaBeanUtils.toString((Object)this.label)).append(',').append(' ');
        buf.append("observableId").append('=').append(JodaBeanUtils.toString((Object)this.observableId)).append(',').append(' ');
        buf.append("cdsIndexId").append('=').append(JodaBeanUtils.toString((Object)this.cdsIndexId)).append(',').append(' ');
        buf.append("legalEntityIds").append('=').append(JodaBeanUtils.toString(this.legalEntityIds)).append(',').append(' ');
        buf.append("quoteConvention").append('=').append(JodaBeanUtils.toString((Object)this.quoteConvention)).append(',').append(' ');
        buf.append("fixedRate").append('=').append(JodaBeanUtils.toString((Object)this.fixedRate));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<CdsIndexIsdaCreditCurveNode> {
        private CdsTemplate template;
        private String label;
        private ObservableId observableId;
        private StandardId cdsIndexId;
        private List<StandardId> legalEntityIds = ImmutableList.of();
        private CdsQuoteConvention quoteConvention;
        private Double fixedRate;

        private Builder() {
        }

        private Builder(CdsIndexIsdaCreditCurveNode beanToCopy) {
            this.template = beanToCopy.getTemplate();
            this.label = beanToCopy.getLabel();
            this.observableId = beanToCopy.getObservableId();
            this.cdsIndexId = beanToCopy.getCdsIndexId();
            this.legalEntityIds = beanToCopy.getLegalEntityIds();
            this.quoteConvention = beanToCopy.getQuoteConvention();
            this.fixedRate = beanToCopy.fixedRate;
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case -1321546630: {
                    return this.template;
                }
                case 102727412: {
                    return this.label;
                }
                case -518800962: {
                    return this.observableId;
                }
                case -464117509: {
                    return this.cdsIndexId;
                }
                case 1085098268: {
                    return this.legalEntityIds;
                }
                case 2049149709: {
                    return this.quoteConvention;
                }
                case 747425396: {
                    return this.fixedRate;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case -1321546630: {
                    this.template = (CdsTemplate)newValue;
                    break;
                }
                case 102727412: {
                    this.label = (String)newValue;
                    break;
                }
                case -518800962: {
                    this.observableId = (ObservableId)newValue;
                    break;
                }
                case -464117509: {
                    this.cdsIndexId = (StandardId)newValue;
                    break;
                }
                case 1085098268: {
                    this.legalEntityIds = (List)newValue;
                    break;
                }
                case 2049149709: {
                    this.quoteConvention = (CdsQuoteConvention)newValue;
                    break;
                }
                case 747425396: {
                    this.fixedRate = (Double)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public CdsIndexIsdaCreditCurveNode build() {
            CdsIndexIsdaCreditCurveNode.preBuild(this);
            return new CdsIndexIsdaCreditCurveNode(this.template, this.label, this.observableId, this.cdsIndexId, this.legalEntityIds, this.quoteConvention, this.fixedRate);
        }

        public Builder template(CdsTemplate template) {
            JodaBeanUtils.notNull((Object)template, (String)"template");
            this.template = template;
            return this;
        }

        public Builder label(String label) {
            JodaBeanUtils.notEmpty((String)label, (String)"label");
            this.label = label;
            return this;
        }

        public Builder observableId(ObservableId observableId) {
            JodaBeanUtils.notNull((Object)observableId, (String)"observableId");
            this.observableId = observableId;
            return this;
        }

        public Builder cdsIndexId(StandardId cdsIndexId) {
            JodaBeanUtils.notNull((Object)cdsIndexId, (String)"cdsIndexId");
            this.cdsIndexId = cdsIndexId;
            return this;
        }

        public Builder legalEntityIds(List<StandardId> legalEntityIds) {
            JodaBeanUtils.notNull(legalEntityIds, (String)"legalEntityIds");
            this.legalEntityIds = legalEntityIds;
            return this;
        }

        public Builder legalEntityIds(StandardId ... legalEntityIds) {
            return this.legalEntityIds((List<StandardId>)ImmutableList.copyOf((Object[])legalEntityIds));
        }

        public Builder quoteConvention(CdsQuoteConvention quoteConvention) {
            JodaBeanUtils.notNull((Object)quoteConvention, (String)"quoteConvention");
            this.quoteConvention = quoteConvention;
            return this;
        }

        public Builder fixedRate(Double fixedRate) {
            this.fixedRate = fixedRate;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(256);
            buf.append("CdsIndexIsdaCreditCurveNode.Builder{");
            buf.append("template").append('=').append(JodaBeanUtils.toString((Object)this.template)).append(',').append(' ');
            buf.append("label").append('=').append(JodaBeanUtils.toString((Object)this.label)).append(',').append(' ');
            buf.append("observableId").append('=').append(JodaBeanUtils.toString((Object)this.observableId)).append(',').append(' ');
            buf.append("cdsIndexId").append('=').append(JodaBeanUtils.toString((Object)this.cdsIndexId)).append(',').append(' ');
            buf.append("legalEntityIds").append('=').append(JodaBeanUtils.toString(this.legalEntityIds)).append(',').append(' ');
            buf.append("quoteConvention").append('=').append(JodaBeanUtils.toString((Object)this.quoteConvention)).append(',').append(' ');
            buf.append("fixedRate").append('=').append(JodaBeanUtils.toString((Object)this.fixedRate));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<CdsTemplate> template = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"template", CdsIndexIsdaCreditCurveNode.class, CdsTemplate.class);
        private final MetaProperty<String> label = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"label", CdsIndexIsdaCreditCurveNode.class, String.class);
        private final MetaProperty<ObservableId> observableId = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"observableId", CdsIndexIsdaCreditCurveNode.class, ObservableId.class);
        private final MetaProperty<StandardId> cdsIndexId = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"cdsIndexId", CdsIndexIsdaCreditCurveNode.class, StandardId.class);
        private final MetaProperty<ImmutableList<StandardId>> legalEntityIds = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"legalEntityIds", CdsIndexIsdaCreditCurveNode.class, ImmutableList.class);
        private final MetaProperty<CdsQuoteConvention> quoteConvention = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"quoteConvention", CdsIndexIsdaCreditCurveNode.class, CdsQuoteConvention.class);
        private final MetaProperty<Double> fixedRate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"fixedRate", CdsIndexIsdaCreditCurveNode.class, Double.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"template", "label", "observableId", "cdsIndexId", "legalEntityIds", "quoteConvention", "fixedRate"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case -1321546630: {
                    return this.template;
                }
                case 102727412: {
                    return this.label;
                }
                case -518800962: {
                    return this.observableId;
                }
                case -464117509: {
                    return this.cdsIndexId;
                }
                case 1085098268: {
                    return this.legalEntityIds;
                }
                case 2049149709: {
                    return this.quoteConvention;
                }
                case 747425396: {
                    return this.fixedRate;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends CdsIndexIsdaCreditCurveNode> beanType() {
            return CdsIndexIsdaCreditCurveNode.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<CdsTemplate> template() {
            return this.template;
        }

        public MetaProperty<String> label() {
            return this.label;
        }

        public MetaProperty<ObservableId> observableId() {
            return this.observableId;
        }

        public MetaProperty<StandardId> cdsIndexId() {
            return this.cdsIndexId;
        }

        public MetaProperty<ImmutableList<StandardId>> legalEntityIds() {
            return this.legalEntityIds;
        }

        public MetaProperty<CdsQuoteConvention> quoteConvention() {
            return this.quoteConvention;
        }

        public MetaProperty<Double> fixedRate() {
            return this.fixedRate;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case -1321546630: {
                    return ((CdsIndexIsdaCreditCurveNode)bean).getTemplate();
                }
                case 102727412: {
                    return ((CdsIndexIsdaCreditCurveNode)bean).getLabel();
                }
                case -518800962: {
                    return ((CdsIndexIsdaCreditCurveNode)bean).getObservableId();
                }
                case -464117509: {
                    return ((CdsIndexIsdaCreditCurveNode)bean).getCdsIndexId();
                }
                case 1085098268: {
                    return ((CdsIndexIsdaCreditCurveNode)bean).getLegalEntityIds();
                }
                case 2049149709: {
                    return ((CdsIndexIsdaCreditCurveNode)bean).getQuoteConvention();
                }
                case 747425396: {
                    return ((CdsIndexIsdaCreditCurveNode)bean).fixedRate;
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

