/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.curve.node;

import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.currency.CurrencyPair;
import com.opengamma.strata.basics.currency.FxRate;
import com.opengamma.strata.basics.currency.FxRateProvider;
import com.opengamma.strata.basics.date.Tenor;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.data.FxRateId;
import com.opengamma.strata.data.MarketData;
import com.opengamma.strata.data.MarketDataId;
import com.opengamma.strata.data.ObservableId;
import com.opengamma.strata.market.ValueType;
import com.opengamma.strata.market.curve.CurveNode;
import com.opengamma.strata.market.curve.CurveNodeDate;
import com.opengamma.strata.market.curve.CurveNodeDateOrder;
import com.opengamma.strata.market.param.DatedParameterMetadata;
import com.opengamma.strata.market.param.LabelDateParameterMetadata;
import com.opengamma.strata.market.param.TenorDateParameterMetadata;
import com.opengamma.strata.product.common.BuySell;
import com.opengamma.strata.product.fx.FxSwapTrade;
import com.opengamma.strata.product.fx.ResolvedFxSwapTrade;
import com.opengamma.strata.product.fx.type.FxSwapTemplate;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.Period;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableDefaults;
import org.joda.beans.gen.ImmutablePreBuild;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class FxSwapCurveNode
implements CurveNode,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final FxSwapTemplate template;
    @PropertyDefinition(validate="notNull")
    private final FxRateId fxRateId;
    @PropertyDefinition(validate="notNull")
    private final ObservableId farForwardPointsId;
    @PropertyDefinition(validate="notEmpty", overrideGet=true)
    private final String label;
    @PropertyDefinition
    private final CurveNodeDate date;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final CurveNodeDateOrder dateOrder;
    private static final long serialVersionUID = 1L;

    public static FxSwapCurveNode of(FxSwapTemplate template, ObservableId farForwardPointsId) {
        return FxSwapCurveNode.builder().template(template).farForwardPointsId(farForwardPointsId).build();
    }

    public static FxSwapCurveNode of(FxSwapTemplate template, ObservableId farForwardPointsId, String label) {
        return FxSwapCurveNode.builder().template(template).farForwardPointsId(farForwardPointsId).label(label).build();
    }

    @ImmutableDefaults
    private static void applyDefaults(Builder builder) {
        builder.date = CurveNodeDate.END;
        builder.dateOrder = CurveNodeDateOrder.DEFAULT;
    }

    @ImmutablePreBuild
    private static void preBuild(Builder builder) {
        if (builder.template != null) {
            if (builder.label == null) {
                builder.label = Tenor.of((Period)builder.template.getPeriodToFar()).toString();
            }
            if (builder.fxRateId == null) {
                builder.fxRateId = FxRateId.of((CurrencyPair)builder.template.getCurrencyPair());
            } else {
                ArgChecker.isTrue((boolean)builder.fxRateId.getPair().toConventional().equals((Object)builder.template.getCurrencyPair().toConventional()), (String)"FxRateId currency pair '{}' must match that of the template '{}'", (Object[])new Object[]{builder.fxRateId.getPair(), builder.template.getCurrencyPair()});
            }
        }
    }

    @Override
    public Set<? extends MarketDataId<?>> requirements() {
        return ImmutableSet.of((Object)this.fxRateId, (Object)this.farForwardPointsId);
    }

    @Override
    public LocalDate date(LocalDate valuationDate, ReferenceData refData) {
        return this.date.calculate(() -> this.calculateEnd(valuationDate, refData), () -> this.calculateLastFixingDate(valuationDate, refData));
    }

    @Override
    public DatedParameterMetadata metadata(LocalDate valuationDate, ReferenceData refData) {
        LocalDate nodeDate = this.date(valuationDate, refData);
        if (this.date.isFixed()) {
            return LabelDateParameterMetadata.of(nodeDate, this.label);
        }
        Tenor tenor = Tenor.of((Period)this.template.getPeriodToFar());
        return TenorDateParameterMetadata.of(nodeDate, tenor, this.label);
    }

    private LocalDate calculateEnd(LocalDate valuationDate, ReferenceData refData) {
        FxSwapTrade trade = this.template.createTrade(valuationDate, BuySell.BUY, 1.0, 1.0, 0.0, refData);
        return trade.getProduct().getFarLeg().resolve(refData).getPaymentDate();
    }

    private LocalDate calculateLastFixingDate(LocalDate valuationDate, ReferenceData refData) {
        throw new UnsupportedOperationException("Node date of 'LastFixing' is not supported for FxSwap");
    }

    public FxSwapTrade trade(double quantity, MarketData marketData, ReferenceData refData) {
        FxRate fxRate = (FxRate)marketData.getValue((MarketDataId)this.fxRateId);
        double rate = fxRate.fxRate(this.template.getCurrencyPair());
        double fxPts = (Double)marketData.getValue((MarketDataId)this.farForwardPointsId);
        BuySell buySell = quantity > 0.0 ? BuySell.BUY : BuySell.SELL;
        return this.template.createTrade(marketData.getValuationDate(), buySell, Math.abs(quantity), rate, fxPts, refData);
    }

    public ResolvedFxSwapTrade resolvedTrade(double quantity, MarketData marketData, ReferenceData refData) {
        return this.trade(quantity, marketData, refData).resolve(refData);
    }

    public ResolvedFxSwapTrade sampleResolvedTrade(LocalDate valuationDate, FxRateProvider fxProvider, ReferenceData refData) {
        double rate = fxProvider.fxRate(this.template.getCurrencyPair());
        FxSwapTrade trade = this.template.createTrade(valuationDate, BuySell.BUY, 1.0, rate, 0.0, refData);
        return trade.resolve(refData);
    }

    @Override
    public double initialGuess(MarketData marketData, ValueType valueType) {
        if (ValueType.DISCOUNT_FACTOR.equals((Object)valueType)) {
            return 1.0;
        }
        return 0.0;
    }

    public FxSwapCurveNode withDate(CurveNodeDate date) {
        return new FxSwapCurveNode(this.template, this.fxRateId, this.farForwardPointsId, this.label, date, this.dateOrder);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private FxSwapCurveNode(FxSwapTemplate template, FxRateId fxRateId, ObservableId farForwardPointsId, String label, CurveNodeDate date, CurveNodeDateOrder dateOrder) {
        JodaBeanUtils.notNull((Object)template, (String)"template");
        JodaBeanUtils.notNull((Object)fxRateId, (String)"fxRateId");
        JodaBeanUtils.notNull((Object)farForwardPointsId, (String)"farForwardPointsId");
        JodaBeanUtils.notEmpty((String)label, (String)"label");
        JodaBeanUtils.notNull((Object)dateOrder, (String)"dateOrder");
        this.template = template;
        this.fxRateId = fxRateId;
        this.farForwardPointsId = farForwardPointsId;
        this.label = label;
        this.date = date;
        this.dateOrder = dateOrder;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public FxSwapTemplate getTemplate() {
        return this.template;
    }

    public FxRateId getFxRateId() {
        return this.fxRateId;
    }

    public ObservableId getFarForwardPointsId() {
        return this.farForwardPointsId;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    public CurveNodeDate getDate() {
        return this.date;
    }

    @Override
    public CurveNodeDateOrder getDateOrder() {
        return this.dateOrder;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            FxSwapCurveNode other = (FxSwapCurveNode)obj;
            return JodaBeanUtils.equal((Object)this.template, (Object)other.template) && JodaBeanUtils.equal((Object)this.fxRateId, (Object)other.fxRateId) && JodaBeanUtils.equal((Object)this.farForwardPointsId, (Object)other.farForwardPointsId) && JodaBeanUtils.equal((Object)this.label, (Object)other.label) && JodaBeanUtils.equal((Object)this.date, (Object)other.date) && JodaBeanUtils.equal((Object)this.dateOrder, (Object)other.dateOrder);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.template);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.fxRateId);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.farForwardPointsId);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.label);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.date);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.dateOrder);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(224);
        buf.append("FxSwapCurveNode{");
        buf.append("template").append('=').append(JodaBeanUtils.toString((Object)this.template)).append(',').append(' ');
        buf.append("fxRateId").append('=').append(JodaBeanUtils.toString((Object)this.fxRateId)).append(',').append(' ');
        buf.append("farForwardPointsId").append('=').append(JodaBeanUtils.toString((Object)this.farForwardPointsId)).append(',').append(' ');
        buf.append("label").append('=').append(JodaBeanUtils.toString((Object)this.label)).append(',').append(' ');
        buf.append("date").append('=').append(JodaBeanUtils.toString((Object)this.date)).append(',').append(' ');
        buf.append("dateOrder").append('=').append(JodaBeanUtils.toString((Object)this.dateOrder));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<FxSwapCurveNode> {
        private FxSwapTemplate template;
        private FxRateId fxRateId;
        private ObservableId farForwardPointsId;
        private String label;
        private CurveNodeDate date;
        private CurveNodeDateOrder dateOrder;

        private Builder() {
            FxSwapCurveNode.applyDefaults(this);
        }

        private Builder(FxSwapCurveNode beanToCopy) {
            this.template = beanToCopy.getTemplate();
            this.fxRateId = beanToCopy.getFxRateId();
            this.farForwardPointsId = beanToCopy.getFarForwardPointsId();
            this.label = beanToCopy.getLabel();
            this.date = beanToCopy.getDate();
            this.dateOrder = beanToCopy.getDateOrder();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case -1321546630: {
                    return this.template;
                }
                case -1054985843: {
                    return this.fxRateId;
                }
                case -566044884: {
                    return this.farForwardPointsId;
                }
                case 102727412: {
                    return this.label;
                }
                case 3076014: {
                    return this.date;
                }
                case -263699392: {
                    return this.dateOrder;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case -1321546630: {
                    this.template = (FxSwapTemplate)newValue;
                    break;
                }
                case -1054985843: {
                    this.fxRateId = (FxRateId)newValue;
                    break;
                }
                case -566044884: {
                    this.farForwardPointsId = (ObservableId)newValue;
                    break;
                }
                case 102727412: {
                    this.label = (String)newValue;
                    break;
                }
                case 3076014: {
                    this.date = (CurveNodeDate)newValue;
                    break;
                }
                case -263699392: {
                    this.dateOrder = (CurveNodeDateOrder)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public FxSwapCurveNode build() {
            FxSwapCurveNode.preBuild(this);
            return new FxSwapCurveNode(this.template, this.fxRateId, this.farForwardPointsId, this.label, this.date, this.dateOrder);
        }

        public Builder template(FxSwapTemplate template) {
            JodaBeanUtils.notNull((Object)template, (String)"template");
            this.template = template;
            return this;
        }

        public Builder fxRateId(FxRateId fxRateId) {
            JodaBeanUtils.notNull((Object)fxRateId, (String)"fxRateId");
            this.fxRateId = fxRateId;
            return this;
        }

        public Builder farForwardPointsId(ObservableId farForwardPointsId) {
            JodaBeanUtils.notNull((Object)farForwardPointsId, (String)"farForwardPointsId");
            this.farForwardPointsId = farForwardPointsId;
            return this;
        }

        public Builder label(String label) {
            JodaBeanUtils.notEmpty((String)label, (String)"label");
            this.label = label;
            return this;
        }

        public Builder date(CurveNodeDate date) {
            this.date = date;
            return this;
        }

        public Builder dateOrder(CurveNodeDateOrder dateOrder) {
            JodaBeanUtils.notNull((Object)dateOrder, (String)"dateOrder");
            this.dateOrder = dateOrder;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(224);
            buf.append("FxSwapCurveNode.Builder{");
            buf.append("template").append('=').append(JodaBeanUtils.toString((Object)this.template)).append(',').append(' ');
            buf.append("fxRateId").append('=').append(JodaBeanUtils.toString((Object)this.fxRateId)).append(',').append(' ');
            buf.append("farForwardPointsId").append('=').append(JodaBeanUtils.toString((Object)this.farForwardPointsId)).append(',').append(' ');
            buf.append("label").append('=').append(JodaBeanUtils.toString((Object)this.label)).append(',').append(' ');
            buf.append("date").append('=').append(JodaBeanUtils.toString((Object)this.date)).append(',').append(' ');
            buf.append("dateOrder").append('=').append(JodaBeanUtils.toString((Object)this.dateOrder));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<FxSwapTemplate> template = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"template", FxSwapCurveNode.class, FxSwapTemplate.class);
        private final MetaProperty<FxRateId> fxRateId = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"fxRateId", FxSwapCurveNode.class, FxRateId.class);
        private final MetaProperty<ObservableId> farForwardPointsId = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"farForwardPointsId", FxSwapCurveNode.class, ObservableId.class);
        private final MetaProperty<String> label = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"label", FxSwapCurveNode.class, String.class);
        private final MetaProperty<CurveNodeDate> date = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"date", FxSwapCurveNode.class, CurveNodeDate.class);
        private final MetaProperty<CurveNodeDateOrder> dateOrder = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"dateOrder", FxSwapCurveNode.class, CurveNodeDateOrder.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"template", "fxRateId", "farForwardPointsId", "label", "date", "dateOrder"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case -1321546630: {
                    return this.template;
                }
                case -1054985843: {
                    return this.fxRateId;
                }
                case -566044884: {
                    return this.farForwardPointsId;
                }
                case 102727412: {
                    return this.label;
                }
                case 3076014: {
                    return this.date;
                }
                case -263699392: {
                    return this.dateOrder;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends FxSwapCurveNode> beanType() {
            return FxSwapCurveNode.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<FxSwapTemplate> template() {
            return this.template;
        }

        public MetaProperty<FxRateId> fxRateId() {
            return this.fxRateId;
        }

        public MetaProperty<ObservableId> farForwardPointsId() {
            return this.farForwardPointsId;
        }

        public MetaProperty<String> label() {
            return this.label;
        }

        public MetaProperty<CurveNodeDate> date() {
            return this.date;
        }

        public MetaProperty<CurveNodeDateOrder> dateOrder() {
            return this.dateOrder;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case -1321546630: {
                    return ((FxSwapCurveNode)bean).getTemplate();
                }
                case -1054985843: {
                    return ((FxSwapCurveNode)bean).getFxRateId();
                }
                case -566044884: {
                    return ((FxSwapCurveNode)bean).getFarForwardPointsId();
                }
                case 102727412: {
                    return ((FxSwapCurveNode)bean).getLabel();
                }
                case 3076014: {
                    return ((FxSwapCurveNode)bean).getDate();
                }
                case -263699392: {
                    return ((FxSwapCurveNode)bean).getDateOrder();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

