/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.explain;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.date.DayCount;
import com.opengamma.strata.basics.index.Index;
import com.opengamma.strata.collect.TypedString;
import com.opengamma.strata.market.explain.ExplainMap;
import com.opengamma.strata.product.common.PayReceive;
import com.opengamma.strata.product.swap.CompoundingMethod;
import java.time.LocalDate;
import java.util.List;
import org.joda.convert.FromString;

public final class ExplainKey<T>
extends TypedString<ExplainKey<T>> {
    private static final long serialVersionUID = 1L;
    public static final ExplainKey<Integer> ENTRY_INDEX = ExplainKey.of("EntryIndex");
    public static final ExplainKey<String> ENTRY_TYPE = ExplainKey.of("EntryType");
    public static final ExplainKey<List<ExplainMap>> LEGS = ExplainKey.of("Legs");
    public static final ExplainKey<List<ExplainMap>> PAYMENT_EVENTS = ExplainKey.of("PaymentEvents");
    public static final ExplainKey<List<ExplainMap>> PAYMENT_PERIODS = ExplainKey.of("PaymentPeriods");
    public static final ExplainKey<List<ExplainMap>> ACCRUAL_PERIODS = ExplainKey.of("AccrualPeriods");
    public static final ExplainKey<List<ExplainMap>> RESET_PERIODS = ExplainKey.of("ResetPeriods");
    public static final ExplainKey<List<ExplainMap>> OBSERVATIONS = ExplainKey.of("Observations");
    public static final ExplainKey<CurrencyAmount> PRESENT_VALUE = ExplainKey.of("PresentValue");
    public static final ExplainKey<CurrencyAmount> FORECAST_VALUE = ExplainKey.of("ForecastValue");
    public static final ExplainKey<Boolean> COMPLETED = ExplainKey.of("Completed");
    public static final ExplainKey<Currency> PAYMENT_CURRENCY = ExplainKey.of("PaymentCurrency");
    public static final ExplainKey<PayReceive> PAY_RECEIVE = ExplainKey.of("PayReceive");
    public static final ExplainKey<String> LEG_TYPE = ExplainKey.of("LegType");
    public static final ExplainKey<CurrencyAmount> NOTIONAL = ExplainKey.of("Notional");
    public static final ExplainKey<CurrencyAmount> TRADE_NOTIONAL = ExplainKey.of("TradeNotional");
    public static final ExplainKey<LocalDate> PAYMENT_DATE = ExplainKey.of("PaymentDate");
    public static final ExplainKey<LocalDate> UNADJUSTED_PAYMENT_DATE = ExplainKey.of("PaymentDate");
    public static final ExplainKey<LocalDate> START_DATE = ExplainKey.of("StartDate");
    public static final ExplainKey<LocalDate> UNADJUSTED_START_DATE = ExplainKey.of("UnadjustedStartDate");
    public static final ExplainKey<LocalDate> END_DATE = ExplainKey.of("EndDate");
    public static final ExplainKey<LocalDate> UNADJUSTED_END_DATE = ExplainKey.of("UnadjustedEndDate");
    public static final ExplainKey<DayCount> ACCRUAL_DAY_COUNT = ExplainKey.of("AccrualDayCount");
    public static final ExplainKey<Double> ACCRUAL_YEAR_FRACTION = ExplainKey.of("AccrualYearFraction");
    public static final ExplainKey<Integer> ACCRUAL_DAYS = ExplainKey.of("AccrualDays");
    public static final ExplainKey<Integer> DAYS = ExplainKey.of("Days");
    public static final ExplainKey<Double> DISCOUNT_FACTOR = ExplainKey.of("DiscountFactor");
    public static final ExplainKey<Double> FIXED_RATE = ExplainKey.of("FixedRate");
    public static final ExplainKey<Index> INDEX = ExplainKey.of("Index");
    public static final ExplainKey<LocalDate> FORWARD_RATE_START_DATE = ExplainKey.of("ForwardRateStartDate");
    public static final ExplainKey<LocalDate> FORWARD_RATE_END_DATE = ExplainKey.of("ForwardRateEndDate");
    public static final ExplainKey<LocalDate> FIXING_DATE = ExplainKey.of("FixingDate");
    public static final ExplainKey<Double> INDEX_VALUE = ExplainKey.of("IndexValue");
    public static final ExplainKey<Boolean> FROM_FIXING_SERIES = ExplainKey.of("FromFixingSeries");
    public static final ExplainKey<Double> WEIGHT = ExplainKey.of("Weight");
    public static final ExplainKey<Double> COMBINED_RATE = ExplainKey.of("CombinedRate");
    public static final ExplainKey<Double> SPREAD = ExplainKey.of("Spread");
    public static final ExplainKey<Double> GEARING = ExplainKey.of("Gearing");
    public static final ExplainKey<Double> PAY_OFF_RATE = ExplainKey.of("PayOffRate");
    public static final ExplainKey<Double> UNIT_AMOUNT = ExplainKey.of("UnitAmount");
    public static final ExplainKey<CompoundingMethod> COMPOUNDING = ExplainKey.of("CompoundingMethod");
    public static final ExplainKey<Double> STRIKE_VALUE = ExplainKey.of("StrikeValue");
    public static final ExplainKey<Double> CONVEXITY_ADJUSTED_RATE = ExplainKey.of("ConvexityAdjustedRate");
    public static final ExplainKey<Double> FORWARD_RATE = ExplainKey.of("ForwardRate");

    @FromString
    public static <R> ExplainKey<R> of(String name) {
        return new ExplainKey(name);
    }

    private ExplainKey(String name) {
        super(name);
    }
}

