/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.observable;

import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.data.scenario.ScenarioArray;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.stream.Stream;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class QuoteScenarioArray
implements ScenarioArray<Double>,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final DoubleArray quotes;
    private static final long serialVersionUID = 1L;

    public static QuoteScenarioArray of(DoubleArray quotes) {
        return new QuoteScenarioArray(quotes);
    }

    public int getScenarioCount() {
        return this.quotes.size();
    }

    public Double get(int scenarioIndex) {
        return this.quotes.get(scenarioIndex);
    }

    public Stream<Double> stream() {
        return this.quotes.stream().boxed();
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private QuoteScenarioArray(DoubleArray quotes) {
        JodaBeanUtils.notNull((Object)quotes, (String)"quotes");
        this.quotes = quotes;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public DoubleArray getQuotes() {
        return this.quotes;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            QuoteScenarioArray other = (QuoteScenarioArray)obj;
            return JodaBeanUtils.equal((Object)this.quotes, (Object)other.quotes);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.quotes);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(64);
        buf.append("QuoteScenarioArray{");
        buf.append("quotes").append('=').append(JodaBeanUtils.toString((Object)this.quotes));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<QuoteScenarioArray> {
        private DoubleArray quotes;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case -948399753: {
                    return this.quotes;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case -948399753: {
                    this.quotes = (DoubleArray)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public QuoteScenarioArray build() {
            return new QuoteScenarioArray(this.quotes);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(64);
            buf.append("QuoteScenarioArray.Builder{");
            buf.append("quotes").append('=').append(JodaBeanUtils.toString((Object)this.quotes));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<DoubleArray> quotes = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"quotes", QuoteScenarioArray.class, DoubleArray.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"quotes"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case -948399753: {
                    return this.quotes;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends QuoteScenarioArray> builder() {
            return new Builder();
        }

        public Class<? extends QuoteScenarioArray> beanType() {
            return QuoteScenarioArray.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<DoubleArray> quotes() {
            return this.quotes;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case -948399753: {
                    return ((QuoteScenarioArray)bean).getQuotes();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

