/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.observable;

import com.opengamma.strata.basics.StandardId;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.data.FieldName;
import com.opengamma.strata.data.scenario.MarketDataBox;
import com.opengamma.strata.data.scenario.ScenarioMarketDataId;
import com.opengamma.strata.market.observable.QuoteId;
import com.opengamma.strata.market.observable.QuoteScenarioArray;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private", cacheHashCode=true)
public final class QuoteScenarioArrayId
implements ScenarioMarketDataId<Double, QuoteScenarioArray>,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final QuoteId id;
    private static final long serialVersionUID = 1L;
    private transient int cacheHashCode;

    public static QuoteScenarioArrayId of(StandardId id, FieldName fieldName) {
        return new QuoteScenarioArrayId(QuoteId.of(id, fieldName));
    }

    public static QuoteScenarioArrayId of(QuoteId quoteId) {
        return new QuoteScenarioArrayId(quoteId);
    }

    public QuoteId getMarketDataId() {
        return this.id;
    }

    public Class<QuoteScenarioArray> getScenarioMarketDataType() {
        return QuoteScenarioArray.class;
    }

    public QuoteScenarioArray createScenarioValue(MarketDataBox<Double> marketDataBox, int scenarioCount) {
        return QuoteScenarioArray.of(DoubleArray.of((int)scenarioCount, i -> (Double)marketDataBox.getValue(i)));
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private QuoteScenarioArrayId(QuoteId id) {
        JodaBeanUtils.notNull((Object)id, (String)"id");
        this.id = id;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public QuoteId getId() {
        return this.id;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            QuoteScenarioArrayId other = (QuoteScenarioArrayId)obj;
            return JodaBeanUtils.equal((Object)this.id, (Object)other.id);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.cacheHashCode;
        if (hash == 0) {
            hash = this.getClass().hashCode();
            this.cacheHashCode = hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.id);
        }
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(64);
        buf.append("QuoteScenarioArrayId{");
        buf.append("id").append('=').append(JodaBeanUtils.toString((Object)this.id));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<QuoteScenarioArrayId> {
        private QuoteId id;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3355: {
                    return this.id;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 3355: {
                    this.id = (QuoteId)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public QuoteScenarioArrayId build() {
            return new QuoteScenarioArrayId(this.id);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(64);
            buf.append("QuoteScenarioArrayId.Builder{");
            buf.append("id").append('=').append(JodaBeanUtils.toString((Object)this.id));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<QuoteId> id = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"id", QuoteScenarioArrayId.class, QuoteId.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"id"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3355: {
                    return this.id;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends QuoteScenarioArrayId> builder() {
            return new Builder();
        }

        public Class<? extends QuoteScenarioArrayId> beanType() {
            return QuoteScenarioArrayId.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<QuoteId> id() {
            return this.id;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 3355: {
                    return ((QuoteScenarioArrayId)bean).getId();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

