/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.option;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.market.option.Strike;
import com.opengamma.strata.market.option.StrikeType;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class MoneynessStrike
implements Strike,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="ArgChecker.notNegative", overrideGet=true)
    private final double value;
    private static final long serialVersionUID = 1L;

    public static MoneynessStrike of(double moneyness) {
        return new MoneynessStrike(moneyness);
    }

    public static MoneynessStrike ofStrikeAndForward(double strike, double forward) {
        return MoneynessStrike.of(ArgChecker.notNegativeOrZero((double)strike, (String)"strike") / ArgChecker.notNegative((double)forward, (String)"forward"));
    }

    @Override
    public StrikeType getType() {
        return StrikeType.MONEYNESS;
    }

    @Override
    public MoneynessStrike withValue(double value) {
        return new MoneynessStrike(value);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private MoneynessStrike(double value) {
        ArgChecker.notNegative((double)value, (String)"value");
        this.value = value;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public double getValue() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            MoneynessStrike other = (MoneynessStrike)obj;
            return JodaBeanUtils.equal((double)this.value, (double)other.value);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.value);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(64);
        buf.append("MoneynessStrike{");
        buf.append("value").append('=').append(JodaBeanUtils.toString((Object)this.value));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<MoneynessStrike> {
        private double value;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 111972721: {
                    return this.value;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 111972721: {
                    this.value = (Double)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public MoneynessStrike build() {
            return new MoneynessStrike(this.value);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(64);
            buf.append("MoneynessStrike.Builder{");
            buf.append("value").append('=').append(JodaBeanUtils.toString((Object)this.value));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<Double> value = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"value", MoneynessStrike.class, Double.TYPE);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"value"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 111972721: {
                    return this.value;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends MoneynessStrike> builder() {
            return new Builder();
        }

        public Class<? extends MoneynessStrike> beanType() {
            return MoneynessStrike.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<Double> value() {
            return this.value;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 111972721: {
                    return ((MoneynessStrike)bean).getValue();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

