/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.param;

import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableList;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.currency.FxConvertible;
import com.opengamma.strata.basics.currency.FxRateProvider;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.collect.array.DoubleMatrix;
import com.opengamma.strata.collect.tuple.Pair;
import com.opengamma.strata.data.MarketDataName;
import com.opengamma.strata.market.param.CurrencyParameterSensitivity;
import com.opengamma.strata.market.param.ParameterMetadata;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.DoubleUnaryOperator;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableValidator;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class CrossGammaParameterSensitivity
implements FxConvertible<CrossGammaParameterSensitivity>,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final MarketDataName<?> marketDataName;
    @PropertyDefinition(validate="notNull", builderType="List<? extends ParameterMetadata>")
    private final ImmutableList<ParameterMetadata> parameterMetadata;
    @PropertyDefinition(validate="notNull", builderType="List<Pair<MarketDataName<?>, List<? extends ParameterMetadata>>>")
    private final ImmutableList<Pair<MarketDataName<?>, List<? extends ParameterMetadata>>> order;
    @PropertyDefinition(validate="notNull")
    private final Currency currency;
    @PropertyDefinition(validate="notNull")
    private final DoubleMatrix sensitivity;
    private static final long serialVersionUID = 1L;

    public static CrossGammaParameterSensitivity of(MarketDataName<?> marketDataName, List<? extends ParameterMetadata> parameterMetadata, Currency currency, DoubleMatrix sensitivity) {
        return CrossGammaParameterSensitivity.of(marketDataName, parameterMetadata, marketDataName, parameterMetadata, currency, sensitivity);
    }

    public static CrossGammaParameterSensitivity of(MarketDataName<?> marketDataName, List<? extends ParameterMetadata> parameterMetadata, MarketDataName<?> marketDataNameOther, List<? extends ParameterMetadata> parameterMetadataOther, Currency currency, DoubleMatrix sensitivity) {
        return new CrossGammaParameterSensitivity(marketDataName, parameterMetadata, (List<Pair<MarketDataName<?>, List<? extends ParameterMetadata>>>)ImmutableList.of((Object)Pair.of(marketDataNameOther, parameterMetadataOther)), currency, sensitivity);
    }

    public static CrossGammaParameterSensitivity of(MarketDataName<?> marketDataName, List<? extends ParameterMetadata> parameterMetadata, List<Pair<MarketDataName<?>, List<? extends ParameterMetadata>>> order, Currency currency, DoubleMatrix sensitivity) {
        return new CrossGammaParameterSensitivity(marketDataName, parameterMetadata, order, currency, sensitivity);
    }

    @ImmutableValidator
    private void validate() {
        int col = this.sensitivity.columnCount();
        int row = this.sensitivity.rowCount();
        if (row != this.parameterMetadata.size()) {
            throw new IllegalArgumentException("row count of sensitivity and parameter metadata size must match");
        }
        int nParamsTotal = 0;
        for (Pair entry : this.order) {
            nParamsTotal += ((List)entry.getSecond()).size();
        }
        if (col != nParamsTotal) {
            throw new IllegalArgumentException("column count of sensitivity and total parameter metadata size of order must match");
        }
    }

    public int getParameterCount() {
        return this.sensitivity.rowCount();
    }

    public ParameterMetadata getParameterMetadata(int parameterIndex) {
        return (ParameterMetadata)this.parameterMetadata.get(parameterIndex);
    }

    public int compareKey(CrossGammaParameterSensitivity other) {
        return ComparisonChain.start().compare(this.marketDataName, other.marketDataName).compare((Comparable)((Object)this.order.toString()), (Comparable)((Object)other.order.toString())).compare((Comparable)this.currency, (Comparable)other.currency).result();
    }

    public CrossGammaParameterSensitivity convertedTo(Currency resultCurrency, FxRateProvider rateProvider) {
        if (this.currency.equals((Object)resultCurrency)) {
            return this;
        }
        double fxRate = rateProvider.fxRate(this.currency, resultCurrency);
        return this.mapSensitivity(s -> s * fxRate, resultCurrency);
    }

    public CrossGammaParameterSensitivity multipliedBy(double factor) {
        return this.mapSensitivity(s -> s * factor);
    }

    public CrossGammaParameterSensitivity mapSensitivity(DoubleUnaryOperator operator) {
        return this.mapSensitivity(operator, this.currency);
    }

    private CrossGammaParameterSensitivity mapSensitivity(DoubleUnaryOperator operator, Currency currency) {
        return new CrossGammaParameterSensitivity(this.marketDataName, (List<? extends ParameterMetadata>)this.parameterMetadata, (List<Pair<MarketDataName<?>, List<? extends ParameterMetadata>>>)this.order, currency, this.sensitivity.map(operator));
    }

    public CrossGammaParameterSensitivity withSensitivity(DoubleMatrix sensitivity) {
        return new CrossGammaParameterSensitivity(this.marketDataName, (List<? extends ParameterMetadata>)this.parameterMetadata, (List<Pair<MarketDataName<?>, List<? extends ParameterMetadata>>>)this.order, this.currency, sensitivity);
    }

    public CurrencyAmount total() {
        return CurrencyAmount.of((Currency)this.currency, (double)this.sensitivity.total());
    }

    public CurrencyParameterSensitivity diagonal() {
        CrossGammaParameterSensitivity blockDiagonal = this.getSensitivity(this.getMarketDataName());
        int size = this.getParameterCount();
        return CurrencyParameterSensitivity.of(this.getMarketDataName(), this.getParameterMetadata(), this.getCurrency(), DoubleArray.of((int)size, i -> blockDiagonal.getSensitivity().get(i, i)));
    }

    public CrossGammaParameterSensitivity getSensitivity(MarketDataName<?> name) {
        Pair<Integer, List<? extends ParameterMetadata>> indexAndMetadata = this.findStartIndexAndMetadata(name);
        int startIndex = (Integer)indexAndMetadata.getFirst();
        int rowCt = this.getParameterCount();
        int colCt = ((List)indexAndMetadata.getSecond()).size();
        double[][] sensi = new double[rowCt][colCt];
        for (int i = 0; i < rowCt; ++i) {
            System.arraycopy(this.getSensitivity().rowArray(i), startIndex, sensi[i], 0, colCt);
        }
        return CrossGammaParameterSensitivity.of(this.getMarketDataName(), this.getParameterMetadata(), name, (List)indexAndMetadata.getSecond(), this.getCurrency(), DoubleMatrix.ofUnsafe((double[][])sensi));
    }

    private Pair<Integer, List<? extends ParameterMetadata>> findStartIndexAndMetadata(MarketDataName<?> name) {
        int startIndex = 0;
        for (Pair entry : this.order) {
            if (((MarketDataName)entry.getFirst()).equals(name)) {
                return Pair.of((Object)startIndex, (Object)entry.getSecond());
            }
            startIndex += ((List)entry.getSecond()).size();
        }
        throw new IllegalArgumentException(Messages.format((String)"Unable to find sensitivity: {} and {}", (Object[])new Object[]{this.marketDataName, name}));
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private CrossGammaParameterSensitivity(MarketDataName<?> marketDataName, List<? extends ParameterMetadata> parameterMetadata, List<Pair<MarketDataName<?>, List<? extends ParameterMetadata>>> order, Currency currency, DoubleMatrix sensitivity) {
        JodaBeanUtils.notNull(marketDataName, (String)"marketDataName");
        JodaBeanUtils.notNull(parameterMetadata, (String)"parameterMetadata");
        JodaBeanUtils.notNull(order, (String)"order");
        JodaBeanUtils.notNull((Object)currency, (String)"currency");
        JodaBeanUtils.notNull((Object)sensitivity, (String)"sensitivity");
        this.marketDataName = marketDataName;
        this.parameterMetadata = ImmutableList.copyOf(parameterMetadata);
        this.order = ImmutableList.copyOf(order);
        this.currency = currency;
        this.sensitivity = sensitivity;
        this.validate();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public MarketDataName<?> getMarketDataName() {
        return this.marketDataName;
    }

    public ImmutableList<ParameterMetadata> getParameterMetadata() {
        return this.parameterMetadata;
    }

    public ImmutableList<Pair<MarketDataName<?>, List<? extends ParameterMetadata>>> getOrder() {
        return this.order;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public DoubleMatrix getSensitivity() {
        return this.sensitivity;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            CrossGammaParameterSensitivity other = (CrossGammaParameterSensitivity)obj;
            return JodaBeanUtils.equal(this.marketDataName, other.marketDataName) && JodaBeanUtils.equal(this.parameterMetadata, other.parameterMetadata) && JodaBeanUtils.equal(this.order, other.order) && JodaBeanUtils.equal((Object)this.currency, (Object)other.currency) && JodaBeanUtils.equal((Object)this.sensitivity, (Object)other.sensitivity);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode(this.marketDataName);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.parameterMetadata);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.order);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.currency);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.sensitivity);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(192);
        buf.append("CrossGammaParameterSensitivity{");
        buf.append("marketDataName").append('=').append(JodaBeanUtils.toString(this.marketDataName)).append(',').append(' ');
        buf.append("parameterMetadata").append('=').append(JodaBeanUtils.toString(this.parameterMetadata)).append(',').append(' ');
        buf.append("order").append('=').append(JodaBeanUtils.toString(this.order)).append(',').append(' ');
        buf.append("currency").append('=').append(JodaBeanUtils.toString((Object)this.currency)).append(',').append(' ');
        buf.append("sensitivity").append('=').append(JodaBeanUtils.toString((Object)this.sensitivity));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<CrossGammaParameterSensitivity> {
        private MarketDataName<?> marketDataName;
        private List<? extends ParameterMetadata> parameterMetadata = ImmutableList.of();
        private List<Pair<MarketDataName<?>, List<? extends ParameterMetadata>>> order = ImmutableList.of();
        private Currency currency;
        private DoubleMatrix sensitivity;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 842855857: {
                    return this.marketDataName;
                }
                case -1169106440: {
                    return this.parameterMetadata;
                }
                case 106006350: {
                    return this.order;
                }
                case 575402001: {
                    return this.currency;
                }
                case 564403871: {
                    return this.sensitivity;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 842855857: {
                    this.marketDataName = (MarketDataName)newValue;
                    break;
                }
                case -1169106440: {
                    this.parameterMetadata = (List)newValue;
                    break;
                }
                case 106006350: {
                    this.order = (List)newValue;
                    break;
                }
                case 575402001: {
                    this.currency = (Currency)newValue;
                    break;
                }
                case 564403871: {
                    this.sensitivity = (DoubleMatrix)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public CrossGammaParameterSensitivity build() {
            return new CrossGammaParameterSensitivity(this.marketDataName, this.parameterMetadata, this.order, this.currency, this.sensitivity);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(192);
            buf.append("CrossGammaParameterSensitivity.Builder{");
            buf.append("marketDataName").append('=').append(JodaBeanUtils.toString(this.marketDataName)).append(',').append(' ');
            buf.append("parameterMetadata").append('=').append(JodaBeanUtils.toString(this.parameterMetadata)).append(',').append(' ');
            buf.append("order").append('=').append(JodaBeanUtils.toString(this.order)).append(',').append(' ');
            buf.append("currency").append('=').append(JodaBeanUtils.toString((Object)this.currency)).append(',').append(' ');
            buf.append("sensitivity").append('=').append(JodaBeanUtils.toString((Object)this.sensitivity));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<MarketDataName<?>> marketDataName = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"marketDataName", CrossGammaParameterSensitivity.class, MarketDataName.class);
        private final MetaProperty<ImmutableList<ParameterMetadata>> parameterMetadata = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"parameterMetadata", CrossGammaParameterSensitivity.class, ImmutableList.class);
        private final MetaProperty<ImmutableList<Pair<MarketDataName<?>, List<? extends ParameterMetadata>>>> order = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"order", CrossGammaParameterSensitivity.class, ImmutableList.class);
        private final MetaProperty<Currency> currency = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"currency", CrossGammaParameterSensitivity.class, Currency.class);
        private final MetaProperty<DoubleMatrix> sensitivity = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"sensitivity", CrossGammaParameterSensitivity.class, DoubleMatrix.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"marketDataName", "parameterMetadata", "order", "currency", "sensitivity"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 842855857: {
                    return this.marketDataName;
                }
                case -1169106440: {
                    return this.parameterMetadata;
                }
                case 106006350: {
                    return this.order;
                }
                case 575402001: {
                    return this.currency;
                }
                case 564403871: {
                    return this.sensitivity;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends CrossGammaParameterSensitivity> builder() {
            return new Builder();
        }

        public Class<? extends CrossGammaParameterSensitivity> beanType() {
            return CrossGammaParameterSensitivity.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<MarketDataName<?>> marketDataName() {
            return this.marketDataName;
        }

        public MetaProperty<ImmutableList<ParameterMetadata>> parameterMetadata() {
            return this.parameterMetadata;
        }

        public MetaProperty<ImmutableList<Pair<MarketDataName<?>, List<? extends ParameterMetadata>>>> order() {
            return this.order;
        }

        public MetaProperty<Currency> currency() {
            return this.currency;
        }

        public MetaProperty<DoubleMatrix> sensitivity() {
            return this.sensitivity;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 842855857: {
                    return ((CrossGammaParameterSensitivity)bean).getMarketDataName();
                }
                case -1169106440: {
                    return ((CrossGammaParameterSensitivity)bean).getParameterMetadata();
                }
                case 106006350: {
                    return ((CrossGammaParameterSensitivity)bean).getOrder();
                }
                case 575402001: {
                    return ((CrossGammaParameterSensitivity)bean).getCurrency();
                }
                case 564403871: {
                    return ((CrossGammaParameterSensitivity)bean).getSensitivity();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

