/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.param;

import com.google.common.collect.ImmutableList;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.currency.FxConvertible;
import com.opengamma.strata.basics.currency.FxRateProvider;
import com.opengamma.strata.basics.currency.MultiCurrencyAmount;
import com.opengamma.strata.collect.Guavate;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.data.MarketDataName;
import com.opengamma.strata.market.param.CurrencyParameterSensitivitiesBuilder;
import com.opengamma.strata.market.param.CurrencyParameterSensitivity;
import com.opengamma.strata.market.param.ParameterMetadata;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableConstructor;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class CurrencyParameterSensitivities
implements FxConvertible<CurrencyParameterSensitivities>,
ImmutableBean,
Serializable {
    private static final CurrencyParameterSensitivities EMPTY = new CurrencyParameterSensitivities((ImmutableList<CurrencyParameterSensitivity>)ImmutableList.of());
    @PropertyDefinition(validate="notNull")
    private final ImmutableList<CurrencyParameterSensitivity> sensitivities;
    private static final long serialVersionUID = 1L;

    public static CurrencyParameterSensitivities empty() {
        return EMPTY;
    }

    public static CurrencyParameterSensitivitiesBuilder builder() {
        return new CurrencyParameterSensitivitiesBuilder();
    }

    public static CurrencyParameterSensitivities of(CurrencyParameterSensitivity sensitivity) {
        return new CurrencyParameterSensitivities((ImmutableList<CurrencyParameterSensitivity>)ImmutableList.of((Object)sensitivity));
    }

    public static CurrencyParameterSensitivities of(CurrencyParameterSensitivity ... sensitivities) {
        return CurrencyParameterSensitivities.of(Arrays.asList(sensitivities));
    }

    public static CurrencyParameterSensitivities of(List<? extends CurrencyParameterSensitivity> sensitivities) {
        ArrayList<CurrencyParameterSensitivity> mutable = new ArrayList<CurrencyParameterSensitivity>();
        for (CurrencyParameterSensitivity currencyParameterSensitivity : sensitivities) {
            CurrencyParameterSensitivities.insert(mutable, currencyParameterSensitivity);
        }
        return new CurrencyParameterSensitivities((ImmutableList<CurrencyParameterSensitivity>)ImmutableList.copyOf(mutable));
    }

    @ImmutableConstructor
    private CurrencyParameterSensitivities(List<? extends CurrencyParameterSensitivity> sensitivities) {
        if (sensitivities.size() < 2) {
            this.sensitivities = ImmutableList.copyOf(sensitivities);
        } else {
            ArrayList<? extends CurrencyParameterSensitivity> mutable = new ArrayList<CurrencyParameterSensitivity>(sensitivities);
            mutable.sort(CurrencyParameterSensitivity::compareKey);
            this.sensitivities = ImmutableList.copyOf(mutable);
        }
    }

    private CurrencyParameterSensitivities(ImmutableList<CurrencyParameterSensitivity> sensitivities) {
        this.sensitivities = sensitivities;
    }

    public int size() {
        return this.sensitivities.size();
    }

    public CurrencyParameterSensitivity getSensitivity(MarketDataName<?> name, Currency currency) {
        return this.findSensitivity(name, currency).orElseThrow(() -> new IllegalArgumentException(Messages.format((String)"Unable to find sensitivity: {} for {}", (Object[])new Object[]{name, currency})));
    }

    public Optional<CurrencyParameterSensitivity> findSensitivity(MarketDataName<?> name, Currency currency) {
        return this.sensitivities.stream().filter(sens -> sens.getMarketDataName().equals((Object)name) && sens.getCurrency().equals((Object)currency)).findFirst();
    }

    public CurrencyParameterSensitivities combinedWith(CurrencyParameterSensitivity other) {
        ArrayList<CurrencyParameterSensitivity> mutable = new ArrayList<CurrencyParameterSensitivity>((Collection<CurrencyParameterSensitivity>)this.sensitivities);
        CurrencyParameterSensitivities.insert(mutable, other);
        return new CurrencyParameterSensitivities((ImmutableList<CurrencyParameterSensitivity>)ImmutableList.copyOf(mutable));
    }

    public CurrencyParameterSensitivities combinedWith(CurrencyParameterSensitivities other) {
        ArrayList<CurrencyParameterSensitivity> mutable = new ArrayList<CurrencyParameterSensitivity>((Collection<CurrencyParameterSensitivity>)this.sensitivities);
        for (CurrencyParameterSensitivity otherSens : other.sensitivities) {
            CurrencyParameterSensitivities.insert(mutable, otherSens);
        }
        return new CurrencyParameterSensitivities((ImmutableList<CurrencyParameterSensitivity>)ImmutableList.copyOf(mutable));
    }

    private static void insert(List<CurrencyParameterSensitivity> mutable, CurrencyParameterSensitivity addition) {
        int index = Collections.binarySearch(mutable, addition, CurrencyParameterSensitivity::compareKey);
        if (index >= 0) {
            CurrencyParameterSensitivity base = mutable.get(index);
            DoubleArray combined = base.getSensitivity().plus(addition.getSensitivity());
            mutable.set(index, base.withSensitivity(combined));
        } else {
            int insertionPoint = -(index + 1);
            mutable.add(insertionPoint, addition);
        }
    }

    public CurrencyParameterSensitivities mergedWith(CurrencyParameterSensitivities other) {
        return this.toBuilder().add(other).build();
    }

    public CurrencyParameterSensitivities withMarketDataNames(Function<MarketDataName<?>, MarketDataName<?>> nameFn) {
        CurrencyParameterSensitivitiesBuilder builder = CurrencyParameterSensitivities.builder();
        for (CurrencyParameterSensitivity sensitivity : this.sensitivities) {
            builder.add(sensitivity.toBuilder().marketDataName(nameFn.apply(sensitivity.getMarketDataName())).build());
        }
        return builder.build();
    }

    public CurrencyParameterSensitivities withParameterMetadatas(UnaryOperator<ParameterMetadata> mdFn) {
        return this.toBuilder().mapMetadata(mdFn).build();
    }

    public CurrencyParameterSensitivities convertedTo(Currency resultCurrency, FxRateProvider rateProvider) {
        ArrayList<CurrencyParameterSensitivity> mutable = new ArrayList<CurrencyParameterSensitivity>();
        for (CurrencyParameterSensitivity sens : this.sensitivities) {
            CurrencyParameterSensitivities.insert(mutable, sens.convertedTo(resultCurrency, rateProvider));
        }
        return new CurrencyParameterSensitivities((ImmutableList<CurrencyParameterSensitivity>)ImmutableList.copyOf(mutable));
    }

    public CurrencyParameterSensitivities split() {
        if (!this.sensitivities.stream().anyMatch(s -> s.getParameterSplit().isPresent())) {
            return this;
        }
        return CurrencyParameterSensitivities.of((List)this.sensitivities.stream().flatMap(s -> s.split().stream()).collect(Guavate.toImmutableList()));
    }

    public CurrencyAmount total(Currency resultCurrency, FxRateProvider rateProvider) {
        CurrencyParameterSensitivities converted = this.convertedTo(resultCurrency, rateProvider);
        double total = converted.sensitivities.stream().mapToDouble(s -> s.getSensitivity().sum()).sum();
        return CurrencyAmount.of((Currency)resultCurrency, (double)total);
    }

    public MultiCurrencyAmount total() {
        return (MultiCurrencyAmount)this.sensitivities.stream().map(CurrencyParameterSensitivity::total).collect(MultiCurrencyAmount.toMultiCurrencyAmount());
    }

    public CurrencyParameterSensitivities multipliedBy(double factor) {
        return this.mapSensitivities(s -> s * factor);
    }

    public CurrencyParameterSensitivities mapSensitivities(DoubleUnaryOperator operator) {
        return this.sensitivities.stream().map(s -> s.mapSensitivity(operator)).collect(Collectors.collectingAndThen(Guavate.toImmutableList(), CurrencyParameterSensitivities::new));
    }

    public boolean equalWithTolerance(CurrencyParameterSensitivities other, double tolerance) {
        ArrayList<CurrencyParameterSensitivity> mutable = new ArrayList<CurrencyParameterSensitivity>((Collection<CurrencyParameterSensitivity>)other.sensitivities);
        for (CurrencyParameterSensitivity sens1 : this.sensitivities) {
            int index = Collections.binarySearch(mutable, sens1, CurrencyParameterSensitivity::compareKey);
            if (index >= 0) {
                CurrencyParameterSensitivity sens2 = (CurrencyParameterSensitivity)mutable.get(index);
                if (!sens1.getSensitivity().equalWithTolerance(sens2.getSensitivity(), tolerance)) {
                    return false;
                }
                mutable.remove(index);
                continue;
            }
            if (sens1.getSensitivity().equalZeroWithTolerance(tolerance)) continue;
            return false;
        }
        for (CurrencyParameterSensitivity sens2 : mutable) {
            if (sens2.getSensitivity().equalZeroWithTolerance(tolerance)) continue;
            return false;
        }
        return true;
    }

    public CurrencyParameterSensitivitiesBuilder toBuilder() {
        return new CurrencyParameterSensitivitiesBuilder((List<CurrencyParameterSensitivity>)this.sensitivities);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public ImmutableList<CurrencyParameterSensitivity> getSensitivities() {
        return this.sensitivities;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            CurrencyParameterSensitivities other = (CurrencyParameterSensitivities)obj;
            return JodaBeanUtils.equal(this.sensitivities, other.sensitivities);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode(this.sensitivities);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(64);
        buf.append("CurrencyParameterSensitivities{");
        buf.append("sensitivities").append('=').append(JodaBeanUtils.toString(this.sensitivities));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<CurrencyParameterSensitivities> {
        private List<CurrencyParameterSensitivity> sensitivities = ImmutableList.of();

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 1226228605: {
                    return this.sensitivities;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 1226228605: {
                    this.sensitivities = (List)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public CurrencyParameterSensitivities build() {
            return new CurrencyParameterSensitivities(this.sensitivities);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(64);
            buf.append("CurrencyParameterSensitivities.Builder{");
            buf.append("sensitivities").append('=').append(JodaBeanUtils.toString(this.sensitivities));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<ImmutableList<CurrencyParameterSensitivity>> sensitivities = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"sensitivities", CurrencyParameterSensitivities.class, ImmutableList.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"sensitivities"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 1226228605: {
                    return this.sensitivities;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends CurrencyParameterSensitivities> builder() {
            return new Builder();
        }

        public Class<? extends CurrencyParameterSensitivities> beanType() {
            return CurrencyParameterSensitivities.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<ImmutableList<CurrencyParameterSensitivity>> sensitivities() {
            return this.sensitivities;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 1226228605: {
                    return ((CurrencyParameterSensitivities)bean).getSensitivities();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

