/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.param;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.collect.Guavate;
import com.opengamma.strata.collect.tuple.Pair;
import com.opengamma.strata.data.MarketDataName;
import com.opengamma.strata.market.param.CurrencyParameterSensitivities;
import com.opengamma.strata.market.param.CurrencyParameterSensitivity;
import com.opengamma.strata.market.param.CurrencyParameterSensitivityBuilder;
import com.opengamma.strata.market.param.ParameterMetadata;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.BiFunction;
import java.util.function.DoublePredicate;
import java.util.function.UnaryOperator;

public final class CurrencyParameterSensitivitiesBuilder {
    private final SortedMap<Pair<MarketDataName<?>, Currency>, CurrencyParameterSensitivityBuilder> data = new TreeMap();

    CurrencyParameterSensitivitiesBuilder() {
    }

    CurrencyParameterSensitivitiesBuilder(List<CurrencyParameterSensitivity> sensitivities) {
        sensitivities.forEach(this::add);
    }

    public CurrencyParameterSensitivitiesBuilder add(CurrencyParameterSensitivities sensitivities) {
        return this.add((List<CurrencyParameterSensitivity>)sensitivities.getSensitivities());
    }

    public CurrencyParameterSensitivitiesBuilder add(List<CurrencyParameterSensitivity> sensitivities) {
        sensitivities.forEach(this::add);
        return this;
    }

    public CurrencyParameterSensitivitiesBuilder add(CurrencyParameterSensitivity sensToAdd) {
        sensToAdd.sensitivities().forEach((md, value) -> this.add(sensToAdd.getMarketDataName(), sensToAdd.getCurrency(), (ParameterMetadata)md, (double)value));
        return this;
    }

    public CurrencyParameterSensitivitiesBuilder add(MarketDataName<?> marketDataName, Currency currency, ParameterMetadata metadata, double sensitivityValue) {
        this.data.computeIfAbsent(Pair.of(marketDataName, (Object)currency), t -> new CurrencyParameterSensitivityBuilder(marketDataName, currency)).add(metadata, sensitivityValue);
        return this;
    }

    public CurrencyParameterSensitivitiesBuilder mapMetadata(UnaryOperator<ParameterMetadata> metadataFn) {
        for (CurrencyParameterSensitivityBuilder builder : this.data.values()) {
            builder.mapMetadata(metadataFn);
        }
        return this;
    }

    public CurrencyParameterSensitivitiesBuilder mapSensitivities(BiFunction<ParameterMetadata, Double, Double> mapFn) {
        for (CurrencyParameterSensitivityBuilder builder : this.data.values()) {
            builder.mapSensitivity(mapFn);
        }
        return this;
    }

    public CurrencyParameterSensitivitiesBuilder filterSensitivity(DoublePredicate predicate) {
        Iterator<CurrencyParameterSensitivityBuilder> it = this.data.values().iterator();
        while (it.hasNext()) {
            CurrencyParameterSensitivityBuilder builder = it.next();
            builder.filterSensitivity(predicate);
            if (!builder.isEmpty()) continue;
            it.remove();
        }
        return this;
    }

    public CurrencyParameterSensitivities build() {
        return CurrencyParameterSensitivities.of((List)this.data.values().stream().map(CurrencyParameterSensitivityBuilder::build).sorted(CurrencyParameterSensitivity::compareKey).collect(Guavate.toImmutableList()));
    }
}

