/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.param;

import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.currency.FxConvertible;
import com.opengamma.strata.basics.currency.FxRateProvider;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.Guavate;
import com.opengamma.strata.collect.MapStream;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.data.MarketDataName;
import com.opengamma.strata.market.param.ParameterMetadata;
import com.opengamma.strata.market.param.ParameterSize;
import com.opengamma.strata.market.param.UnitParameterSensitivity;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.DoubleUnaryOperator;
import java.util.stream.Stream;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableValidator;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class CurrencyParameterSensitivity
implements FxConvertible<CurrencyParameterSensitivity>,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final MarketDataName<?> marketDataName;
    @PropertyDefinition(validate="notNull", builderType="List<? extends ParameterMetadata>")
    private final ImmutableList<ParameterMetadata> parameterMetadata;
    @PropertyDefinition(validate="notNull")
    private final Currency currency;
    @PropertyDefinition(validate="notNull")
    private final DoubleArray sensitivity;
    @PropertyDefinition(get="optional", type="List<>")
    private final ImmutableList<ParameterSize> parameterSplit;
    private static final long serialVersionUID = 1L;

    public static CurrencyParameterSensitivity of(MarketDataName<?> marketDataName, List<? extends ParameterMetadata> parameterMetadata, Currency currency, DoubleArray sensitivity) {
        return new CurrencyParameterSensitivity(marketDataName, parameterMetadata, currency, sensitivity, null);
    }

    public static CurrencyParameterSensitivity of(MarketDataName<?> marketDataName, Currency currency, DoubleArray sensitivity) {
        return CurrencyParameterSensitivity.of(marketDataName, ParameterMetadata.listOfEmpty(sensitivity.size()), currency, sensitivity);
    }

    public static CurrencyParameterSensitivity of(MarketDataName<?> marketDataName, List<? extends ParameterMetadata> parameterMetadata, Currency currency, DoubleArray sensitivity, List<ParameterSize> parameterSplit) {
        return new CurrencyParameterSensitivity(marketDataName, parameterMetadata, currency, sensitivity, parameterSplit);
    }

    public static CurrencyParameterSensitivity of(MarketDataName<?> marketDataName, Currency currency, Map<? extends ParameterMetadata, Double> sensitivityMetadataMap) {
        ImmutableList.Builder metadataList = ImmutableList.builder();
        ImmutableList.Builder sensList = ImmutableList.builder();
        for (Map.Entry<? extends ParameterMetadata, Double> entry : sensitivityMetadataMap.entrySet()) {
            metadataList.add((Object)entry.getKey());
            sensList.add((Object)entry.getValue());
        }
        DoubleArray sensArray = DoubleArray.copyOf((Collection)sensList.build());
        return new CurrencyParameterSensitivity(marketDataName, (List<? extends ParameterMetadata>)metadataList.build(), currency, sensArray, null);
    }

    public static CurrencyParameterSensitivity combine(MarketDataName<?> marketDataName, CurrencyParameterSensitivity ... sensitivities) {
        CurrencyParameterSensitivity first;
        ArgChecker.notEmpty((Object[])sensitivities, (String)"sensitivities");
        Currency currency = Stream.of(sensitivities).map(s -> s.getCurrency()).distinct().reduce(Guavate.ensureOnlyOne()).get();
        int size = Stream.of(sensitivities).mapToInt(s -> s.getParameterCount()).sum();
        if (sensitivities.length == 1 && (first = sensitivities[0]).getMarketDataName().equals(marketDataName)) {
            return first;
        }
        double[] combinedSensitivities = new double[size];
        ImmutableList.Builder combinedMeta = ImmutableList.builder();
        ImmutableList.Builder split = ImmutableList.builder();
        int count = 0;
        for (int i = 0; i < sensitivities.length; ++i) {
            CurrencyParameterSensitivity sens = sensitivities[i];
            if (sens.getParameterCount() == 0) continue;
            System.arraycopy(sens.getSensitivity().toArrayUnsafe(), 0, combinedSensitivities, count, sens.getParameterCount());
            combinedMeta.addAll(sens.getParameterMetadata());
            split.add((Object)ParameterSize.of(sens.getMarketDataName(), sens.getParameterCount()));
            count += sens.getParameterCount();
        }
        ImmutableList parameterSplit = split.build();
        return new CurrencyParameterSensitivity(marketDataName, (List<? extends ParameterMetadata>)combinedMeta.build(), currency, DoubleArray.ofUnsafe((double[])combinedSensitivities), (List<ParameterSize>)(parameterSplit.isEmpty() ? null : parameterSplit));
    }

    @ImmutableValidator
    private void validate() {
        if (this.sensitivity.size() != this.parameterMetadata.size()) {
            throw new IllegalArgumentException("Length of sensitivity and parameter metadata must match");
        }
        if (this.parameterSplit != null) {
            long total = this.parameterSplit.stream().mapToInt(p -> p.getParameterCount()).sum();
            if ((long)this.sensitivity.size() != total) {
                throw new IllegalArgumentException("Length of sensitivity and parameter split must match");
            }
            if (this.parameterSplit.stream().map(p -> p.getName()).distinct().count() != (long)this.parameterSplit.size()) {
                throw new IllegalArgumentException("Parameter split must not contain duplicate market data names");
            }
        }
    }

    public int getParameterCount() {
        return this.sensitivity.size();
    }

    public ParameterMetadata getParameterMetadata(int parameterIndex) {
        return (ParameterMetadata)this.parameterMetadata.get(parameterIndex);
    }

    public int compareKey(CurrencyParameterSensitivity other) {
        return ComparisonChain.start().compare(this.marketDataName, other.marketDataName).compare((Comparable)this.currency, (Comparable)other.currency).result();
    }

    public CurrencyParameterSensitivity convertedTo(Currency resultCurrency, FxRateProvider rateProvider) {
        if (this.currency.equals((Object)resultCurrency)) {
            return this;
        }
        double fxRate = rateProvider.fxRate(this.currency, resultCurrency);
        return this.mapSensitivity(s -> s * fxRate, resultCurrency);
    }

    public CurrencyParameterSensitivity multipliedBy(double factor) {
        return this.mapSensitivity(s -> s * factor);
    }

    public CurrencyParameterSensitivity mapSensitivity(DoubleUnaryOperator operator) {
        return this.mapSensitivity(operator, this.currency);
    }

    private CurrencyParameterSensitivity mapSensitivity(DoubleUnaryOperator operator, Currency currency) {
        return new CurrencyParameterSensitivity(this.marketDataName, (List<? extends ParameterMetadata>)this.parameterMetadata, currency, this.sensitivity.map(operator), (List<ParameterSize>)this.parameterSplit);
    }

    public CurrencyParameterSensitivity withSensitivity(DoubleArray sensitivity) {
        return new CurrencyParameterSensitivity(this.marketDataName, (List<? extends ParameterMetadata>)this.parameterMetadata, this.currency, sensitivity, (List<ParameterSize>)this.parameterSplit);
    }

    public CurrencyParameterSensitivity plus(DoubleArray otherSensitivty) {
        if (otherSensitivty.size() != this.sensitivity.size()) {
            throw new IllegalArgumentException(Messages.format((String)"Sensitivity array size {} must match size {}", (Object[])new Object[]{otherSensitivty.size(), this.sensitivity.size()}));
        }
        return this.withSensitivity(this.sensitivity.plus(otherSensitivty));
    }

    public CurrencyParameterSensitivity plus(CurrencyParameterSensitivity otherSensitivty) {
        if (!this.marketDataName.equals(otherSensitivty.marketDataName) || !this.parameterMetadata.equals(otherSensitivty.parameterMetadata) || !this.currency.equals((Object)otherSensitivty.currency) || this.parameterSplit != null && !this.parameterSplit.equals(otherSensitivty.parameterSplit)) {
            throw new IllegalArgumentException("Two sensitivity instances can only be added if name, metadata and split are equal");
        }
        return this.plus(otherSensitivty.getSensitivity());
    }

    public ImmutableList<CurrencyParameterSensitivity> split() {
        if (this.parameterSplit == null) {
            return ImmutableList.of((Object)this);
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        int count = 0;
        for (ParameterSize size : this.parameterSplit) {
            ImmutableList splitMetadata = this.parameterMetadata.subList(count, count + size.getParameterCount());
            DoubleArray splitSensitivity = this.sensitivity.subArray(count, count + size.getParameterCount());
            builder.add((Object)CurrencyParameterSensitivity.of(size.getName(), (List<? extends ParameterMetadata>)splitMetadata, this.currency, splitSensitivity));
            count += size.getParameterCount();
        }
        return builder.build();
    }

    public CurrencyAmount total() {
        return CurrencyAmount.of((Currency)this.currency, (double)this.sensitivity.sum());
    }

    public MapStream<ParameterMetadata, Double> sensitivities() {
        return MapStream.zip((Stream)this.parameterMetadata.stream(), this.sensitivity.stream().boxed());
    }

    public <T> ImmutableMap<T, Double> toSensitivityMap(Class<T> identifierType) {
        return this.sensitivities().mapKeys(k -> identifierType.cast(k.getIdentifier())).toMap();
    }

    public UnitParameterSensitivity toUnitParameterSensitivity() {
        return UnitParameterSensitivity.of(this.marketDataName, this.parameterMetadata, this.sensitivity, this.parameterSplit);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private CurrencyParameterSensitivity(MarketDataName<?> marketDataName, List<? extends ParameterMetadata> parameterMetadata, Currency currency, DoubleArray sensitivity, List<ParameterSize> parameterSplit) {
        JodaBeanUtils.notNull(marketDataName, (String)"marketDataName");
        JodaBeanUtils.notNull(parameterMetadata, (String)"parameterMetadata");
        JodaBeanUtils.notNull((Object)currency, (String)"currency");
        JodaBeanUtils.notNull((Object)sensitivity, (String)"sensitivity");
        this.marketDataName = marketDataName;
        this.parameterMetadata = ImmutableList.copyOf(parameterMetadata);
        this.currency = currency;
        this.sensitivity = sensitivity;
        this.parameterSplit = parameterSplit != null ? ImmutableList.copyOf(parameterSplit) : null;
        this.validate();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public MarketDataName<?> getMarketDataName() {
        return this.marketDataName;
    }

    public ImmutableList<ParameterMetadata> getParameterMetadata() {
        return this.parameterMetadata;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public DoubleArray getSensitivity() {
        return this.sensitivity;
    }

    public Optional<List<ParameterSize>> getParameterSplit() {
        return Optional.ofNullable(this.parameterSplit);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            CurrencyParameterSensitivity other = (CurrencyParameterSensitivity)obj;
            return JodaBeanUtils.equal(this.marketDataName, other.marketDataName) && JodaBeanUtils.equal(this.parameterMetadata, other.parameterMetadata) && JodaBeanUtils.equal((Object)this.currency, (Object)other.currency) && JodaBeanUtils.equal((Object)this.sensitivity, (Object)other.sensitivity) && JodaBeanUtils.equal(this.parameterSplit, other.parameterSplit);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode(this.marketDataName);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.parameterMetadata);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.currency);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.sensitivity);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.parameterSplit);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(192);
        buf.append("CurrencyParameterSensitivity{");
        buf.append("marketDataName").append('=').append(JodaBeanUtils.toString(this.marketDataName)).append(',').append(' ');
        buf.append("parameterMetadata").append('=').append(JodaBeanUtils.toString(this.parameterMetadata)).append(',').append(' ');
        buf.append("currency").append('=').append(JodaBeanUtils.toString((Object)this.currency)).append(',').append(' ');
        buf.append("sensitivity").append('=').append(JodaBeanUtils.toString((Object)this.sensitivity)).append(',').append(' ');
        buf.append("parameterSplit").append('=').append(JodaBeanUtils.toString(this.parameterSplit));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<CurrencyParameterSensitivity> {
        private MarketDataName<?> marketDataName;
        private List<? extends ParameterMetadata> parameterMetadata = ImmutableList.of();
        private Currency currency;
        private DoubleArray sensitivity;
        private List<ParameterSize> parameterSplit;

        private Builder() {
        }

        private Builder(CurrencyParameterSensitivity beanToCopy) {
            this.marketDataName = beanToCopy.getMarketDataName();
            this.parameterMetadata = beanToCopy.getParameterMetadata();
            this.currency = beanToCopy.getCurrency();
            this.sensitivity = beanToCopy.getSensitivity();
            this.parameterSplit = beanToCopy.parameterSplit;
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 842855857: {
                    return this.marketDataName;
                }
                case -1169106440: {
                    return this.parameterMetadata;
                }
                case 575402001: {
                    return this.currency;
                }
                case 564403871: {
                    return this.sensitivity;
                }
                case 1122130161: {
                    return this.parameterSplit;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 842855857: {
                    this.marketDataName = (MarketDataName)newValue;
                    break;
                }
                case -1169106440: {
                    this.parameterMetadata = (List)newValue;
                    break;
                }
                case 575402001: {
                    this.currency = (Currency)newValue;
                    break;
                }
                case 564403871: {
                    this.sensitivity = (DoubleArray)newValue;
                    break;
                }
                case 1122130161: {
                    this.parameterSplit = (List)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public CurrencyParameterSensitivity build() {
            return new CurrencyParameterSensitivity(this.marketDataName, this.parameterMetadata, this.currency, this.sensitivity, this.parameterSplit);
        }

        public Builder marketDataName(MarketDataName<?> marketDataName) {
            JodaBeanUtils.notNull(marketDataName, (String)"marketDataName");
            this.marketDataName = marketDataName;
            return this;
        }

        public Builder parameterMetadata(List<? extends ParameterMetadata> parameterMetadata) {
            JodaBeanUtils.notNull(parameterMetadata, (String)"parameterMetadata");
            this.parameterMetadata = parameterMetadata;
            return this;
        }

        public Builder parameterMetadata(ParameterMetadata ... parameterMetadata) {
            return this.parameterMetadata((List<? extends ParameterMetadata>)ImmutableList.copyOf((Object[])parameterMetadata));
        }

        public Builder currency(Currency currency) {
            JodaBeanUtils.notNull((Object)currency, (String)"currency");
            this.currency = currency;
            return this;
        }

        public Builder sensitivity(DoubleArray sensitivity) {
            JodaBeanUtils.notNull((Object)sensitivity, (String)"sensitivity");
            this.sensitivity = sensitivity;
            return this;
        }

        public Builder parameterSplit(List<ParameterSize> parameterSplit) {
            this.parameterSplit = parameterSplit;
            return this;
        }

        public Builder parameterSplit(ParameterSize ... parameterSplit) {
            return this.parameterSplit((List<ParameterSize>)ImmutableList.copyOf((Object[])parameterSplit));
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(192);
            buf.append("CurrencyParameterSensitivity.Builder{");
            buf.append("marketDataName").append('=').append(JodaBeanUtils.toString(this.marketDataName)).append(',').append(' ');
            buf.append("parameterMetadata").append('=').append(JodaBeanUtils.toString(this.parameterMetadata)).append(',').append(' ');
            buf.append("currency").append('=').append(JodaBeanUtils.toString((Object)this.currency)).append(',').append(' ');
            buf.append("sensitivity").append('=').append(JodaBeanUtils.toString((Object)this.sensitivity)).append(',').append(' ');
            buf.append("parameterSplit").append('=').append(JodaBeanUtils.toString(this.parameterSplit));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<MarketDataName<?>> marketDataName = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"marketDataName", CurrencyParameterSensitivity.class, MarketDataName.class);
        private final MetaProperty<ImmutableList<ParameterMetadata>> parameterMetadata = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"parameterMetadata", CurrencyParameterSensitivity.class, ImmutableList.class);
        private final MetaProperty<Currency> currency = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"currency", CurrencyParameterSensitivity.class, Currency.class);
        private final MetaProperty<DoubleArray> sensitivity = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"sensitivity", CurrencyParameterSensitivity.class, DoubleArray.class);
        private final MetaProperty<List<ParameterSize>> parameterSplit = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"parameterSplit", CurrencyParameterSensitivity.class, List.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"marketDataName", "parameterMetadata", "currency", "sensitivity", "parameterSplit"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 842855857: {
                    return this.marketDataName;
                }
                case -1169106440: {
                    return this.parameterMetadata;
                }
                case 575402001: {
                    return this.currency;
                }
                case 564403871: {
                    return this.sensitivity;
                }
                case 1122130161: {
                    return this.parameterSplit;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends CurrencyParameterSensitivity> beanType() {
            return CurrencyParameterSensitivity.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<MarketDataName<?>> marketDataName() {
            return this.marketDataName;
        }

        public MetaProperty<ImmutableList<ParameterMetadata>> parameterMetadata() {
            return this.parameterMetadata;
        }

        public MetaProperty<Currency> currency() {
            return this.currency;
        }

        public MetaProperty<DoubleArray> sensitivity() {
            return this.sensitivity;
        }

        public MetaProperty<List<ParameterSize>> parameterSplit() {
            return this.parameterSplit;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 842855857: {
                    return ((CurrencyParameterSensitivity)bean).getMarketDataName();
                }
                case -1169106440: {
                    return ((CurrencyParameterSensitivity)bean).getParameterMetadata();
                }
                case 575402001: {
                    return ((CurrencyParameterSensitivity)bean).getCurrency();
                }
                case 564403871: {
                    return ((CurrencyParameterSensitivity)bean).getSensitivity();
                }
                case 1122130161: {
                    return ((CurrencyParameterSensitivity)bean).parameterSplit;
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

