/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.param;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.Guavate;
import com.opengamma.strata.collect.MapStream;
import com.opengamma.strata.data.MarketDataName;
import com.opengamma.strata.market.param.CurrencyParameterSensitivity;
import com.opengamma.strata.market.param.DatedParameterMetadata;
import com.opengamma.strata.market.param.ParameterMetadata;
import com.opengamma.strata.market.param.TenoredParameterMetadata;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.DoublePredicate;
import java.util.function.UnaryOperator;

final class CurrencyParameterSensitivityBuilder {
    private final MarketDataName<?> marketDataName;
    private final Currency currency;
    private final Map<ParameterMetadata, Double> sensitivity = new LinkedHashMap<ParameterMetadata, Double>();

    CurrencyParameterSensitivityBuilder(MarketDataName<?> marketDataName, Currency currency) {
        this.marketDataName = (MarketDataName)ArgChecker.notNull(marketDataName, (String)"marketDataName");
        this.currency = (Currency)ArgChecker.notNull((Object)currency, (String)"currency");
    }

    CurrencyParameterSensitivityBuilder add(ParameterMetadata metadata, double sensitivityValue) {
        if (metadata.equals(ParameterMetadata.empty())) {
            throw new IllegalArgumentException("Builder does not allow empty parameter metadata");
        }
        this.sensitivity.merge(metadata, sensitivityValue, Double::sum);
        return this;
    }

    CurrencyParameterSensitivityBuilder mapMetadata(UnaryOperator<ParameterMetadata> metadataFn) {
        ImmutableMap base = ImmutableMap.copyOf(this.sensitivity);
        this.sensitivity.clear();
        MapStream.of((Map)base).mapKeys(metadataFn).forEach((md, v) -> this.add((ParameterMetadata)md, (double)v));
        return this;
    }

    CurrencyParameterSensitivityBuilder mapSensitivity(BiFunction<ParameterMetadata, Double, Double> mapFn) {
        ImmutableMap base = ImmutableMap.copyOf(this.sensitivity);
        this.sensitivity.clear();
        MapStream.of((Map)base).mapValues(mapFn).forEach((md, v) -> this.add((ParameterMetadata)md, (double)v));
        return this;
    }

    CurrencyParameterSensitivityBuilder filterSensitivity(DoublePredicate predicate) {
        Iterator<Double> it = this.sensitivity.values().iterator();
        while (it.hasNext()) {
            Double value = it.next();
            if (predicate.test(value)) continue;
            it.remove();
        }
        return this;
    }

    boolean isEmpty() {
        return this.sensitivity.isEmpty();
    }

    CurrencyParameterSensitivity build() {
        ImmutableSet metadataTypes = (ImmutableSet)this.sensitivity.keySet().stream().map(Object::getClass).collect(Guavate.toImmutableSet());
        if (metadataTypes.size() == 1) {
            if (TenoredParameterMetadata.class.isAssignableFrom((Class)metadataTypes.iterator().next())) {
                ImmutableMap sorted = MapStream.of(this.sensitivity).sortedKeys(Comparator.comparing(k -> ((TenoredParameterMetadata)k).getTenor())).toMap();
                return CurrencyParameterSensitivity.of(this.marketDataName, this.currency, (Map<? extends ParameterMetadata, Double>)sorted);
            }
            if (DatedParameterMetadata.class.isAssignableFrom((Class)metadataTypes.iterator().next())) {
                ImmutableMap sorted = MapStream.of(this.sensitivity).sortedKeys(Comparator.comparing(k -> ((DatedParameterMetadata)k).getDate())).toMap();
                return CurrencyParameterSensitivity.of(this.marketDataName, this.currency, (Map<? extends ParameterMetadata, Double>)sorted);
            }
        }
        return CurrencyParameterSensitivity.of(this.marketDataName, this.currency, this.sensitivity);
    }
}

