/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.param;

import com.opengamma.strata.basics.date.Tenor;
import com.opengamma.strata.collect.tuple.Pair;
import com.opengamma.strata.market.param.ParameterMetadata;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutablePreBuild;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class TenorTenorParameterMetadata
implements ParameterMetadata,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final Tenor expiryTenor;
    @PropertyDefinition(validate="notNull")
    private final Tenor underlyingTenor;
    @PropertyDefinition(validate="notEmpty", overrideGet=true)
    private final String label;
    private static final long serialVersionUID = 1L;

    public static TenorTenorParameterMetadata of(Tenor expiryTenor, Tenor underlyingTenor) {
        String label = Pair.of((Object)expiryTenor, (Object)underlyingTenor).toString();
        return new TenorTenorParameterMetadata(expiryTenor, underlyingTenor, label);
    }

    public static TenorTenorParameterMetadata of(Tenor expiryTenor, Tenor underlyingTenor, String label) {
        return new TenorTenorParameterMetadata(expiryTenor, underlyingTenor, label);
    }

    @ImmutablePreBuild
    private static void preBuild(Builder builder) {
        if (builder.label == null) {
            builder.label = Pair.of((Object)builder.expiryTenor, (Object)builder.underlyingTenor).toString();
        }
    }

    public Pair<Tenor, Tenor> getIdentifier() {
        return Pair.of((Object)this.expiryTenor, (Object)this.underlyingTenor);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private TenorTenorParameterMetadata(Tenor expiryTenor, Tenor underlyingTenor, String label) {
        JodaBeanUtils.notNull((Object)expiryTenor, (String)"expiryTenor");
        JodaBeanUtils.notNull((Object)underlyingTenor, (String)"underlyingTenor");
        JodaBeanUtils.notEmpty((String)label, (String)"label");
        this.expiryTenor = expiryTenor;
        this.underlyingTenor = underlyingTenor;
        this.label = label;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public Tenor getExpiryTenor() {
        return this.expiryTenor;
    }

    public Tenor getUnderlyingTenor() {
        return this.underlyingTenor;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            TenorTenorParameterMetadata other = (TenorTenorParameterMetadata)obj;
            return JodaBeanUtils.equal((Object)this.expiryTenor, (Object)other.expiryTenor) && JodaBeanUtils.equal((Object)this.underlyingTenor, (Object)other.underlyingTenor) && JodaBeanUtils.equal((Object)this.label, (Object)other.label);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.expiryTenor);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.underlyingTenor);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.label);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("TenorTenorParameterMetadata{");
        buf.append("expiryTenor").append('=').append(JodaBeanUtils.toString((Object)this.expiryTenor)).append(',').append(' ');
        buf.append("underlyingTenor").append('=').append(JodaBeanUtils.toString((Object)this.underlyingTenor)).append(',').append(' ');
        buf.append("label").append('=').append(JodaBeanUtils.toString((Object)this.label));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<TenorTenorParameterMetadata> {
        private Tenor expiryTenor;
        private Tenor underlyingTenor;
        private String label;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 465802573: {
                    return this.expiryTenor;
                }
                case -824175261: {
                    return this.underlyingTenor;
                }
                case 102727412: {
                    return this.label;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 465802573: {
                    this.expiryTenor = (Tenor)newValue;
                    break;
                }
                case -824175261: {
                    this.underlyingTenor = (Tenor)newValue;
                    break;
                }
                case 102727412: {
                    this.label = (String)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public TenorTenorParameterMetadata build() {
            TenorTenorParameterMetadata.preBuild(this);
            return new TenorTenorParameterMetadata(this.expiryTenor, this.underlyingTenor, this.label);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(128);
            buf.append("TenorTenorParameterMetadata.Builder{");
            buf.append("expiryTenor").append('=').append(JodaBeanUtils.toString((Object)this.expiryTenor)).append(',').append(' ');
            buf.append("underlyingTenor").append('=').append(JodaBeanUtils.toString((Object)this.underlyingTenor)).append(',').append(' ');
            buf.append("label").append('=').append(JodaBeanUtils.toString((Object)this.label));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<Tenor> expiryTenor = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"expiryTenor", TenorTenorParameterMetadata.class, Tenor.class);
        private final MetaProperty<Tenor> underlyingTenor = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"underlyingTenor", TenorTenorParameterMetadata.class, Tenor.class);
        private final MetaProperty<String> label = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"label", TenorTenorParameterMetadata.class, String.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"expiryTenor", "underlyingTenor", "label"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 465802573: {
                    return this.expiryTenor;
                }
                case -824175261: {
                    return this.underlyingTenor;
                }
                case 102727412: {
                    return this.label;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends TenorTenorParameterMetadata> builder() {
            return new Builder();
        }

        public Class<? extends TenorTenorParameterMetadata> beanType() {
            return TenorTenorParameterMetadata.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<Tenor> expiryTenor() {
            return this.expiryTenor;
        }

        public MetaProperty<Tenor> underlyingTenor() {
            return this.underlyingTenor;
        }

        public MetaProperty<String> label() {
            return this.label;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 465802573: {
                    return ((TenorTenorParameterMetadata)bean).getExpiryTenor();
                }
                case -824175261: {
                    return ((TenorTenorParameterMetadata)bean).getUnderlyingTenor();
                }
                case 102727412: {
                    return ((TenorTenorParameterMetadata)bean).getLabel();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

