/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.market.sensitivity;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.collect.MapStream;
import com.opengamma.strata.market.curve.CurveName;
import com.opengamma.strata.market.param.CurrencyParameterSensitivities;
import com.opengamma.strata.market.param.CurrencyParameterSensitivitiesBuilder;
import com.opengamma.strata.market.param.CurrencyParameterSensitivity;
import com.opengamma.strata.market.param.ParameterMetadata;
import com.opengamma.strata.market.sensitivity.CurveSensitivities;
import com.opengamma.strata.market.sensitivity.CurveSensitivitiesType;
import com.opengamma.strata.product.PortfolioItemInfo;
import java.util.Map;
import java.util.TreeMap;

public final class CurveSensitivitiesBuilder {
    private PortfolioItemInfo info;
    private final Map<CurveSensitivitiesType, CurrencyParameterSensitivitiesBuilder> data = new TreeMap<CurveSensitivitiesType, CurrencyParameterSensitivitiesBuilder>();

    CurveSensitivitiesBuilder(PortfolioItemInfo info) {
        this.info = info;
    }

    CurveSensitivitiesBuilder combine(CurveSensitivitiesBuilder other) {
        this.info = this.info.combinedWith(other.info);
        other.data.forEach((type, map) -> this.add((CurveSensitivitiesType)((Object)type), map.build()));
        return this;
    }

    public CurveSensitivitiesBuilder add(CurveSensitivities other) {
        this.info = this.info.combinedWith(other.getInfo());
        other.getTypedSensitivities().forEach(this::add);
        return this;
    }

    public CurveSensitivitiesBuilder add(CurveSensitivitiesType type, CurrencyParameterSensitivities sensitivities) {
        this.data.computeIfAbsent(type, t -> CurrencyParameterSensitivities.builder()).add(sensitivities);
        return this;
    }

    public CurveSensitivitiesBuilder add(CurveSensitivitiesType type, CurrencyParameterSensitivity sensitivity) {
        this.data.computeIfAbsent(type, t -> CurrencyParameterSensitivities.builder()).add(sensitivity);
        return this;
    }

    public CurveSensitivitiesBuilder add(CurveSensitivitiesType type, CurveName curveName, Currency currency, ParameterMetadata metadata, double sensitivityValue) {
        this.data.computeIfAbsent(type, t -> CurrencyParameterSensitivities.builder()).add(curveName, currency, metadata, sensitivityValue);
        return this;
    }

    public CurveSensitivities build() {
        return CurveSensitivities.of(this.info, (Map<CurveSensitivitiesType, CurrencyParameterSensitivities>)MapStream.of(this.data).mapValues(CurrencyParameterSensitivitiesBuilder::build).toMap());
    }
}

